import random

from header_common import *
from header_items import *
from header_troops import *
from header_skills import *
from ID_factions import *
from ID_items import *
from ID_scenes import *

####################################################################################################################
#  Each troop contains the following fields:
#  1) Troop id (string): used for referencing troops in other files. The prefix trp_ is automatically added before each troop-id .
#  2) Toop name (string).
#  3) Plural troop name (string).
#  4) Troop flags (int). See header_troops.py for a list of available flags
#  5) Scene (int) (only applicable to heroes) For example: scn_reyvadin_castle|entry(1) puts troop in reyvadin castle's first entry point
#  6) Reserved (int). Put constant "reserved" or 0.
#  7) Faction (int)
#  8) Inventory (list): Must be a list of items
#  9) Attributes (int): Example usage:
#           str_6|agi_6|int_4|cha_5|level(5)
# 10) Weapon proficiencies (int): Example usage:
#           wp_one_handed(55)|wp_two_handed(90)|wp_polearm(36)|wp_archery(80)|wp_crossbow(24)|wp_throwing(45)
#     The function wp(x) will create random weapon proficiencies close to value x.
#     To make an expert archer with other weapon proficiencies close to 60 you can use something like:
#           wp_archery(160) | wp(60)
# 11) Skills (int): See header_skills.py to see a list of skills. Example:
#           knows_ironflesh_3|knows_power_strike_2|knows_athletics_2|knows_riding_2
# 12) Face code (int): You can obtain the face code by pressing ctrl+E in face generator screen
# 13) Face code (int)(2) (only applicable to regular troops, can be omitted for heroes):
#     The game will create random faces between Face code 1 and face code 2 for generated troops
# 14) Troop image (string): If this variable is set, the troop will use an image rather than its 3D visual during the conversations
#  town_1   Sargoth
#  town_2   Tihr
#  town_3   Veluca
#  town_4   Suno
#  town_5   Jelkala
#  town_6   Praven
#  town_7   Uxkhal
#  town_8   Reyvadin
#  town_9   Khudan
#  town_10  Tulga
#  town_11  Curaw
#  town_12  Wercheg
#  town_13  Rivacheg
#  town_14  Halmar
####################################################################################################################

# Some constant and function declarations to be used below... 
# wp_one_handed () | wp_two_handed () | wp_polearm () | wp_archery () | wp_crossbow () | wp_throwing ()
def wp(x):
  n = 0
  r = 10 + int(x / 10)
#  n |= wp_one_handed(x + random.randrange(r))
#  n |= wp_two_handed(x + random.randrange(r))
#  n |= wp_polearm(x + random.randrange(r))
#  n |= wp_archery(x + random.randrange(r))
#  n |= wp_crossbow(x + random.randrange(r))
#  n |= wp_throwing(x + random.randrange(r))
  n |= wp_one_handed(x)
  n |= wp_two_handed(x)
  n |= wp_polearm(x)
  n |= wp_archery(x)
  n |= wp_crossbow(x)
  n |= wp_throwing(x)
  return n

def wpe(m,a,c,t):
   n = 0
   n |= wp_one_handed(m)
   n |= wp_two_handed(m)
   n |= wp_polearm(m)
   n |= wp_archery(a)
   n |= wp_crossbow(c)
   n |= wp_throwing(t)
   return n

def wpex(o,w,p,a,c,t):
   n = 0
   n |= wp_one_handed(o)
   n |= wp_two_handed(w)
   n |= wp_polearm(p)
   n |= wp_archery(a)
   n |= wp_crossbow(c)
   n |= wp_throwing(t)
   return n
   
def wp_melee(x):
  n = 0
  r = 10 + int(x / 10)
#  n |= wp_one_handed(x + random.randrange(r))
#  n |= wp_two_handed(x + random.randrange(r))
#  n |= wp_polearm(x + random.randrange(r))
  n |= wp_one_handed(x + 20)
  n |= wp_two_handed(x)
  n |= wp_polearm(x + 10)
  return n

#Skills
knows_common = knows_riding_1|knows_trade_2|knows_inventory_management_2|knows_prisoner_management_1|knows_leadership_1
def_attrib = str_7 | agi_5 | int_4 | cha_4
def_attrib_multiplayer = str_14 | agi_14 | int_4 | cha_4

knows_warrior_npc = knows_weapon_master_2|knows_ironflesh_1|knows_athletics_1|knows_power_strike_2|knows_riding_2|knows_shield_1|knows_inventory_management_2
knows_merchant_npc = knows_riding_2|knows_trade_3|knows_inventory_management_3 #knows persuasion
knows_tracker_npc = knows_weapon_master_1|knows_athletics_2|knows_spotting_2|knows_pathfinding_2|knows_tracking_2|knows_ironflesh_1|knows_inventory_management_2

## CC
lord_attrib = str_20|agi_20|int_20|cha_20|level(38)
knows_lord_1 = knows_riding_3|knows_trade_2|knows_inventory_management_2|knows_tactics_4|knows_prisoner_management_4|knows_leadership_7|knows_pathfinding_5
knight_attrib_1 = str_15|agi_14|int_8|cha_16|level(22)
knight_attrib_2 = str_16|agi_16|int_10|cha_18|level(26)
knight_attrib_3 = str_18|agi_17|int_12|cha_20|level(30)
knight_attrib_4 = str_19|agi_19|int_13|cha_22|level(35)
knight_attrib_5 = str_20|agi_20|int_15|cha_25|level(41)
knight_skills_1 = knows_riding_3|knows_ironflesh_2|knows_power_strike_3|knows_athletics_1|knows_tactics_2|knows_prisoner_management_1|knows_leadership_3|knows_pathfinding_3
knight_skills_2 = knows_riding_4|knows_ironflesh_3|knows_power_strike_4|knows_athletics_2|knows_tactics_3|knows_prisoner_management_2|knows_leadership_5|knows_pathfinding_4
knight_skills_3 = knows_riding_5|knows_ironflesh_4|knows_power_strike_5|knows_athletics_3|knows_tactics_4|knows_prisoner_management_2|knows_leadership_6|knows_pathfinding_4
knight_skills_4 = knows_riding_6|knows_ironflesh_5|knows_power_strike_6|knows_athletics_4|knows_tactics_5|knows_prisoner_management_3|knows_leadership_7|knows_pathfinding_4
knight_skills_5 = knows_riding_7|knows_ironflesh_6|knows_power_strike_7|knows_athletics_5|knows_tactics_6|knows_prisoner_management_3|knows_leadership_9|knows_pathfinding_5
## CC

#These face codes are generated by the in-game face generator.
#Enable edit mode and press ctrl+E in face generator screen to obtain face codes.


reserved = 0

no_scene = 0

swadian_face_younger_1 = 0x0000000000000001124000000020000000000000001c00800000000000000000
swadian_face_young_1   = 0x0000000400000001124000000020000000000000001c00800000000000000000
swadian_face_middle_1  = 0x0000000800000001124000000020000000000000001c00800000000000000000
swadian_face_old_1     = 0x0000000d00000001124000000020000000000000001c00800000000000000000
swadian_face_older_1   = 0x0000000fc0000001124000000020000000000000001c00800000000000000000

swadian_face_younger_2 = 0x00000000000062c76ddcdf7feefbffff00000000001efdbc0000000000000000
swadian_face_young_2   = 0x00000003c00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
swadian_face_middle_2  = 0x00000007c00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
swadian_face_old_2     = 0x0000000bc00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
swadian_face_older_2   = 0x0000000fc00062c76ddcdf7feefbffff00000000001efdbc0000000000000000

vaegir_face_younger_1 = 0x0000000000000001124000000020000000000000001c00800000000000000000
vaegir_face_young_1   = 0x0000000400000001124000000020000000000000001c00800000000000000000
vaegir_face_middle_1  = 0x0000000800000001124000000020000000000000001c00800000000000000000
vaegir_face_old_1     = 0x0000000d00000001124000000020000000000000001c00800000000000000000
vaegir_face_older_1   = 0x0000000fc0000001124000000020000000000000001c00800000000000000000

vaegir_face_younger_2 = 0x000000003f00230c4deeffffffffffff00000000001efff90000000000000000
vaegir_face_young_2   = 0x00000003bf00230c4deeffffffffffff00000000001efff90000000000000000
vaegir_face_middle_2  = 0x00000007bf00230c4deeffffffffffff00000000001efff90000000000000000
vaegir_face_old_2     = 0x0000000cbf00230c4deeffffffffffff00000000001efff90000000000000000
vaegir_face_older_2   = 0x0000000ff100230c4deeffffffffffff00000000001efff90000000000000000

khergit_face_younger_1 = 0x00000001bf1040063b1329baebae6cdc00000000001db9340000000000000000
khergit_face_young_1   = 0x00000001bf0045c1549b99daebb5152400000000001eb9360000000000000000
khergit_face_middle_1  = 0x00000001bf10458b47b592a54a92490a00000000001d5b5b0000000000000000
khergit_face_old_1     = 0x00000001bf0c424f47214ccadb8a528e00000000001cc2ec0000000000000000
khergit_face_older_1   = 0x0000000ff30043466793d1395b6da91400000000001dc6dd0000000000000000

khergit_face_younger_2 = 0x000000003f08415144de51b37591d70b00000000001da5630000000000000000 
khergit_face_young_2   = 0x000000003f08658f265bd4cceab9e2d300000000001ebc930000000000000000
khergit_face_middle_2  = 0x00000000301032d1399e14cd153120e400000000001e15630000000000000000
khergit_face_old_2     = 0x000000003f10428f19186ec90a2958d500000000001d42b30000000000000000 
khergit_face_older_2   = 0x0000000ffd044243266b762a5a6da2db00000000001dbad20000000000000000

nord_face_younger_1 = 0x0000000000000001124000000020000000000000001c00800000000000000000
nord_face_young_1   = 0x0000000400000001124000000020000000000000001c00800000000000000000
nord_face_middle_1  = 0x0000000800000001124000000020000000000000001c00800000000000000000
nord_face_old_1     = 0x0000000d00000001124000000020000000000000001c00800000000000000000
nord_face_older_1   = 0x0000000fc0000001124000000020000000000000001c00800000000000000000

nord_face_younger_2 = 0x00000000310023084deeffffffffffff00000000001efff90000000000000000
nord_face_young_2   = 0x00000003b10023084deeffffffffffff00000000001efff90000000000000000
nord_face_middle_2  = 0x00000008310023084deeffffffffffff00000000001efff90000000000000000
nord_face_old_2     = 0x0000000c710023084deeffffffffffff00000000001efff90000000000000000
nord_face_older_2   = 0x0000000ff10023084deeffffffffffff00000000001efff90000000000000000

rhodok_face_younger_1 = 0x0000000009002003140000000000000000000000001c80400000000000000000
rhodok_face_young_1   = 0x0000000449002003140000000000000000000000001c80400000000000000000
rhodok_face_middle_1  = 0x0000000849002003140000000000000000000000001c80400000000000000000
rhodok_face_old_1     = 0x0000000cc9002003140000000000000000000000001c80400000000000000000
rhodok_face_older_1   = 0x0000000fc9002003140000000000000000000000001c80400000000000000000

rhodok_face_younger_2 = 0x00000000000062c76ddcdf7feefbffff00000000001efdbc0000000000000000
rhodok_face_young_2   = 0x00000003c00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
rhodok_face_middle_2  = 0x00000007c00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
rhodok_face_old_2     = 0x0000000bc00062c76ddcdf7feefbffff00000000001efdbc0000000000000000
rhodok_face_older_2   = 0x0000000fc00062c76ddcdf7feefbffff00000000001efdbc0000000000000000

man_face_younger_1 = 0x00000001bf1040063b1329baebae6cdc00000000001db9340000000000000000
man_face_young_1   = 0x00000001bf0045c1549b99daebb5152400000000001eb9360000000000000000
man_face_middle_1  = 0x00000001bf10458b47b592a54a92490a00000000001d5b5b0000000000000000
man_face_old_1     = 0x00000001bf0c424f47214ccadb8a528e00000000001cc2ec0000000000000000
man_face_older_1   = 0x0000000ff30043466793d1395b6da91400000000001dc6dd0000000000000000

man_face_younger_2 = 0x000000003f08415144de51b37591d70b00000000001da5630000000000000000 
man_face_young_2   = 0x000000003f08658f265bd4cceab9e2d300000000001ebc930000000000000000
man_face_middle_2  = 0x00000000301032d1399e14cd153120e400000000001e15630000000000000000
man_face_old_2     = 0x000000003f10428f19186ec90a2958d500000000001d42b30000000000000000 
man_face_older_2   = 0x0000000ffd044243266b762a5a6da2db00000000001dbad20000000000000000

merchant_face_1    = man_face_young_1
merchant_face_2    = man_face_older_2

woman_face_1 = 0x0000000180103006124925124928924900000000001c92890000000000000000
woman_face_2 = 0x00000001af1030025b6eb6dd6db6dd6d00000000001eedae0000000000000000

swadian_woman_face_1 = 0x0000000180102006124925124928924900000000001c92890000000000000000
swadian_woman_face_2 = 0x00000001bf1000061db6d75db6b6dbad00000000001c92890000000000000000

khergit_woman_face_1 = 0x0000000180103006124925124928924900000000001c92890000000000000000
khergit_woman_face_2 = 0x00000001af1030025b6eb6dd6db6dd6d00000000001eedae0000000000000000

refugee_face1 = woman_face_1
refugee_face2 = woman_face_2
girl_face1    = woman_face_1
girl_face2    = woman_face_2

mercenary_face_1 = khergit_face_middle_1
mercenary_face_2 = khergit_face_old_2

vaegir_face1  = vaegir_face_young_1
vaegir_face2  = vaegir_face_older_2

bandit_face1  = man_face_young_1
bandit_face2  = man_face_older_2

undead_face1  = 0x00000000002000000000000000000000
undead_face2  = 0x000000000020010000001fffffffffff

#NAMES:
#

tf_guarantee_all = tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield|tf_guarantee_ranged
tf_guarantee_all_wo_ranged = tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield


troops = [
  ["player","Player","Player",tf_hero|tf_unmoveable_in_party_window,no_scene,reserved,fac_player_faction,
   [],
   str_4|agi_4|int_4|cha_4,wp(15),0,0x000000018000000136db6db6db6db6db00000000001db6db0000000000000000],
  ["multiplayer_profile_troop_male","multiplayer_profile_troop_male","multiplayer_profile_troop_male", tf_hero|tf_guarantee_all, 0, 0,fac_commoners,
   [itm_leather_jerkin, itm_leather_boots],
   0, 0, 0, 0x000000018000000136db6db6db6db6db00000000001db6db0000000000000000],
  ["multiplayer_profile_troop_female","multiplayer_profile_troop_female","multiplayer_profile_troop_female", tf_hero|tf_female|tf_guarantee_all, 0, 0,fac_commoners,
   [itm_tribal_warrior_outfit, itm_leather_boots],
   0, 0, 0, 0x000000018000000136db6db6db6db6db00000000001db6db0000000000000000],
  ["temp_troop","Temp Troop","Temp Troop",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
##  ["game","Game","Game",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common,0],
##  ["unarmed_troop","Unarmed Troop","Unarmed Troops",tf_hero,no_scene,reserved,fac_commoners,[itm_arrows,itm_short_bow],def_attrib|str_14,0,knows_common|knows_power_draw_2,0],

####################################################################################################################
# Troops before this point are hardwired into the game and their order should not be changed!
####################################################################################################################
  ["find_item_cheat","find_item_cheat","find_item_cheat",tf_hero|tf_is_merchant,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
  ["random_town_sequence","Random Town Sequence","Random Town Sequence",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
  ["tournament_participants","Tournament Participants","Tournament Participants",tf_hero,no_scene,reserved,fac_commoners,[],def_attrib,0,knows_common|knows_inventory_management_10,0],
  ["tutorial_maceman","Maceman","Maceman",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_tutorial_club,itm_leather_jerkin,itm_hide_boots],
   str_6|agi_6|level(1),wp(50),knows_common,mercenary_face_1,mercenary_face_2],
  ["tutorial_archer","Archer","Archer",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_commoners,
   [itm_tutorial_short_bow,itm_tutorial_arrows,itm_leather_jerkin,itm_hide_boots],
   str_6|agi_6|level(5),wp(100),knows_common|knows_power_draw_4,mercenary_face_1,mercenary_face_2],
  ["tutorial_swordsman","Swordsman","Swordsman",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_tutorial_sword,itm_leather_jerkin,itm_hide_boots],
   str_6|agi_6|level(5),wp(80),knows_common,mercenary_face_1,mercenary_face_2],

  ["novice_fighter","Novice Fighter","Novice Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_6|agi_6|level(5),wp(60),knows_common,mercenary_face_1, mercenary_face_2],
  ["regular_fighter","Regular Fighter","Regular Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_8|agi_8|level(11),wp(90),knows_common|knows_ironflesh_1|knows_power_strike_1|knows_athletics_1|knows_riding_1|knows_shield_2,mercenary_face_1, mercenary_face_2],
  ["veteran_fighter","Veteran Fighter","Veteran Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,0,fac_commoners,
   [itm_hide_boots],
   str_10|agi_10|level(17),wp(110),knows_common|knows_ironflesh_3|knows_power_strike_2|knows_athletics_2|knows_riding_2|knows_shield_3,mercenary_face_1, mercenary_face_2],
  ["champion_fighter","Champion Fighter","Champion Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_12|agi_11|level(22),wp(140),knows_common|knows_ironflesh_4|knows_power_strike_3|knows_athletics_3|knows_riding_3|knows_shield_4,mercenary_face_1, mercenary_face_2],

  ["arena_training_fighter_1","Novice Fighter","Novice Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_6|agi_6|level(5),wp(60),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_2","Novice Fighter","Novice Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_7|agi_6|level(7),wp(70),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_3","Regular Fighter","Regular Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_8|agi_7|level(9),wp(80),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_4","Regular Fighter","Regular Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_8|agi_8|level(11),wp(90),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_5","Regular Fighter","Regular Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_9|agi_8|level(13),wp(100),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_6","Veteran Fighter","Veteran Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_10|agi_9|level(15),wp(110),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_7","Veteran Fighter","Veteran Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_10|agi_10|level(17),wp(120),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_8","Veteran Fighter","Veteran Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_11|agi_10|level(19),wp(130),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_9","Champion Fighter","Champion Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_12|agi_11|level(21),wp(140),knows_common,mercenary_face_1, mercenary_face_2],
  ["arena_training_fighter_10","Champion Fighter","Champion Fighters",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hide_boots],
   str_12|agi_12|level(23),wp(150),knows_common,mercenary_face_1, mercenary_face_2],

  ["cattle","Cattle","Cattle",0,no_scene,reserved,fac_neutral, [], def_attrib|level(1),wp(60),0,mercenary_face_1, mercenary_face_2],


#soldiers:
#This troop is the troop marked as soldiers_begin
  ["farmer","Farmer","Farmers",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hatchet,itm_club,itm_pitch_fork,itm_dagger,itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_middle_1, khergit_face_old_2],
  ["townsman","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_hatchet,itm_club,itm_pitch_fork,itm_dagger,itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_middle_1, khergit_face_old_2],
## CC
  ["refugee","Refugee","Refugees",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_hatchet,itm_club,itm_pitch_fork,itm_dagger,itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(1),wp(45),knows_common,khergit_woman_face_1,khergit_woman_face_2],
  ["peasant_woman","Peasant Woman","Peasant Women",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_hatchet,itm_club,itm_pitch_fork,itm_dagger,itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(1),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],
  ["follower_woman","Camp Follower","Camp Follower",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_bolts,itm_light_crossbow,itm_hatchet,itm_dagger,itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(5),wp(70),knows_common,khergit_woman_face_1,khergit_woman_face_2],
  ["hunter_woman","Huntress","Huntresses",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_arrows,itm_hunting_bow,itm_hatchet,itm_dagger,itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_boots_light_sar1,itm_boots_light_sar2, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(10),wp(85),knows_common|knows_power_strike_1,khergit_woman_face_1,khergit_woman_face_2],
#  ["fighter_woman","Camp Defender","Camp Defenders",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
#   [],
#   def_attrib|level(16),wp(100),knows_common|knows_riding_3|knows_power_strike_2|knows_athletics_2|knows_ironflesh_1,refugee_face1,refugee_face2],
#  ["sword_sister","Religious Fanatic","Sword Sisters",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
#   [],
#   def_attrib|level(22),wp(140),knows_common|knows_power_strike_3|knows_riding_5|knows_athletics_3|knows_ironflesh_2|knows_shield_2,refugee_face1,refugee_face2],
## CC 
  ["watchman","Watchman","Watchmen",tf_mounted|tf_guarantee_horse|tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,itm_camel,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10],
   def_attrib|level(9),wp(75),knows_common|knows_riding_4,khergit_face_younger_1, khergit_face_middle_2],
  ["caravan_guard","Caravan Guard","Caravan Guards",tf_guarantee_helmet|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,no_scene,0,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_camel,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_light_sar1,itm_boots_light_sar2],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],
  ["mercenary_swordsman","Mercenary Infantry","Mercenary Infantry",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,no_scene,reserved,fac_commoners,
   [itm_fighting_axe,itm_falchion_sar,itm_muslim_pike1,itm_muslim_pike,itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,
    itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
  ["hired_blade","Mercenary Guard","Mercenary Guards",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,no_scene,reserved,fac_commoners,
   [itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_sword_arabian_small,itm_muslim_pike1,itm_muslim_pike,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_old_2],
  ["mercenary_crossbowman","Mercenary Archer","Mercenary Archers",tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged,no_scene,reserved,fac_commoners,
   [itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_fighting_axe,itm_falchion_sar,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5],
   def_attrib|level(18),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_power_draw_3|knows_ironflesh_1|knows_power_throw_3,khergit_face_young_1, khergit_face_middle_2],
  ["mercenary_horseman","Armored Caravan Guard","Armored Caravan Guards",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,
    itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_camel],
   def_attrib|level(18),wp_melee(105),knows_common|knows_riding_4|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
  ["mercenary_cavalry","Mercenary Horseman","Mercenary Horsemen",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,no_scene,reserved,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,
    itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_arabian1,itm_arabian2,itm_arabian3,itm_arabian4],
   def_attrib|level(21),wp_melee(125)| wp_archery (100),knows_common|knows_riding_5|knows_ironflesh_3|knows_shield_3|knows_power_strike_3,khergit_face_young_1, khergit_face_old_2],
## CC
  ["manhunter","Turcopole","Turcopoles",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet ,0,0,fac_manhunters,
   [itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_sword_medieval_a,itm_sword_medieval_a1,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(14),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_middle_2],
  ["slave_driver","Hardened Turcopole","Hardened Turcopoles",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet ,0,0,fac_manhunters,
   [itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_sword_medieval_a,itm_sword_medieval_a1,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(18),wp_one_handed (100) | wp_two_handed (100) | wp_polearm (100) | wp_archery (125) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["slave_hunter","Veteran Turcopole","Veteran Turcopoles",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet ,0,0,fac_manhunters,
   [itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_sword_medieval_a,itm_sword_medieval_a1,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,
    itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_one_handed (110) | wp_two_handed (110) | wp_polearm (110) | wp_archery (150) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_7|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
#  ["slave_crusher","Slave Crusher","Slave Crushers",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield ,0,0,fac_manhunters,
#   [],
#   def_attrib|level(22),wp(110),knows_common|knows_riding_4|knows_power_strike_3,bandit_face1, bandit_face2],
#  ["slaver_chief","Slaver Chief","Slaver Chiefs",tf_mounted|tf_guarantee_all_wo_ranged,0,0,fac_manhunters,
#   [],
#   def_attrib|level(26),wp(130),knows_common|knows_riding_4|knows_power_strike_5,bandit_face1, bandit_face2],
## CC 
  ["mercenaries_end","mercenaries_end","mercenaries_end",0,no_scene,reserved,fac_commoners,
   [],
   def_attrib|level(4),wp(60),knows_common,khergit_face_young_1, khergit_face_old_2],

#peasant - retainer - footman - man-at-arms -  knight
  ["jerusalem_militia","Jerusalem Armed Pilgrim","Jerusalem Armed Pilgrims",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_pike,itm_cross_jer,itm_cross_jer1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_ibe,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(9),wp(75),knows_common,swadian_face_younger_1, swadian_face_middle_2],
  ["jerusalem_footman","Jerusalem Footman","Jerusalem Footmen",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_pike,itm_cross_jer,itm_cross_jer1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_jer,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["jerusalem_infantry","Jerusalem Infantry","Jerusalem Infantry",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_jer,itm_pike_banner_jer1,itm_ashwood_pike,itm_shield_veteran_jer1,itm_shield_veteran_jer2,itm_shield_veteran_jer3,itm_shield_veteran_jer4,
    itm_infantry_jer1,itm_infantry_jer2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["jerusalem_sergeant","Jerusalem Sergeant","Jerusalem Sergeants",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_sword_medieval_b_small,itm_axe_cru4,itm_sword_medieval_b_small1,itm_pike,itm_pike_banner_jer,itm_pike_banner_jer1,itm_ashwood_pike,itm_shield_veteran_jer5,itm_shield_veteran_jer6,itm_shield_veteran_jer7,itm_shield_veteran_jer8,
    itm_sergeant_jer1,itm_mail_boots2,itm_leather_gloves,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["jerusalem_crossbowman","Jerusalem Crossbowman","Jerusalem Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_1,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_ibe1,itm_shield_archer_ibe2,itm_shield_archer_ibe3,itm_shield_archer_ibe4,
    itm_archer_ibe1,itm_archer_ibe2,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common|knows_ironflesh_1,swadian_face_young_1, swadian_face_middle_2],
  ["jerusalem_veteran_crossbowman","Jerusalem Veteran Crossbowman","Jerusalem Veteran Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_1,
   [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_jer1,itm_shield_archer_jer2,itm_shield_archer_jer3,itm_shield_archer_jer4,
    itm_archer_jer1,itm_archer_jer2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_ironflesh_1|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
  ["jerusalem_squire","Knight","Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_1,
   [itm_heavy_lance,itm_lance_banner_ibe,itm_lance_banner_ibe1,itm_lance_banner_ibe3,itm_lance_banner_ibe2,itm_heavy_lance,itm_sword_medieval_a2,itm_sword_medieval_a1,itm_shield_knight_ibe1,itm_shield_knight_ibe2,itm_horse_ibe1,itm_horse_ibe2,itm_horse_ibe3,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_ibe1,itm_knight_ibe2,itm_knight_ibe3,itm_knight_ibe4,itm_knight_ibe5,itm_knight_ibe6,itm_mail_boots1,itm_mail_mittens1,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm1,itm_helm2],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_young_1, swadian_face_old_2],
  ["jerusalem_knight","Knight of Jerusalem","Knights of Jerusalem",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_1,
   [itm_heavy_lance,itm_lance_banner_jer,itm_lance_banner_jer1,itm_lance_banner_jer3,itm_lance_banner_jer2,itm_heavy_lance,itm_sword_medieval_a2,itm_sword_medieval_a1,itm_shield_knight_jer1,itm_shield_knight_jer2,itm_shield_knight_jer3,itm_shield_knight_jer4,itm_shield_knight_jer5,itm_shield_knight_jer6,itm_shield_knight_jer7,itm_shield_knight_jer8,itm_horse_jer1,itm_horse_jer2,itm_horse_jer3,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_jer1,itm_knight_jer2,itm_knight_jer3,itm_knight_jer4,itm_knight_jer5,itm_knight_jer6,itm_knight_jer7,itm_knight_jer8,itm_knight_jer9,itm_mail_boots1,itm_mail_mittens1,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_jer,itm_helm_jer1,itm_helm_jer2],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_7|knows_ironflesh_7|knows_power_strike_7,swadian_face_middle_1, swadian_face_older_2],

   ["swadian_messenger","Jerusalem Messenger","Jerusalem Messengers",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_sword_medieval_a1,itm_sergeant_jer1,itm_mail_boots1,itm_hunter1,itm_helmet1],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,swadian_face_young_1, swadian_face_old_2],
  ["swadian_deserter","Jerusalem Deserter","Jerusalem Deserters",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_deserters,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_shield_veteran_jer1,itm_shield_veteran_jer2,itm_shield_veteran_jer3,itm_shield_veteran_jer4,itm_novici_jer,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_2|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["swadian_prison_guard","Castle Guard","Castle Guards",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_1,
   [itm_sword_arabian_small,itm_securiti_jer1,itm_securiti_jer2,itm_securiti_boots_jer,itm_securit_helmet_jer1,itm_securit_helmet_jer2,itm_securiti_shield_jer],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],
  ["swadian_castle_guard","Castle Guard","Castle Guards",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_1,
   [itm_sword_arabian_small,itm_securiti_jer1,itm_securiti_jer2,itm_securiti_boots_jer,itm_securit_helmet_jer1,itm_securit_helmet_jer2,itm_securiti_shield_jer],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],

  ["swadian_paladin", "Jerusalem Camel Guard", "Jerusalem Camel Guards",tf_mounted|tf_guarantee_horse|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_lance_sar,itm_heavy_lance,itm_heavy_lance,itm_lance_sar1,itm_lance_sar2,itm_scimitar,itm_scimitar1,itm_securiti_shield_jer,itm_camel,
    itm_special_jer1,itm_special_jer2,itm_special_boots_jer,itm_special_helmet_jer1,itm_special_helmet_jer2],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,khergit_face_middle_1, khergit_face_older_2], 
  ["swadian_priest", "Jerusalem Palace Guard", "Jerusalem Palace Guards",tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,
   [itm_muslim_pike1,itm_pike,itm_pike,itm_muslim_pike,itm_scimitar,itm_scimitar1,itm_securiti_shield_jer,
    itm_special_jer1,itm_special_jer2,itm_special_boots_jer,itm_special_helmet_jer1,itm_special_helmet_jer2],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],    
 
# Vaegir watchman?
  ["antioch_militia","Antioch Armed Pilgrim","Antioch Armed Pilgrims",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_pike,itm_cross_ant,itm_cross_ant1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_tri,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(9),wp(75),knows_common,swadian_face_younger_1, swadian_face_middle_2],
  ["antioch_footman","Antioch Footman","Antioch Footmen",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_pike,itm_cross_ant,itm_cross_ant1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_ant,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["antioch_infantry","Antioch Infantry","Antioch Infantry",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_ant,itm_pike_banner_ant1,itm_ashwood_pike,itm_shield_veteran_ant1,itm_shield_veteran_ant2,itm_shield_veteran_ant3,itm_shield_veteran_ant4,
    itm_infantry_ant1,itm_infantry_ant2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["antioch_sergeant","Antioch Sergeant","Antioch Sergeants",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_sword_medieval_a2,itm_axe_cru4,itm_sword_medieval_a1,itm_pike,itm_pike_banner_ant,itm_pike_banner_ant1,itm_ashwood_pike,itm_shield_veteran_ant5,itm_shield_veteran_ant6,itm_shield_veteran_ant7,itm_shield_veteran_ant8,itm_sergeant_ant1,itm_sergeant_ant2,
    itm_sword_medieval_b_small,itm_sword_medieval_b_small1,itm_mail_boots2,itm_leather_gloves,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["antioch_crossbowman","Antioch Crossbowman","Antioch Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_2,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_tri1,itm_shield_archer_tri2,itm_shield_archer_tri3,itm_shield_archer_tri4,
    itm_archer_tri1,itm_archer_tri2,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(14),wp(80)| wp_crossbow (100),knows_common|knows_ironflesh_1,swadian_face_young_1, swadian_face_middle_2],
  ["antioch_veteran_crossbowman","Antioch Veteran Crossbowman","Antioch Veteran Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_2,
   [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_ant1,itm_shield_archer_ant2,itm_shield_archer_ant3,itm_shield_archer_ant4,
    itm_archer_ant1,itm_archer_ant2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_ironflesh_1|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
  ["antioch_squire","Knight","Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_heavy_lance,itm_lance_banner_tri,itm_lance_banner_tri1,itm_lance_banner_tri3,itm_lance_banner_tri2,itm_heavy_lance,itm_sword_medieval_a2,itm_sword_medieval_a1,itm_shield_knight_tri1,itm_shield_knight_tri2,itm_shield_knight_tri3,itm_shield_knight_tri4,itm_shield_knight_tri5,itm_shield_knight_tri6,itm_shield_knight_tri7,itm_shield_knight_tri8,itm_shield_knight_tri9,itm_horse_tri1,itm_horse_tri2,itm_horse_tri3,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_tri1,itm_knight_tri2,itm_knight_tri3,itm_knight_tri4,itm_knight_tri5,itm_knight_tri6,itm_mail_boots1,itm_mail_mittens1,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm1,itm_helm2],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_young_1, swadian_face_old_2],
  ["antioch_knight","Knight of Antioch","Knights of Antioch",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_heavy_lance,itm_lance_banner_ant,itm_lance_banner_ant1,itm_lance_banner_ant3,itm_lance_banner_ant2,itm_heavy_lance,itm_sword_medieval_a2,itm_sword_medieval_a1,itm_shield_knight_ant1,itm_shield_knight_ant2,itm_shield_knight_ant3,itm_shield_knight_ant4,itm_shield_knight_ant5,itm_shield_knight_ant6,itm_shield_knight_ant7,itm_shield_knight_ant8,itm_shield_knight_ant9,itm_horse_ant1,itm_horse_ant2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_ant1,itm_knight_ant2,itm_knight_ant3,itm_knight_ant4,itm_knight_ant5,itm_knight_ant6,itm_knight_ant7,itm_knight_ant8,itm_knight_ant9,itm_knight_ant10,itm_mail_boots1,itm_mail_mittens1,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_red,itm_helm_ord_red],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_7|knows_ironflesh_7|knows_power_strike_7,swadian_face_middle_1, swadian_face_older_2],

   ["vaegir_messenger","Antioch Messenger","Antioch Messengers",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_sword_medieval_a2,itm_sergeant_ant1,itm_mail_boots1,itm_hunter1,itm_helmet1],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,swadian_face_young_1, swadian_face_old_2],
  ["vaegir_deserter","Antioch Deserter","Antioch Deserters",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_shield_veteran_ant1,itm_shield_veteran_ant2,itm_shield_veteran_ant3,itm_shield_veteran_ant4,itm_novici_ant,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_2|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["vaegir_prison_guard","Castle Guard","Castle Guards",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_sword_medieval_b_small,itm_sword_medieval_b_small1,itm_sergeant_ant1,itm_sergeant_ant2,itm_mail_boots2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_shield_veteran_ant5],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["vaegir_castle_guard","Castle Guard","Castle Guards",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_sword_medieval_b_small,itm_sword_medieval_b_small1,itm_sergeant_ant1,itm_sergeant_ant2,itm_mail_boots2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_shield_veteran_ant5],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],

  ["vaegir_ivory_sentinel", "Antioch Norman Knight", "Antioch Norman Knights",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,
   [itm_heavy_lance,itm_heavy_lance,itm_heavy_lance,itm_sword_medieval_a2,itm_sword_medieval_a1,itm_shield_knight_ant1,itm_shield_knight_ant2,itm_shield_knight_ant3,itm_shield_knight_ant4,itm_shield_knight_ant5,itm_shield_knight_ant6,itm_shield_knight_ant7,itm_shield_knight_ant8,itm_shield_knight_ant9,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_mercenary1,itm_knight_mercenary2,itm_mail_boots1,itm_helm_mercenary],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_middle_1, swadian_face_older_2], 
  ["vaegir_knyaz", "Antioch Dismounted Knight", "Antioch Dismounted Knights",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_kingdom_2,
   [itm_sword_medieval_a2,itm_sword_medieval_a1,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_knight_ant1,itm_shield_knight_ant2,itm_shield_knight_ant3,itm_shield_knight_ant4,itm_shield_knight_ant5,itm_shield_knight_ant6,itm_shield_knight_ant7,itm_shield_knight_ant8,itm_shield_knight_ant9,
    itm_knight_mercenary3,itm_knight_mercenary4,itm_monk_boots,itm_helm_mercenary1,itm_helm_mercenary2],
   def_attrib|level(21),wp_melee(120) | wp_crossbow (120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_older_2],       

 ["seljuk_militia","Seljuk Militia","Seljuk Militia",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_muslim_pike1,itm_crescent_sar2,itm_crescent_sar3,itm_muslim_pike,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10],
   def_attrib|level(9),wp(75),knows_common,khergit_face_younger_1, khergit_face_middle_2],
 ["seljuk_footman","Seljuk Footman","Seljuk Footmen",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_muslim_pike1,itm_crescent_sar,itm_crescent_sar1,itm_muslim_pike,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_boots_light_sar1,itm_boots_light_sar2],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],
 ["seljuk_infantry","Seljuk Infantry","Seljuk Infantry",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_fighting_axe,itm_falchion_sar,itm_muslim_pike1,itm_muslim_pike,itm_pike_banner_sar2,itm_pike_banner_sar3,itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,
    itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_armor_sel1,itm_armor_sel2,itm_armor_sel3,itm_armor_sel4,itm_armor_sel5,itm_armor_sel6],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
 ["seljuk_guard","Seljuk Guard","Seljuk Guards",tf_moro|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_armor_sel1,itm_armor_sel2,itm_armor_sel3,itm_armor_sel4,itm_armor_sel5,itm_armor_sel6,itm_helmet_sel1,itm_helmet_sel2,itm_helmet_sel3,itm_helmet_sel4,itm_helmet_sel5,itm_helmet_sel6,itm_boots_cav_sel1,itm_boots_cav_sel2,itm_boots_cav_sel3,itm_sword_arabian_small,itm_muslim_pike1,itm_pike_banner_sar,itm_pike_banner_sar1,itm_muslim_pike,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_old_2],
 ["seljuk_archer","Seljuk Archer","Seljuk Archers",tf_moro|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_fighting_axe,itm_falchion_sar,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5],
   def_attrib|level(18),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_power_draw_4|knows_ironflesh_1|knows_power_throw_3,khergit_face_young_1, khergit_face_middle_2],
 ["seljuk_veteran_archer","Seljuk Horse Archer","Seljuk Horse Archers",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_scimitar,itm_scimitar1,itm_armor_sel1,itm_armor_sel2,itm_armor_sel3,itm_armor_sel4,itm_armor_sel5,itm_armor_sel6,itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_sel1,itm_helmet_sel2,itm_helmet_sel3,itm_helmet_sel4,itm_helmet_sel5,itm_helmet_sel6,
    itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_sar6,itm_shield_sar7,itm_shield_sar8,itm_shield_sar9,itm_shield_sar10],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (120) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_5|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
 ["seljuk_horseman","Horseman","Horsemen",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_lance_sar,itm_lance_banner_sar6,itm_lance_banner_sar2,itm_lance_banner_sar4,itm_lance_banner_sar3,itm_lance_sar1,itm_lance_sar2,itm_scimitar,itm_scimitar1,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,
    itm_armor_sel1,itm_armor_sel2,itm_armor_sel3,itm_armor_sel4,itm_armor_sel5,itm_armor_sel6,itm_boots_cav_sel1,itm_boots_cav_sel2,itm_boots_cav_sel3, itm_helmet_sel1,itm_helmet_sel2,itm_helmet_sel3,itm_helmet_sel4,itm_helmet_sel5,itm_helmet_sel6],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,khergit_face_young_1, khergit_face_old_2],
 ["seljuk_mamluk","Ghulam","Ghulams",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_lance_sar,itm_lance_banner_sar5,itm_lance_banner_sar,itm_lance_banner_sar4,itm_lance_banner_sar1,itm_lance_sar1,itm_lance_sar2,itm_scimitar2,itm_scimitar3,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_arabian_cav1,itm_arabian_cav2,itm_arabian_cav3,itm_arabian_cav4,itm_arabian_cav5,itm_arabian_cav6,itm_arabian_cav7,
    itm_mamluk_sel1,itm_mamluk_sel2,itm_mamluk_sel3,itm_mamluk_ayy1,itm_mamluk_ayy2,itm_mamluk_ayy3,itm_boots_cav_sel1,itm_boots_cav_sel2,itm_boots_cav_sel3,itm_helm_sel1,itm_helm_sel2,itm_helm_sel3,itm_gauntlets_sar1],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_5|knows_ironflesh_5|knows_power_strike_5,khergit_face_middle_1, khergit_face_older_2],

   ["khergit_messenger","Seljuk Messenger","Seljuk Messengers",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_3,
   [itm_sword_arabian_small,itm_armor_sel1,itm_boots_cav_sel1,itm_turk1,itm_helmet_sel6],
   def_attrib|level(21),wp_melee(100)| wp_archery (100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,khergit_face_young_1, khergit_face_old_2],
  ["khergit_deserter","Seljuk Deserter","Seljuk Deserters",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["khergit_prison_guard","Castle Guard","Castle Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_scimitar2,itm_scimitar3,itm_mamluk_sel2,itm_mamluk_sel3,itm_boots_cav_sel1,itm_helm_sel1,itm_helm_sel3,itm_shield_ayyinf1],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],
  ["khergit_castle_guard","Castle Guard","Castle Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_scimitar2,itm_scimitar3,itm_mamluk_sel2,itm_mamluk_sel3,itm_boots_cav_sel1,itm_helm_sel1,itm_helm_sel3,itm_shield_ayyinf1],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],

  ["khergit_guanren", "Tarsus Mounted Guard", "Tarsus Mounted Guards",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_lance_sar,itm_heavy_lance,itm_heavy_lance,itm_lance_sar1,itm_lance_sar2,itm_scimitar2,itm_scimitar3,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_horse_sel_lord,
    itm_mamluk_sel3,itm_boots_cav_sel1,itm_boots_cav_sel2,itm_boots_cav_sel3,itm_helm_sel3],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,khergit_face_middle_1, khergit_face_older_2],
  ["khergit_keshik", "Tarsus Palace Guard", "Tarsus Palace Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_3,
   [itm_muslim_pike1,itm_pike,itm_pike,itm_muslim_pike,itm_scimitar2,itm_scimitar3,itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,
    itm_mamluk_sel3,itm_boots_cav_sel1,itm_boots_cav_sel2,itm_boots_cav_sel3,itm_helm_sel3],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],

  ["templar_militia","Templar Armed Pilgrim","Templar Armed Pilgrims",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_pike,itm_cross_tem,itm_cross_tem1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_tem,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(9),wp(75),knows_common,swadian_face_younger_1, swadian_face_middle_2],
  ["templar_footman","Templar Footman","Templar Footmen",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_pike,itm_cross_tem,itm_cross_tem1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_tem,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["templar_infantry","Templar Infantry","Templar Infantry",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_tem,itm_pike_banner_tem1,itm_ashwood_pike,itm_shield_veteran_tem1,itm_shield_veteran_tem2,itm_shield_veteran_tem3,itm_shield_veteran_tem4,
    itm_infantry_tem1,itm_infantry_tem2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["templar_sergeant","Templar Sergeant","Templar Sergeants",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_sword_medieval_b_small,itm_axe_cru4,itm_sword_medieval_b_small1,itm_pike,itm_pike_banner_tem,itm_pike_banner_tem1,itm_ashwood_pike,itm_shield_veteran_tem5,itm_shield_veteran_tem6,itm_shield_veteran_tem7,itm_shield_veteran_tem8,
    itm_sergeant_temp1,itm_sergeant_temp2,itm_mail_boots2,itm_leather_gloves,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["templar_crossbowman","Templar Crossbowman","Templar Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_4,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_tem1,itm_shield_archer_tem2,itm_shield_archer_tem3,itm_shield_archer_tem4,
    itm_archer_tem1,itm_archer_tem2,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common|knows_ironflesh_1,swadian_face_young_1, swadian_face_middle_2],
  ["templar_veteran_crossbowman","Templar Veteran Crossbowman","Templar Veteran Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_4,
   [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_tem1,itm_shield_archer_tem2,itm_shield_archer_tem3,itm_shield_archer_tem4,
    itm_archer_tem1,itm_archer_tem2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_ironflesh_1|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
   ["templar_squire","Confrere Knight","Confrere Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_4,
   [itm_heavy_lance,itm_lance_banner_tem7,itm_lance_banner_tem6,itm_lance_banner_tem4,itm_lance_banner_tem5,itm_heavy_lance,itm_sword_medieval_tem,itm_sword_medieval_a1,itm_shield_knight_temconf1,itm_shield_knight_temconf2,itm_shield_knight_temconf3,itm_shield_knight_temconf4,itm_shield_knight_temconf5,itm_shield_knight_temconf6,itm_horse_tem_conf1,itm_horse_tem_conf2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_tem_conf1,itm_knight_tem_conf1,itm_knight_tem_conf3,itm_knight_tem_conf4,itm_knight_tem_conf5,itm_knight_tem_conf6,itm_knight_tem_conf7,itm_knight_tem_conf8,itm_knight_tem_conf9,itm_knight_tem_conf10,itm_mail_boots1,itm_mail_mittens1,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm_ord,itm_helm_red,itm_helm_red1,itm_helm_ord_red],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_young_1, swadian_face_old_2],
  ["templar_knight","Knight Templar","Knights Templar",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_4,
   [itm_heavy_lance,itm_lance_banner_tem3,itm_lance_banner_tem,itm_lance_banner_tem1,itm_lance_banner_tem2,itm_heavy_lance,itm_sword_medieval_tem,itm_sword_medieval_a1,itm_shield_knight_tem1,itm_shield_knight_tem2,itm_shield_knight_tem3,itm_shield_knight_tem4,itm_shield_knight_tem5,itm_shield_knight_tem6,itm_shield_knight_tem7,itm_horse_tem1,itm_horse_tem2,itm_horse_tem3,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_tem1,itm_knight_tem2,itm_knight_tem3,itm_knight_tem4,itm_knight_tem5,itm_knight_tem6,itm_knight_tem7,itm_knight_tem8,itm_mail_boots1,itm_mail_mittens1,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_tem,itm_helm_tem1,itm_helm_red],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_7|knows_ironflesh_7|knows_power_strike_7,swadian_face_middle_1, swadian_face_older_2],

   ["nord_messenger","Templar Messenger","Templar Messengers",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_sword_medieval_tem,itm_sergeant_temp1,itm_mail_boots1,itm_hunter1,itm_helmet1],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,swadian_face_young_1, swadian_face_old_2],
  ["nord_deserter","Templar Deserter","Templar Deserters",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_shield_veteran_tem1,itm_shield_veteran_tem2,itm_shield_veteran_tem3,itm_shield_veteran_tem4,itm_novici_tem,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_2|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["nord_prison_guard","Monk","Monks", tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_4,
   [itm_sword_medieval_tem,itm_sergeant_temp3,itm_sergeant_temp4,itm_mail_boots2,itm_coif_black],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["nord_castle_guard","Monk","Monks", tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_4,
   [itm_sword_medieval_tem,itm_sergeant_temp3,itm_sergeant_temp4,itm_mail_boots2,itm_coif_black],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],

  ["nord_einherjar", "Acre Mounted Monk", "Acre Mounted Monks",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_heavy_lance,itm_heavy_lance,itm_heavy_lance,itm_sword_medieval_tem,itm_sword_medieval_a1,itm_shield_knight_temconf1,itm_shield_knight_temconf2,itm_shield_knight_temconf3,itm_shield_knight_temconf4,itm_shield_knight_temconf5,itm_shield_knight_temconf6,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_monk_temp1,itm_monk_temp2,itm_monk_boots,itm_coif_monk],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_middle_1, swadian_face_old_2], 
  ["nord_valkyrie", "Acre Warrior Monk", "Acre Warrior Monks",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,
   [itm_pike,itm_pike,itm_pike,itm_ashwood_pike,itm_sword_medieval_tem,itm_sword_medieval_a1,itm_shield_knight_temconf1,itm_shield_knight_temconf2,itm_shield_knight_temconf3,itm_shield_knight_temconf4,itm_shield_knight_temconf5,itm_shield_knight_temconf6,
    itm_monk_temp1,itm_monk_temp2,itm_monk_boots,itm_coif_monk],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],             

  ["hospitaller_militia","Hospitaller Armed Pilgrim","Hospitaller Armed Pilgrims",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_pike,itm_cross_hos,itm_cross_hos1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_hos,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(9),wp(75),knows_common,swadian_face_younger_1, swadian_face_middle_2],
  ["hospitaller_footman","Hospitaller Footman","Hospitaller Footmen",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_pike,itm_cross_hos,itm_cross_hos1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_hos,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["hospitaller_infantry","Hospitaller Infantry","Hospitaller Infantry",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_hos,itm_pike_banner_hos1,itm_ashwood_pike,itm_shield_veteran_hos1,itm_shield_veteran_hos2,itm_shield_veteran_hos3,itm_shield_veteran_hos4,
    itm_infantry_hos1,itm_infantry_hos2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["hospitaller_sergeant","Hospitaller Sergeant","Hospitaller Sergeants",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_sword_medieval_b_small,itm_axe_cru4,itm_sword_medieval_b_small1,itm_pike,itm_pike_banner_hos,itm_pike_banner_hos1,itm_ashwood_pike,itm_shield_veteran_hos5,itm_shield_veteran_hos6,itm_shield_veteran_hos7,itm_shield_veteran_hos8,
    itm_sergeant_hos1,itm_sergeant_hos2,itm_mail_boots2,itm_leather_gloves,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["hospitaller_crossbowman","Hospitaller Crossbowman","Hospitaller Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_5,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_hos1,itm_shield_archer_hos2,itm_shield_archer_hos3,itm_shield_archer_hos4,
    itm_archer_hos1,itm_archer_hos2,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common|knows_ironflesh_1,swadian_face_young_1, swadian_face_middle_2],
  ["hospitaller_veteran_crossbowman","Hospitaller Veteran Crossbowman","Hospitaller Veteran Crossbowmen",tf_cristiano|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_kingdom_5,
   [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_hos1,itm_shield_archer_hos2,itm_shield_archer_hos3,itm_shield_archer_hos4,
    itm_archer_hos1,itm_archer_hos2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_ironflesh_1|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
   ["hospitaller_squire","Confrere Knight","Confrere Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_5,
   [itm_heavy_lance,itm_lance_banner_hos3,itm_lance_banner_hos4,itm_lance_banner_hos3,itm_lance_banner_hos5,itm_heavy_lance,itm_sword_medieval_hos,itm_sword_medieval_a2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf3,itm_shield_knight_hosconf4,itm_horse_hos_conf1,itm_horse_hos_conf2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_hos_conf1,itm_knight_hos_conf2,itm_knight_hos_conf3,itm_knight_hos_conf4,itm_knight_hos_conf5,itm_knight_hos_conf6,itm_mail_boots1,itm_mail_mittens1,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm_ord,itm_helm_black,itm_helm_black1,itm_helm_ord_black],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_young_1, swadian_face_old_2],
  ["hospitaller_knight","Knight Hospitaller","Knights Hospitaller",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_5,
   [itm_heavy_lance,itm_lance_banner_hos,itm_lance_banner_hos1,itm_lance_banner_hos,itm_lance_banner_hos2,itm_heavy_lance,itm_sword_medieval_hos,itm_sword_medieval_a2,itm_shield_knight_hos1,itm_shield_knight_hos2,itm_shield_knight_hos3,itm_shield_knight_hos4,itm_horse_hos1,itm_horse_hos2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_knight_hos1,itm_knight_hos2,itm_knight_hos3,itm_knight_hos4,itm_knight_hos5,itm_knight_hos6,itm_knight_hos7,itm_knight_hos8,itm_mail_boots1,itm_mail_mittens1,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_red,itm_helm_hos,itm_helm_hos1],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_7|knows_ironflesh_7|knows_power_strike_7,swadian_face_middle_1, swadian_face_older_2],

   ["rhodok_messenger","Hospitaller Messenger","Hospitaller Messengers",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_sword_medieval_hos,itm_sergeant_hos1,itm_mail_boots1,itm_hunter1,itm_helmet1],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,swadian_face_middle_1, swadian_face_older_2],
  ["rhodok_deserter","Hospitaller Deserter","Hospitaller Deserters",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_shield_veteran_hos2,itm_shield_veteran_hos3,itm_shield_veteran_hos4,itm_novici_hos,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_2|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_middle_1, swadian_face_older_2],
  ["rhodok_prison_guard","Monk","Monks", tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_5,
   [itm_sword_medieval_hos,itm_sergeant_hos3,itm_sergeant_hos4,itm_mail_boots2,itm_coif_black],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_older_2],
  ["rhodok_castle_guard","Monk","Monks", tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_5,
   [itm_sword_medieval_hos,itm_sergeant_hos3,itm_sergeant_hos4,itm_mail_boots2,itm_coif_black],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_older_2],
#peasant - retainer - footman - man-at-arms -  knight

  ["rhodok_arbalest", "Archas Mounted Monk", "Archas Mounted Monks",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_heavy_lance,itm_heavy_lance,itm_heavy_lance,itm_sword_medieval_hos,itm_sword_medieval_a2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf3,itm_shield_knight_hosconf4,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
    itm_monk_hos1,itm_monk_hos2,itm_monk_boots,itm_coif_monk],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_middle_1, swadian_face_old_2], 
  ["rhodok_spear_knight", "Archas Warrior Monk", "Archas Warrior Monks",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,
   [itm_pike,itm_pike,itm_pike,itm_ashwood_pike,itm_sword_medieval_hos,itm_sword_medieval_a2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf1,itm_shield_knight_hosconf2,itm_shield_knight_hosconf3,itm_shield_knight_hosconf4,
    itm_monk_hos1,itm_monk_hos2,itm_monk_boots,itm_coif_monk],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2], 

 ["ayyubid_militia","Ayyubid Militia","Ayyubid Militia",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_muslim_pike1,itm_crescent_sar2,itm_crescent_sar3,itm_muslim_pike,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10],
   def_attrib|level(9),wp(75),knows_common,khergit_face_younger_1, khergit_face_middle_2],
 ["ayyubid_footman","Ayyubid Footman","Ayyubid Footmen",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_muslim_pike1,itm_crescent_sar,itm_crescent_sar1,itm_muslim_pike,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_light_sar1,itm_boots_light_sar2],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],
 ["ayyubid_infantry","Ayyubid Infantry","Ayyubid Infantry",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_fighting_axe,itm_falchion_sar,itm_muslim_pike1,itm_pike_banner_sar2,itm_pike_banner_sar3,itm_muslim_pike,itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,
    itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8],
   def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
 ["ayyubid_guard","Ayyubid Guard","Ayyubid Guards",tf_moro|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_sword_arabian_small,itm_muslim_pike1,itm_pike_banner_sar,itm_pike_banner_sar1,itm_muslim_pike,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_old_2],
 ["ayyubid_archer","Ayyubid Archer","Ayyubid Archers",tf_moro|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_fighting_axe,itm_falchion_sar,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5],
   def_attrib|level(18),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_power_draw_4|knows_ironflesh_1|knows_power_throw_3,khergit_face_young_1, khergit_face_middle_2],
 ["ayyubid_veteran_archer","Ayyubid Horse Archer","Ayyubid Horse Archers",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_scimitar,itm_scimitar1,itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_boots_average_sar1,itm_boots_average_sar2,itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6,
    itm_arabian1,itm_arabian2,itm_arabian3,itm_arabian4,itm_shield_sar6,itm_shield_sar7,itm_shield_sar8,itm_shield_sar9,itm_shield_sar10],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (120) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_5|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
 ["ayyubid_horseman","Horseman","Horsemen",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_lance_sar,itm_lance_banner_sar6,itm_lance_banner_sar2,itm_lance_banner_sar4,itm_lance_banner_sar3,itm_lance_sar1,itm_lance_sar2,itm_scimitar,itm_scimitar1,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_arabian1,itm_arabian2,itm_arabian3,itm_arabian4,
    itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_boots_cav_ayy1,itm_boots_cav_ayy2, itm_helmet_ayy1,itm_helmet_ayy2,itm_helmet_ayy3,itm_helmet_ayy4,itm_helmet_ayy5,itm_helmet_ayy6],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,khergit_face_young_1, khergit_face_old_2],
 ["ayyubid_mamluk","Mamluk","Mamluks",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_lance_sar,itm_lance_banner_sar5,itm_lance_banner_sar,itm_lance_banner_sar4,itm_lance_banner_sar1,itm_lance_sar1,itm_lance_sar2,itm_scimitar2,itm_scimitar3,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_arabian_cav1,itm_arabian_cav2,itm_arabian_cav3,itm_arabian_cav4,itm_arabian_cav5,itm_arabian_cav6,itm_arabian_cav7,
    itm_mamluk_ayy1,itm_mamluk_ayy2,itm_mamluk_ayy3,itm_mamluk_sel1,itm_mamluk_sel2,itm_mamluk_sel3,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_helm_ayy1,itm_helm_ayy2,itm_helm_ayy3,itm_helm_ayy4,itm_helm_ayy5,itm_gauntlets_sar2],
   def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_5|knows_ironflesh_5|knows_power_strike_5,khergit_face_middle_1, khergit_face_older_2],

   ["sarranid_messenger","Ayyubid Messenger","Ayyubid Messengers",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_sword_arabian_small,itm_armor_ayy8,itm_boots_cav_ayy2,itm_arabian1,itm_helmet_ayy3],
   def_attrib|level(21),wp_melee(100)| wp_archery (100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,khergit_face_young_1, khergit_face_old_2],
  ["sarranid_deserter","Ayyubid Deserter","Ayyubid Deserters",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_helmet_lig_sar1,itm_helmet_lig_sar2,itm_helmet_lig_sar3,itm_helmet_lig_sar4,itm_helmet_lig_sar5,itm_helmet_lig_sar6,itm_helmet_lig_sar7,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_arabian1,itm_arabian2,itm_arabian3,itm_arabian4,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["sarranid_prison_guard","Castle Guard","Castle Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_scimitar2,itm_scimitar3,itm_mamluk_ayy2,itm_mamluk_ayy3,itm_boots_cav_ayy2,itm_helm_ayy1,itm_helm_ayy5,itm_shield_ayyinf1],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],
  ["sarranid_castle_guard","Castle Guard","Castle Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_scimitar2,itm_scimitar3,itm_mamluk_ayy2,itm_mamluk_ayy3,itm_boots_cav_ayy2,itm_helm_ayy1,itm_helm_ayy5,itm_shield_ayyinf1],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],

  ["sarranid_zhayedan", "Cairo Mounted Guard", "Cairo Mounted Guards",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_lance_sar,itm_heavy_lance,itm_heavy_lance,itm_lance_sar1,itm_lance_sar2,itm_scimitar2,itm_scimitar3,itm_shield_ayycav1,itm_shield_ayycav2,itm_shield_ayycav3,itm_shield_ayycav4,itm_shield_ayycav5,itm_horse_ayy_lord,
    itm_palace_sar,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_helmet_lord_sar],
   def_attrib|level(23),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,khergit_face_middle_1, khergit_face_older_2],
  ["sarranid_spahbod_serden", "Cairo Palace Guard", "Cairo Palace Guards",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_muslim_pike1,itm_pike,itm_pike,itm_muslim_pike,itm_scimitar2,itm_scimitar3,itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,
    itm_palace_sar,itm_boots_cav_ayy1,itm_boots_cav_ayy2,itm_helmet_lord_sar],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_middle_1, khergit_face_older_2],

#######################
# Custom Troops begin
# FORMAT:
# 1. Regular troop: this is the actual troop entry used for the troop. Ignore the equipment list, you can leave it blank.
# 2. Equip troop: shows what the troop will be carrying when the game first starts. This is later used for saving the troop's custom selection
# 3. Troop equipment selection: List of what is available to select during the customization phase. Can have up to around 80 items max, but recommended is maybe 50 max (to leave room so you can remove items from the current selection).

#Basic unit. Peasant/Civilian/Citizen type. Equipment consists of tools and all stuff civilians can lay their hands on.
  ["custom_peasant","Teutonic Armed Pilgrim","Teutonic Armed Pilgrims",tf_cristiano|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_player_supporters_faction,[],def_attrib|level(9),wp(75),knows_common,swadian_face_younger_1, swadian_face_middle_2],
  ["custom_peasant_equip","Teutonic Armed Pilgrim","Teutonic Armed Pilgrims",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_pike,itm_cross_teu,itm_cross_teu1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
    itm_novici_teu,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
  def_attrib|level(9),wp(75),knows_common,0],
  ["custom_peasant_selection","Teutonic Armed Pilgrim","Teutonic Armed Pilgrims",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_pike,itm_cross_teu,itm_cross_teu1,itm_ashwood_pike,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,
   itm_novici_teu
   ],
   def_attrib|level(9),wp(75),knows_common|knows_inventory_management_10,0],

#Second basic unit. Army recruits are equipped with basic gear and, unless peasants, receive good training and drill to perform better in combat.
  ["custom_army_recruit","Teutonic Footman","Teutonic Footmen",tf_cristiano|tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_player_supporters_faction,[],def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["custom_army_recruit_equip","Teutonic Footman","Teutonic Footman",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_pike,itm_cross_teu,itm_cross_teu1,itm_ashwood_pike,
   itm_novici_teu,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
  def_attrib|level(14),wp_melee(85),knows_common,0],
  ["custom_army_recruit_selection","Teutonic Footman","Teutonic Footmen",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_pike,itm_cross_teu,itm_cross_teu1,itm_ashwood_pike,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,
   itm_novici_teu
   ],
   def_attrib|level(14),wp_melee(85),knows_common|knows_inventory_management_10,0],

#First unit of the ranged weapons branch. As they're specializing in ranged combat and mobility, they get worse armour than melee troops.
  ["custom_crossbow_militia","Teutonic Crossbowman","Teutonic Crossbowmen",tf_cristiano|tf_guarantee_helmet|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_player_supporters_faction,[],def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common|knows_ironflesh_1,swadian_face_young_1, swadian_face_middle_2],
  ["custom_crossbow_militia_equip","Teutonic Crossbowman","Teutonic Crossbowmen",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_teu1,itm_shield_archer_teu2,itm_shield_archer_teu3,itm_shield_archer_teu4,
    itm_archer_teu1,itm_archer_teu2,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
  def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common,0],
  ["custom_crossbow_militia_selection","Teutonic Crossbowman","Teutonic Crossbowmen",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,
   itm_archer_teu1,itm_archer_teu2,itm_shield_archer_teu1,itm_shield_archer_teu2,itm_shield_archer_teu3,itm_shield_archer_teu4,
   ],
   def_attrib|level(18),wp(80)| wp_crossbow (100),knows_common|knows_inventory_management_10,0],

#Second ranged unit. A little bit better than the former one.
  ["custom_crossbowman","Teutonic Veteran Crossbowman","Teutonic Veteran Crossbowmen",tf_cristiano|tf_guarantee_helmet|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_player_supporters_faction,[],def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_ironflesh_1|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
  ["custom_crossbowman_equip","Teutonic Veteran Crossbowman","Teutonic Veteran Crossbowmen",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_teu1,itm_shield_archer_teu2,itm_shield_archer_teu3,itm_shield_archer_teu4,
    itm_archer_teu1,itm_archer_teu2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
  def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common,0],
  ["custom_crossbowman_selection","Teutonic Veteran Crossbowman","Teutonic Veteran Crossbowmen",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_axe_cru3,itm_axe_cru4,itm_falchion,itm_bolts,itm_bolts1,itm_bolts2,itm_crossbow,itm_crossbow1,itm_shield_archer_teu1,itm_shield_archer_teu2,itm_shield_archer_teu3,itm_shield_archer_teu4,
    itm_archer_teu1,itm_archer_teu2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (100) | wp_crossbow (120) | wp_throwing (90),knows_common|knows_inventory_management_10,0],

#Elite of the ranged weapons branch
#  ["custom_pavise_crossbowman","Imperial Sharpshooter","Imperial Sharpshooters",tf_guarantee_gloves|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_shield,0,0,fac_player_supporters_faction,[],str_14 | agi_10 | int_4 | cha_4|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(150),knows_common|knows_ironflesh_4|knows_power_strike_3|knows_power_draw_5|knows_power_throw_5|knows_shield_4|knows_athletics_5,swadian_face_middle_1, swadian_face_older_2],
#  ["custom_pavise_crossbowman_equip","Imperial Sharpshooter","Imperial Sharpshooters",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#   [itm_steel_bolts,itm_bodkin_arrows,itm_bodkin_arrows,itm_war_bow,itm_bb_templar_sword_a,itm_voulge,itm_shield_st_kite,
#    itm_lazarus_serjeant_tunic,itm_bav_tunic,itm_bav_hauqil,itm_bav_quil,itm_ven_hau,itm_ven_hau2,itm_leather_boots,itm_kettlehat1,itm_leather_gloves],
#  def_attrib|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(150),knows_common,0],
#  ["custom_pavise_crossbowman_selection","Imperial Sharpshooter","Imperial Sharpshooters",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#  [itm_heraldic_crusader_armor,itm_tab_shield_kite_b,itm_lazarus_serjeant_tunic,itm_shield_st_kite,itm_war_bow,itm_long_bow,itm_heavy_crossbow,itm_bb_templar_sword_a,itm_voulge,itm_leather_boots,itm_kettlehat1,itm_leather_gloves,itm_steel_bolts,itm_bodkin_arrows,
#   itm_normanhelmcoif,itm_bav_tunic,itm_bav_hauqil,itm_bav_quil,itm_ven_hau,itm_ven_hau2,
#   itm_sword_khergit_2,itm_nomad_bow,itm_khergit_arrows,itm_javelin,itm_cuman_shield_c,itm_steppe_cap,itm_nomad_cap,itm_leather_steppe_cap_a,itm_mongol_leather_armour,itm_rus_lamellar_a,itm_rus_lamellar_b,
#   itm_club_with_spike_head,itm_byz_shield_4,itm_kettle_byzantionb2,itm_rus_scale_b,itm_anatolian_horseman_lamellar,itm_anatolian_horseman_lamellar,itm_nomad_boots,itm_almohad_mail,itm_almohad_mail2,itm_almohad_mail3,itm_arab_armor2,itm_arab_armor3,itm_arab_padded4,itm_arab_padded2,
#   itm_nomad_bow,itm_arabian_sword_a,itm_seljuk_tunic_c,itm_sarranid_boots_b,itm_turban_mail_d,itm_turban_mail_c,itm_turban_mail_b,itm_turban_mail_a,itm_arab_shield_b],
#   def_attrib|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(150),knows_common|knows_inventory_management_10,0],

#Same as above, but mounted
#  ["custom_mounted_crossbowman","Imperial Horse Archer","Imperial Horse Archers",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_shield|tf_guarantee_gloves,0,0,fac_player_supporters_faction,[],str_14 | agi_10 | int_4 | cha_4|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(150),knows_common|knows_ironflesh_4|knows_power_strike_3|knows_power_draw_5|knows_power_throw_5|knows_shield_4|knows_athletics_4|knows_riding_4|knows_horse_archery_5,swadian_face_young_1, swadian_face_old_2],
#  ["custom_mounted_crossbowman_equip","Imperial Horse Archer","Imperial Horse Archers",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#   [itm_war_bow, itm_khergit_bow, itm_bb_templar_sword_b, itm_khergit_arrows, itm_bodkin_arrows, itm_saint_thomas_knight,itm_bav_hau,itm_swa_hau,itm_sax_hau,itm_ven_tunic,itm_ven_tunic2, itm_leather_boots, itm_kettlehat1, itm_leather_gloves, itm_shield_st_heatercav, itm_destrier_black,itm_destrier_dapple,itm_destrier_chestnut2,itm_destrier_chestnut4,itm_destrier_bay1],
#  def_attrib|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(140),knows_common,0],
#  ["custom_mounted_crossbowman_selection","Imperial Horse Archer","Imperial Horse Archers",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#  [itm_heraldic_crusader_tunic,itm_tab_shield_heater_cav_a,itm_saint_thomas_knight,itm_shield_st_heatercav,itm_war_bow, itm_bb_templar_sword_b, itm_bodkin_arrows, itm_leather_boots, itm_kettlehat1, itm_leather_gloves, itm_destrier_black,itm_destrier_dapple,itm_destrier_chestnut2,itm_destrier_chestnut4,itm_destrier_bay1,
#   itm_normanhelmcoif,itm_bav_hau,itm_swa_hau,itm_sax_hau,itm_ven_tunic,itm_ven_tunic2,itm_pap_mail,itm_kuyak_b,
#   itm_sword_khergit_2,itm_khergit_bow,itm_khergit_arrows,itm_javelin,itm_cuman_shield_c,itm_steppe_cap,itm_nomad_cap,itm_leather_steppe_cap_a,itm_mongol_leather_armour,itm_rus_lamellar_a,itm_rus_lamellar_b,
#   itm_club_with_spike_head,itm_byz_shield_4,itm_kettle_byzantionb2,itm_rus_scale_b,itm_anatolian_horseman_lamellar,itm_nomad_boots,itm_almohad_rob3,itm_almohad_rob4,itm_almohad,itm_almohad2,itm_almohad_padded2,itm_almohad_padded3,
#   itm_nomad_bow,itm_arabian_sword_a,itm_seljuk_tunic_c,itm_sarranid_boots_b,itm_turban_mail_d,itm_turban_mail_c,itm_turban_mail_b,itm_turban_mail_a,itm_arab_shield_b],
#   def_attrib|level(22),wp(100)|wp_crossbow(150)|wp_archery(150)|wp_throwing(150)|wp_firearm(140),knows_common|knows_inventory_management_10,0],

#Start of the melee branch. They lack ranged weapons, but get better armour and weapons.
  ["custom_infantry","Teutonic Infantry","Teutonic Infantry",tf_cristiano|tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_player_supporters_faction,[],def_attrib|level(18),wp_melee(105),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_shield_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
  ["custom_infantry_equip","Teutonic Infantry","Teutonic Infantry",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_teu,itm_pike_banner_teu1,itm_ashwood_pike,itm_shield_veteran_teu1,itm_shield_veteran_teu2,itm_shield_veteran_teu3,itm_shield_veteran_teu4,
    itm_infantry_teu1,itm_infantry_teu2,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8],
  def_attrib|level(18),wp_melee(105),knows_common,0],
  ["custom_infantry_selection","Teutonic Infantry","Teutonic Infantry",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_axe_cru3,itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_pike,itm_pike_banner_teu,itm_pike_banner_teu1,itm_ashwood_pike,itm_boots_average_cru1,itm_boots_average_cru2,itm_boots_average_cru3,itm_boots_average_cru4,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,
   itm_infantry_teu1,itm_infantry_teu2,itm_shield_veteran_teu1,itm_shield_veteran_teu2,itm_shield_veteran_teu3,itm_shield_veteran_teu4
   ],
   def_attrib|level(18),wp_melee(105),knows_common|knows_inventory_management_10,0],

#First mounted unit. Light cavalry relying on speed.
  ["custom_squire","Confrere Knight","Confrere Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_player_supporters_faction,[],def_attrib|level(21),wp_melee(135),knows_common|knows_riding_5|knows_ironflesh_6|knows_shield_6|knows_power_strike_6,swadian_face_middle_1, swadian_face_older_2],
  ["custom_squire_equip","Confrere Knight","Confrere Knights",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_heavy_lance,itm_lance_banner_teu4,itm_lance_banner_teu1,itm_lance_banner_teu5,itm_lance_banner_teu2,itm_heavy_lance,itm_sword_medieval_a,itm_sword_medieval_teu,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm_ord,itm_helm_ord_white,
    itm_shield_knight_teuconf1,itm_shield_knight_teuconf2,itm_shield_knight_teuconf3,itm_shield_knight_teuconf4,itm_shield_knight_teuconf5,itm_shield_knight_teuconf6,itm_knight_teu_conf1,itm_knight_teu_conf2,itm_knight_teu_conf3,itm_mail_boots1,itm_mail_mittens1,itm_horse_teu_conf1,itm_horse_teu_conf2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4],
  def_attrib|level(21),wp_melee(135),knows_common,0],
  ["custom_squire_selection","Confrere Knight","Confrere Knights",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_heavy_lance,itm_lance_banner_teu5,itm_lance_banner_teu4,itm_lance_banner_teu1,itm_lance_banner_teu2,itm_sword_medieval_a,itm_sword_medieval_teu,itm_helmet_knight1,itm_helmet_knight2,itm_helmet_knight3,itm_helmet_knight4,itm_helmet_knight5,itm_helmet_knight6,itm_helmet_knight7,itm_helm_ord,itm_helm_ord_white,
    itm_shield_knight_teuconf1,itm_shield_knight_teuconf2,itm_shield_knight_teuconf3,itm_shield_knight_teuconf4,itm_shield_knight_teuconf5,itm_shield_knight_teuconf6,itm_knight_teu_conf1,itm_knight_teu_conf2,itm_knight_teu_conf3,itm_mail_boots1,itm_mail_mittens1,itm_horse_teu_conf1,itm_horse_teu_conf2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4
   ],
   def_attrib|level(21),wp_melee(135),knows_common|knows_inventory_management_10,0],

#Elite mounted troops. They prefer swords, lances and heavy armours and horses.
  ["custom_knight","Teutonic Knight","Teutonic Knights",tf_cristiano|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_player_supporters_faction,[],def_attrib|level(23),wp_melee(150),knows_common|knows_riding_5|knows_shield_7|knows_ironflesh_7|knows_power_strike_7,swadian_face_middle_1, swadian_face_older_2],
  ["custom_knight_equip","Teutonic Knight","Teutonic Knights",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_heavy_lance,itm_lance_banner_teu,itm_lance_banner_teu1,itm_lance_banner_teu3,itm_lance_banner_teu2,itm_heavy_lance,itm_sword_medieval_a,itm_sword_medieval_teu,itm_shield_knight_teu1,itm_shield_knight_teu2,itm_shield_knight_teu3,itm_shield_knight_teu4,itm_shield_knight_teu5,itm_shield_knight_teu6,itm_shield_knight_teu7,
    itm_knight_teu1,itm_knight_teu2,itm_knight_teu3,itm_knight_teu4,itm_knight_teu5,itm_knight_teu6,itm_knight_teu7,itm_knight_teu8,itm_knight_teu9,itm_knight_teu10,itm_horse_teu1,itm_horse_teu2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,itm_mail_boots1,itm_mail_mittens1,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_teu,itm_helm_teu1,itm_helm_black,itm_helm_black1],
  def_attrib|level(23),wp_melee(150),knows_common,0],
  ["custom_knight_selection","Teutonic Knight","Teutonic Knights",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_heavy_lance,itm_lance_banner_teu3,itm_lance_banner_teu,itm_lance_banner_teu1,itm_lance_banner_teu2,itm_sword_medieval_a,itm_sword_medieval_teu,itm_mail_boots1,itm_horse_teu1,itm_horse_teu2,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,itm_mail_mittens1,itm_shield_knight_teu1,itm_shield_knight_teu2,itm_shield_knight_teu3,itm_shield_knight_teu4,itm_shield_knight_teu5,itm_shield_knight_teu6,itm_shield_knight_teu7,
   itm_knight_teu1,itm_knight_teu2,itm_knight_teu3,itm_knight_teu4,itm_knight_teu5,itm_knight_teu6,itm_knight_teu7,itm_knight_teu8,itm_knight_teu9,itm_knight_teu10,itm_helm_golden1,itm_helm_golden2,itm_helm_golden3,itm_helm_teu,itm_helm_teu1,itm_helm_black,itm_helm_black1
   ],
   def_attrib|level(23),wp_melee(150),knows_common|knows_inventory_management_10,0],

#Second unit of the melee branch.
  ["custom_warrior","Teutonic Sergeant","Teutonic Sergeants",tf_cristiano|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_player_supporters_faction,[],def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["custom_warrior_equip","Teutonic Sergeant","Teutonic Sergeants",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
   [itm_sword_medieval_b_small,itm_axe_cru4,itm_sword_medieval_b_small1,itm_pike,itm_pike_banner_teu,itm_pike_banner_teu1,itm_ashwood_pike,itm_shield_veteran_teu5,itm_shield_veteran_teu6,itm_shield_veteran_teu7,itm_shield_veteran_teu8,
    itm_sergeant_teu1,itm_sergeant_teu2,itm_leather_gloves,itm_mail_boots2,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3],
  def_attrib|level(21),wp_melee(120),knows_common,0],
  ["custom_warrior_selection","Teutonic Sergeant","Teutonic Sergeants",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
  [itm_sword_medieval_b_small,itm_axe_cru4,itm_sword_medieval_b_small1,itm_pike,itm_pike_banner_teu,itm_pike_banner_teu1,itm_ashwood_pike,itm_leather_gloves,itm_mail_boots2,itm_helmet1,itm_helmet2,itm_helmet3,itm_helmet4,itm_helmet5,itm_helmet6,itm_helmet7,itm_helmet8,itm_helmet_golden1,itm_helmet_golden2,itm_helmet_golden3,
   itm_sergeant_teu1,itm_sergeant_teu2,itm_shield_veteran_teu5,itm_shield_veteran_teu6,itm_shield_veteran_teu7,itm_shield_veteran_teu8
   ],
  def_attrib|level(21),wp_melee(120),knows_common|knows_inventory_management_10,0],

#Elite melee troops specializing in one-handed weapons and shields to block arrows/bolts. To allow more freedom, they also can equip the heavy sergeant stuff.
#  ["custom_sergeant","Imperial Sergeant","Imperial Sergeants",tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet,0,0,fac_player_supporters_faction,[],def_attrib|level(26),wp(140),knows_common|knows_ironflesh_4|knows_power_strike_4|knows_shield_4|knows_athletics_4,swadian_face_middle_1, swadian_face_older_2],
#  ["custom_sergeant_equip","Imperial Sergeant","Imperial Sergeants",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#   [itm_bastard_sword_a,itm_bb_templar_sword_b,itm_morningstar,itm_shield_st_heater,itm_war_spear,
#    itm_leather_boots,itm_helmet_cross,itm_mail_coif_1200,itm_mail_coif_b_1200,itm_templar_postulant_a,itm_armor_44,itm_armor_35,itm_leather_gloves],
#  def_attrib|level(26),wp(140),knows_common,0],
#  ["custom_sergeant_selection","Imperial Sergeant","Imperial Sergeants",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#  [itm_heraldic_veteran_crusader_armor,itm_tab_shield_heater_d,itm_templar_postulant_a,itm_shield_st_heater,itm_awlpike,itm_bastard_sword_a,itm_morningstar,itm_bb_templar_sword_b,itm_leather_boots,itm_helmet_cross,itm_leather_gloves,itm_two_handed_battle_axe_2,itm_one_handed_battle_axe_b,itm_spiked_mace,itm_maul,
#   itm_normanpepperpot,itm_munitionshelm1,itm_mail_coif_1200,itm_mail_coif_b_1200,itm_war_spear,itm_armor_44,itm_armor_35,
#   itm_sword_khergit_3,itm_cuman_shield_c,itm_steppe_cap,itm_nomad_cap,itm_leather_steppe_cap_a,itm_mongol_leather_armour,itm_rus_lamellar_a,itm_rus_lamellar_b,
#   itm_club_with_spike_head,itm_byz_shield_4,itm_kettle_byzantionb2,itm_rus_scale_b,itm_nomad_boots,
#   itm_lamellar_armor,itm_moorish_helmet_c,itm_saracen_helmet_c,itm_saracen_helmet_b,itm_sarranid_boots_b,itm_sarranid_axe_a,itm_arabian_sword_b,itm_mace_3,itm_spear,itm_arab_shield_b],
#   def_attrib|level(26),wp(140),knows_common|knows_inventory_management_10,0],

#Elite melee troops specializing in two-handed weapons. Heavy armour has to substitute the shield (Ron Losey's RCM would reflect this much better). To allow more freedom, they also can equip the sergeant stuff.
#  ["custom_heavy_sergeant","Ibelin Guard","Ibelin Guards",tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_boots|tf_guarantee_gloves,0,0,fac_player_supporters_faction,[],def_attrib|level(26),wp(140),knows_common|knows_ironflesh_4|knows_power_strike_4|knows_shield_4|knows_athletics_4,swadian_face_middle_1, swadian_face_older_2],
#  ["custom_heavy_sergeant_equip","Ibelin Guard","Ibelin Guards",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#   [itm_bastard_sword_b,itm_morningstar,itm_bb_templar_sword_b,itm_war_spear,itm_shield_st_heater,
#    itm_mail_boots,itm_great_helmet_tripoli,itm_great_helmet_jerusalem,itm_great_helmet_antioch,itm_ibelin_mail,itm_teutonic_mail,itm_templar_mail_a,itm_mail_mittens],
#  def_attrib|level(26),wp(140),knows_common,0],
#  ["custom_heavy_sergeant_selection","Ibelin Guard","Ibelin Guards",tf_hero|tf_inactive,0,0,fac_player_supporters_faction,
#  [itm_heraldic_crusader_knight_mail,itm_teutonic_mail,itm_awlpike,itm_bastard_sword_b,itm_morningstar,itm_bb_templar_sword_b,itm_mail_boots,itm_great_helmet_tripoli,itm_mail_mittens,itm_great_axe,itm_one_handed_battle_axe_c,itm_warhammer,
#   itm_frenchpepperpot,itm_ibelin_mail,itm_templar_mail_a,itm_teutonic_mail,itm_great_helmet_jerusalem,itm_great_helmet_antioch,itm_war_spear,itm_shield_st_heater,itm_tab_shield_heater_d,itm_cuman_shield_c,itm_byz_shield_4,itm_arab_shield_b,
#   itm_sword_khergit_4,itm_one_handed_war_axe_b,itm_cuman_noble,itm_mongol_warrior_de,itm_splinted_leather_greaves,itm_scale_gauntlets,
#   itm_long_axe_c,itm_sword_viking_3,itm_munitionshelm2,itm_rus_scale_a,itm_mail_chausses,itm_scale_gauntlets,
#   itm_military_pick,itm_sarranid_two_handed_axe_a,itm_jarid,itm_scimitar_b,itm_war_spear,itm_mace_4,itm_sarranid_boots_d, itm_mamluke_mail,itm_sarranid_veiled_helmet,itm_mail_mittens],
#   def_attrib|level(26),wp(140),knows_common|knows_inventory_management_10,0],

  ["rangers_end","{!}na","{!}na",0,0,0,fac_neutral,[itm_velvet],def_attrib|level(1),wp(60),knows_common|knows_inventory_management_10,swadian_face_middle_1, swadian_face_older_2],

#  ["ranger_master","Avantis","Avantis",tf_hero|tf_unmoveable_in_party_window,0,0,fac_commoners,
#   [itm_village_robe,itm_leather_boots,itm_sword_medieval_a],
#   def_attrib|level(20),wp(120),knows_common|knows_inventory_management_10|knows_power_draw_5, 0x00000001840834485914d426156ab55400000000000d35240000000000000000],   
   
###Rare Specialists + Upgradetroops
#Bishops give a bonus to First Aid + Leadership
#Priests: Give a bonus to Wound Treatment and Morale(?)
  ["skill_priest_jer","Jerusalem Battlefield Priest","Jerusalem Battlefield Priests",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,[itm_priest_tunic,itm_priest_coif,itm_priest_boots,itm_battlefield_cross],def_attrib|level(21),wp(75),knows_common,swadian_face_middle_1, swadian_face_older_2],
  ["skill_bishop_jer","Jerusalem Battlefield Bishop","Jerusalem Battlefield Bishops",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_1,[itm_bishop_tunic,itm_bishop_coif,itm_priest_boots,itm_battlefield_cross],def_attrib|level(23),wp(90),knows_common,swadian_face_middle_1, swadian_face_older_2],
  
  ["skill_priest_ant","Antioch Battlefield Priest","Antioch Battlefield Priests",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,[itm_priest_tunic1,itm_priest_coif1,itm_priest_boots,itm_battlefield_cross],def_attrib|level(21),wp(75),knows_common,swadian_face_middle_1, swadian_face_older_2],
  ["skill_bishop_ant","Antioch Battlefield Bishop","Antioch Battlefield Bishops",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_2,[itm_bishop_tunic1,itm_bishop_coif1,itm_priest_boots,itm_battlefield_cross],def_attrib|level(23),wp(90),knows_common,swadian_face_middle_1, swadian_face_older_2],  
  
  ["skill_mufti_sel","Tarsus Battlefield Mufti","Tarsus Battlefield Muftis",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,[itm_battle_tunic,itm_battle_turban,itm_battle_boots,itm_battlefield_crescent],def_attrib|level(21),wp(75),knows_common,khergit_face_middle_1, khergit_face_older_2],
  ["skill_grandmufti_sel","Tarsus Battlefield Grandmufti","Tarsus Battlefield Grandmuftis",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_3,[itm_battle_tunic,itm_battle_turban,itm_battle_boots,itm_battlefield_crescent],def_attrib|level(23),wp(90),knows_common,khergit_face_middle_1, khergit_face_older_2], 

  ["skill_priest_tem","Acre Battlefield Priest","Acre Battlefield Priests",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,[itm_priest_tunic,itm_priest_coif,itm_priest_boots,itm_battlefield_cross],def_attrib|level(21),wp(75),knows_common,swadian_face_middle_1, swadian_face_older_2],
  ["skill_bishop_tem","Acre Battlefield Bishop","Acre Battlefield Bishops",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_4,[itm_bishop_tunic,itm_bishop_coif,itm_priest_boots,itm_battlefield_cross],def_attrib|level(23),wp(90),knows_common,swadian_face_middle_1, swadian_face_older_2],

  ["skill_priest_hos","Archas Battlefield Priest","Archas Battlefield Priests",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,[itm_priest_tunic1,itm_priest_coif1,itm_priest_boots,itm_battlefield_cross],def_attrib|level(21),wp(75),knows_common,swadian_face_middle_1, swadian_face_older_2],
  ["skill_bishop_hos","Archas Battlefield Bishop","Archas Battlefield Bishops",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_5,[itm_bishop_tunic1,itm_bishop_coif1,itm_priest_boots,itm_battlefield_cross],def_attrib|level(23),wp(90),knows_common,swadian_face_middle_1, swadian_face_older_2],
  
  ["skill_mufti_ayy","Cairo Battlefield Mufti","Cairo Battlefield Muftis",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,[itm_battle_tunic,itm_battle_turban,itm_battle_boots,itm_battlefield_crescent],def_attrib|level(21),wp(75),knows_common,khergit_face_middle_1, khergit_face_older_2],
  ["skill_grandmufti_ayy","Cairo Battlefield Grandmufti","Cairo Battlefield Grandmuftis",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,[itm_battle_tunic,itm_battle_turban,itm_battle_boots,itm_battlefield_crescent],def_attrib|level(23),wp(90),knows_common,khergit_face_middle_1, khergit_face_older_2],   

  ["skill_priest_teu","Teutonic Battlefield Priest","Teutonic Battlefield Priests",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_player_supporters_faction,[itm_priest_tunic2,itm_priest_coif2,itm_priest_boots1,itm_battlefield_cross],def_attrib|level(21),wp(75),knows_common,swadian_face_middle_1, swadian_face_older_2],
  ["skill_bishop_teu","Teutonic Battlefield Bishop","Teutonic Battlefield Bishops",tf_cristiano|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_player_supporters_faction,[itm_bishop_tunic2,itm_bishop_coif2,itm_priest_boots1,itm_battlefield_cross],def_attrib|level(23),wp(90),knows_common,swadian_face_middle_1, swadian_face_older_2],  

  ["skill_end","End","End",tf_guarantee_armor,0,0,fac_commoners,[],def_attrib|level(15),wp(50),knows_common,swadian_face_middle_1, swadian_face_older_2],       
   
  ["looter","Bedouin","Bedouins",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_outlaws,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_tunic_beduin2,itm_tunic_beduin3,itm_tunic_beduin4,itm_camel],
   def_attrib|level(9),wp(75),knows_common|knows_riding_4,khergit_face_younger_1, khergit_face_middle_2],
  ["bandit","Bandit","Bandits",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4,itm_scimitar,itm_boots_light_sar1,itm_boots_light_sar2,itm_leather_boots,itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["brigand","Bandit","Bandits",tf_moro|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_scimitar,itm_scimitar1,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4,itm_wrapping_boots,itm_nomad_boots,itm_leather_boots,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (120) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_5|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
## CC
# Changed order of the bandits and added bandit chiefs. Now the bandits are sorted according to the faction they "belong" to.
  ["forest_bandit","Bedouin","Bedouins",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_outlaws,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_tunic_beduin2,itm_tunic_beduin3,itm_tunic_beduin4,itm_camel],
   def_attrib|level(9),wp(75),knows_common|knows_riding_4,khergit_face_young_1, khergit_face_old_2],
  ["taiga_bandit","Bandit","Bandits",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,itm_khergit_bow,itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["steppe_bandit","Bandit","Bandits",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_armor_steppe1,itm_armor_steppe2,itm_armor_steppe3,itm_armor_steppe4,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,itm_lance_sar,itm_lance_sar1,
    itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_5|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],
  ["sea_raider","Pirate","Pirates",tf_moro|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_outlaws,
   [itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_wrapping_boots,itm_nomad_boots,itm_leather_boots,itm_scimitar,itm_scimitar1,itm_khergit_bow,itm_khergit_bow1,itm_arrows1,itm_arrows2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
  ["mountain_bandit","Bedouin","Bedouins",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_outlaws,
   [itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_tunic_beduin2,itm_tunic_beduin3,itm_tunic_beduin4,itm_boots_light_sar1,itm_boots_light_sar2,itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,
    itm_camel,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(9),wp(75),knows_common|knows_riding_4,khergit_face_young_1, khergit_face_old_2],
  ["desert_bandit","Bandit","Bandits",tf_moro|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_scimitar,itm_scimitar1,itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_8|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],

  ["chief_forest_bandit","Bedouin Chief","Bedouins Chief",tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_tunic_beduin2,itm_tunic_beduin3,itm_tunic_beduin4,itm_camel],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_4|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["chief_taiga_bandit","Bandit Chief","Bandits Chief",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_outlaws,
   [itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,itm_khergit_bow,itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (120) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_5|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
  ["chief_steppe_bandit","Bandit Chief","Bandits Chief",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_outlaws,
   [itm_armor_steppe1,itm_armor_steppe2,itm_armor_steppe3,itm_armor_steppe4,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_scimitar,itm_scimitar1,itm_boots_light_sar1,itm_boots_light_sar2,itm_lance_sar,itm_lance_sar1,
    itm_turk1,itm_turk2,itm_turk3,itm_turk4,itm_turk5,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_melee(125)| wp_archery (100),knows_common|knows_riding_5|knows_ironflesh_3|knows_shield_3|knows_power_strike_3,khergit_face_young_1, khergit_face_old_2],
  ["chief_sea_raider","Pirate Captain","Pirates Captain",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_outlaws,
   [itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_wrapping_boots,itm_nomad_boots,itm_leather_boots,itm_scimitar,itm_scimitar1,itm_khergit_bow,itm_khergit_bow1,itm_arrows1,itm_arrows2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(21),wp_melee(120) | wp_archery (120),knows_common|knows_shield_3|knows_power_draw_5|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,khergit_face_young_1, khergit_face_old_2],
  ["chief_mountain_bandit","Bedouin Chief","Bedouins Chief",tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged,0,0,fac_outlaws,
   [itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_tunic_beduin2,itm_tunic_beduin3,itm_tunic_beduin4,itm_boots_light_sar1,itm_boots_light_sar2,itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,
    itm_camel,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6],
   def_attrib|level(14),wp_one_handed (80) | wp_two_handed (80) | wp_polearm (80) | wp_archery (110) | wp_crossbow (80) | wp_throwing (110),knows_riding_4|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_3,khergit_face_young_1, khergit_face_old_2],
  ["chief_desert_bandit","Bandit Chief","Bandits Chief",tf_mounted|tf_guarantee_horse|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_outlaws,
   [itm_scimitar,itm_scimitar1,itm_khergit_bow,itm_khergit_bow1,itm_khergit_bow2,itm_arrows1,itm_arrows2,itm_arrows,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_armor_desert1,itm_armor_desert2,itm_armor_desert3,itm_armor_desert4],
   def_attrib|level(21),wp_one_handed (90) | wp_two_handed (90) | wp_polearm (90) | wp_archery (120) | wp_crossbow (90) | wp_throwing (130),knows_riding_8|knows_power_draw_5|knows_ironflesh_3|knows_horse_archery_5|knows_power_throw_4|knows_shield_1,khergit_face_young_1, khergit_face_old_2],
## CC 

 #hispania1200 taverna  Daedalus / Slawomir of Aaarrghh
["musican_male","Musician","Musician",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,[itm_village_robe4,itm_village_robe5,itm_nomad_boots],def_attrib|level(4),wp(60),knows_common,man_face_young_1, man_face_old_2],
["musican_female","Musician","Musician",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,[itm_sarranid_common_dress,itm_woolen_hose],def_attrib|level(2),wp(40),knows_common,woman_face_1,woman_face_2],
["musicans_end","_","_",tf_inactive,0,0,0,[],0,0,0,0],

# fin #hispania1200 taverna  Daedalus / Slawomir of Aaarrghh    

  ["caravan_master","Caravan Master","Caravan Masters",tf_guarantee_helmet|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_camel,
    itm_shield_ayyinf1,itm_shield_ayyinf2,itm_shield_ayyinf3,itm_shield_ayyinf4,itm_shield_ayyinf5,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_light_sar1,itm_boots_light_sar2],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],

  ["ship_captain","Ship Captain","Ship Captains",tf_guarantee_helmet|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_scimitar,itm_scimitar1,itm_shield_sar1,itm_shield_sar2,itm_shield_sar3,itm_shield_sar4,itm_shield_sar5,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_light_sar1,itm_boots_light_sar2],
   def_attrib|level(14),wp_melee(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,khergit_face_young_1, khergit_face_old_2],   
   
  ["kidnapped_girl","Kidnapped Girl","Kidnapped Girls",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_commoners,
   [itm_dress,itm_leather_boots],
   def_attrib|level(2),wp(50),knows_common|knows_riding_2,khergit_woman_face_1, khergit_woman_face_2],

## CC
  ["black_khergit_horseman","Black Khergit Horseman","Black Khergit Horsemen",tf_mounted|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse,0,0,fac_black_khergits,
   [itm_khergit_arrows,itm_sword_khergit_2,itm_scimitar,itm_winged_mace,itm_spear,itm_lance,itm_khergit_bow,itm_nomad_bow,itm_black_helmet,itm_black_armor,itm_black_greaves,itm_mail_mittens,itm_tab_shield_heater_cav_b],
   def_attrib|level(21),wp(100),knows_riding_4|knows_ironflesh_3|knows_horse_archery_3|knows_power_draw_3,khergit_face_young_1, khergit_face_old_2],
  ["black_khergit_guard","Black Khergit Guard","Black Khergit Guard", tf_allways_fall_dead|tf_mounted|tf_guarantee_ranged|tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_black_khergits,
  [itm_khergit_arrows,itm_scimitar,itm_winged_mace,itm_lance,itm_khergit_bow,itm_khergit_bow,itm_tab_shield_heater_cav_b,
   itm_black_helmet,itm_black_greaves,itm_black_armor,itm_mail_mittens],
def_attrib|level(28),wp(140),knows_riding_6|knows_ironflesh_4|knows_horse_archery_6|knows_power_draw_6,khergit_face_middle_2, khergit_face_old_1],
  ["black_khergit_lancer","Black Khergit Lancer","Black Khergit Lancer", tf_allways_fall_dead|tf_mounted|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_black_khergits,
  [itm_lance,itm_heavy_lance,itm_scimitar,itm_winged_mace,itm_tab_shield_heater_cav_b,
   itm_black_helmet,itm_black_greaves,itm_black_armor,itm_mail_mittens],
def_attrib|level(30),wp(160),knows_riding_6|knows_ironflesh_4|knows_power_strike_3,khergit_face_middle_1, khergit_face_old_1],
  ["dark_hunter","Dark Hunter","Dark Hunters",tf_mounted|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse,0,0,fac_dark_knights,
   [itm_lance,itm_battle_axe,itm_morningstar,itm_black_armor,itm_black_greaves,itm_black_helmet,itm_mail_mittens,itm_tab_shield_heater_cav_b],
   def_attrib|level(23),wp(120),knows_common|knows_riding_4|knows_shield_3|knows_ironflesh_2|knows_power_strike_2,swadian_face_middle_1, swadian_face_young_1],
  ["dark_sniper","Dark Sniper","Dark Snipers", tf_allways_fall_dead|tf_mounted|tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet,0,0,fac_dark_knights,
   [itm_sniper_crossbow, itm_sniper_crossbow, itm_steel_bolts, itm_sword_of_war,itm_morningstar,itm_great_axe,itm_tab_shield_heater_cav_b,
itm_black_armor,itm_black_greaves,itm_black_helmet,itm_mail_mittens],
   def_attrib|level(30),wp(140),knows_common|knows_shield_2|knows_ironflesh_3|knows_power_strike_2|knows_athletics_3, swadian_face_older_2, swadian_face_old_2],
  ["dark_knight","Dark Knight","Dark Knights", tf_allways_fall_dead|tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_horse,0,0,fac_dark_knights,
   [itm_heavy_lance,itm_bastard_sword_b,itm_tab_shield_heater_cav_b,
itm_black_armor,itm_black_greaves,itm_black_helmet,itm_mail_mittens],
   def_attrib|level(33),wp(160),knows_common|knows_riding_5|knows_shield_3|knows_ironflesh_4|knows_power_strike_3,swadian_face_middle_2, swadian_face_older_2],
## CC

#This troop is the troop marked as soldiers_end and town_walkers_begin
 ["town_walker_1","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_young_1, khergit_face_old_2],
 ["town_walker_2","Townswoman","Townswomen",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(2),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],
 ["khergit_townsman","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_kingdom_6,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_young_1, khergit_face_old_2],
 ["khergit_townswoman","Townswoman","Townswomen",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(2),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],
 ["sarranid_townsman","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_kingdom_6,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_young_1, khergit_face_old_2],
 ["sarranid_townswoman","Townswoman","Townswomen",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(2),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],
  
#This troop is the troop marked as town_walkers_end and village_walkers_begin
 ["village_walker_1","Villager","Villagers",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_younger_1, khergit_face_older_2],
 ["village_walker_2","Villager","Villagers",tf_female|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(2),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],

#This troop is the troop marked as village_walkers_end and spy_walkers_begin
 ["spy_walker_1","Townsman","Townsmen",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_commoners,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,khergit_face_middle_1, khergit_face_old_2],
 ["spy_walker_2","Townswoman","Townswomen",tf_female|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_commoners,
   [itm_sarranid_common_dress, itm_sarranid_common_dress_b,itm_woolen_hose,itm_sarranid_boots_a, itm_sarranid_felt_head_cloth, itm_sarranid_felt_head_cloth_b],
   def_attrib|level(2),wp(40),knows_common,khergit_woman_face_1,khergit_woman_face_2],
# Ryan END

#This troop is the troop marked as spy_walkers_end
# Zendar
  ["tournament_master","Tournament Master","Tournament Master",tf_hero, scn_zendar_center|entry(1),reserved,  fac_commoners,[itm_village_robe1,itm_nomad_boots],def_attrib|level(2),wp(20),knows_common,0x000000000008414401e28f534c8a2d09],
  ["trainer","Trainer","Trainer",tf_hero, scn_zendar_center|entry(2),reserved,  fac_commoners,[itm_village_robe2,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x00000000000430c701ea98836781647f],
  ["Constable_Hareck","Constable Hareck","Constable Hareck",tf_hero, scn_zendar_center|entry(5),reserved,  fac_commoners,[itm_village_robe3,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x00000000000c41c001fb15234eb6dd3f],

# Ryan BEGIN
  ["Ramun_the_slave_trader","Ramun, the slave trader","Ramun, the slave trader",tf_hero, no_scene,reserved, fac_commoners,[itm_village_robe,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x0000000fd5105592385281c55b8e44eb00000000001d9b220000000000000000],

  ["guide","Quick Jimmy","Quick Jimmy",tf_hero, no_scene,0,  fac_commoners,[itm_village_robe,itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, 0x00000000000c318301f24e38a36e38e3],
# Ryan END

  ["inventory_backup","{!}Inventory","{!}Inventory",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib|level(18),wp(60),knows_inventory_management_10,0],


  ["quickbattle_crossbow_militia","Crossbow Militia","Crossbow Militia",tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_bolts,itm_light_crossbow,itm_hunting_crossbow,itm_sword_medieval_a,itm_voulge,
    itm_ankle_boots,itm_arming_cap],def_attrib|level(15),wp(80),knows_common|knows_ironflesh_2|knows_power_strike_2|knows_power_draw_3|knows_power_throw_3|knows_shield_2|knows_athletics_3,swadian_face_young_1, swadian_face_middle_2],
  ["quickbattle_crossbowman","Crossbowman","Crossbowmen",tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_war_bow, itm_light_lance, itm_bodkin_arrows, itm_leather_boots],def_attrib|level(18),wp(90)|wp_crossbow(110)|wp_archery(110)|wp_throwing(110),knows_common|knows_ironflesh_3|knows_power_strike_3|knows_power_draw_4|knows_power_throw_4|knows_shield_3|knows_athletics_4,swadian_face_young_1, swadian_face_old_2],
  ["quickbattle_infantry","Infantry","Infantry",tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_spear,itm_fighting_pick,
    itm_ankle_boots,itm_leather_gloves],def_attrib|level(15),wp(85),knows_common|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_young_1, swadian_face_old_2],
  ["quickbattle_warrior","Warrior","Warriors",tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_pike,itm_fighting_pick,itm_bastard_sword_a,
    itm_leather_gloves,itm_leather_boots],def_attrib|level(21),wp(110),knows_common|knows_ironflesh_3|knows_power_strike_3|knows_shield_3|knows_athletics_3,swadian_face_middle_1, swadian_face_old_2],
  ["quickbattle_squire","Squire","Squires",tf_mounted|tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_lance,itm_sword_medieval_a,
    itm_leather_boots,itm_leather_gloves],def_attrib|level(21),wp(110),knows_common|knows_ironflesh_3|knows_power_strike_3|knows_shield_3|knows_riding_4|knows_athletics_2,swadian_face_middle_1, swadian_face_older_2],
  ["quickbattle_knight","Feudal Knight","Feudal Knights",tf_mounted|tf_guarantee_all,0,0,fac_player_supporters_faction,[itm_heavy_lance,itm_bastard_sword_b,
    itm_mail_boots,itm_great_helmet,itm_mail_mittens],def_attrib|level(28),wp(150),knows_common|knows_ironflesh_5|knows_power_strike_5|knows_shield_5|knows_riding_5|knows_athletics_2,swadian_face_middle_1, swadian_face_older_2],

 ["psf_messenger","Messenger","Messengers",tf_cristiano|tf_mounted|tf_guarantee_all,0,0,fac_player_supporters_faction,
   [itm_sword_medieval_teu,itm_sergeant_teu1,itm_mail_boots1,itm_hunter1,itm_helmet1],
   def_attrib|level(21),wp_melee(135),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4,swadian_face_younger_1, swadian_face_old_2],
 ["psf_deserter","Deserter","Deserters",tf_cristiano|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_deserters,
   [itm_axe_cru1,itm_axe_cru2,itm_falchion,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_hunter1,itm_hunter2,itm_hunter3,itm_hunter4,
   itm_shield_veteran_teu1,itm_shield_veteran_teu2,itm_shield_veteran_teu3,itm_shield_veteran_teu4,itm_novici_teu,itm_helmet_lig1,itm_helmet_lig2,itm_helmet_lig3,itm_helmet_lig5,itm_helmet_lig6,itm_helmet_lig7,itm_boots_light_cru1,itm_boots_light_cru2,itm_boots_light_cru3,itm_boots_light_cru4],
   def_attrib|level(14),wp_melee(85),knows_common|knows_riding_2|knows_ironflesh_2|knows_shield_2|knows_athletics_2|knows_power_strike_2,swadian_face_younger_1, swadian_face_old_2],
 ["psf_prison_guard","Monk","Monks",tf_cristiano|tf_guarantee_all,0,0,fac_player_supporters_faction,
   [itm_sword_medieval_teu,itm_sergeant_teu3,itm_sergeant_teu4,itm_mail_boots2,itm_coif_black,itm_shield_veteran_teu6],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
 ["psf_castle_guard","Monk","Monks",tf_cristiano|tf_guarantee_all,0,0,fac_player_supporters_faction,
   [itm_sword_medieval_teu,itm_sergeant_teu3,itm_sergeant_teu4,itm_mail_boots2,itm_coif_black,itm_shield_veteran_teu6],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],

#Cheap patrol unit with low upkeep.
  ["mounted_patrol","Mounted Patrol","Mounted Patrol",tf_mounted|tf_guarantee_all,0,0,fac_commoners,
   [itm_lance_sar,itm_lance_sar1,itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,
    itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10,itm_boots_light_sar1,itm_boots_light_sar2,itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4],
   def_attrib|level(18),wp(80),knows_common, khergit_face_young_1, khergit_face_old_2],
# Custom Troops end
####################

## CC bandit heroes
  ["forest_bandit_hero","{!}Forest Bandit Hero","{!}Forest Bandits",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(22),wp(180),knows_common|knows_power_strike_3|knows_power_draw_6|knows_tactics_4|knows_leadership_4,swadian_face_young_1, swadian_face_old_2],
  ["taiga_bandit_hero","{!}Taiga Bandit Hero","{!}Taiga Bandits",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(30),wp(220),knows_common|knows_power_draw_8|knows_power_strike_4|knows_power_throw_6|knows_tactics_6|knows_leadership_6,vaegir_face_young_1, vaegir_face_old_2],
  ["steppe_bandit_hero","{!}Steppe Bandit Hero","{!}Steppe Bandits",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(24),wp(200),knows_riding_8|knows_power_strike_3|knows_horse_archery_6|knows_power_draw_6|knows_tactics_5|knows_leadership_5,khergit_face_young_1, khergit_face_old_2],
  ["sea_raider_hero","{!}Viking Hero","{!}Vikings",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(32),wp(220),knows_ironflesh_4|knows_power_strike_4|knows_power_draw_6|knows_power_throw_4|knows_riding_2|knows_athletics_4|knows_tactics_6|knows_leadership_6,nord_face_young_1, nord_face_old_2],
  ["mountain_bandit_hero","{!}Mountain Bandit Hero","{!}Mountain Bandits",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(22),wp(180),knows_common|knows_power_strike_2|knows_power_draw_4|knows_tactics_4|knows_leadership_4,rhodok_face_young_1, rhodok_face_old_2],
  ["desert_bandit_hero","{!}Desert Bandit Hero","{!}Desert Bandits",tf_hero|tf_randomize_face,0,0,fac_outlaws,
   [],
   def_attrib|level(24),wp(200),knows_riding_8|knows_horse_archery_6|knows_power_strike_3|knows_power_draw_6|knows_tactics_5|knows_leadership_5,khergit_face_young_1, khergit_face_old_2],
## CC


  ["Xerina","Xerina","Xerina",tf_hero|tf_female, scn_the_happy_boar|entry(5),reserved,  fac_commoners,[itm_village_robe1,itm_hide_boots],def_attrib|str_15|agi_15|level(39),wp(312),knows_power_strike_5|knows_ironflesh_5|knows_riding_6|knows_power_draw_4|knows_athletics_8|knows_shield_3,0x00000001ac0820074920561d0b51e6ed00000000001d40ed0000000000000000],
  ["Dranton","Dranton","Dranton",tf_hero, scn_the_happy_boar|entry(2),reserved,  fac_commoners,[itm_village_robe2,itm_hide_boots],def_attrib|str_15|agi_14|level(42),wp(324),knows_power_strike_5|knows_ironflesh_7|knows_riding_4|knows_power_draw_4|knows_athletics_4|knows_shield_3,0x0000000a460c3002470c50f3502879f800000000001ce0a00000000000000000],
  ["Kradus","Kradus","Kradus",tf_hero, scn_the_happy_boar|entry(3),reserved,  fac_commoners,[itm_village_robe3,itm_hide_boots],def_attrib|str_15|agi_14|level(43),wp(270),knows_power_strike_5|knows_ironflesh_7|knows_riding_4|knows_power_draw_4|knows_athletics_4|knows_shield_3,0x0000000f5b1052c61ce1a9521db1375200000000001ed31b0000000000000000],


#Tutorial
  ["tutorial_trainer","Training Ground Master","Training Ground Master",tf_hero, 0, 0, fac_commoners,[itm_robe,itm_nomad_boots],def_attrib|level(2),wp(20),knows_common,0x000000000008414401e28f534c8a2d09],
  ["tutorial_student_1","{!}tutorial_student_1","{!}tutorial_student_1",tf_guarantee_boots|tf_guarantee_armor, 0, 0, fac_neutral,
   [itm_practice_sword, itm_practice_shield, itm_leather_jerkin,itm_padded_leather,itm_leather_armor,itm_ankle_boots,itm_padded_coif],
   def_attrib|level(2),wp(20),knows_common, swadian_face_young_1, swadian_face_old_2],
  ["tutorial_student_2","{!}tutorial_student_2","{!}tutorial_student_2",tf_guarantee_boots|tf_guarantee_armor, 0, 0, fac_neutral,
   [itm_practice_sword, itm_practice_shield, itm_leather_jerkin,itm_padded_leather,itm_leather_armor,itm_ankle_boots,itm_padded_coif],
   def_attrib|level(2),wp(20),knows_common, swadian_face_young_1, swadian_face_old_2],
  ["tutorial_student_3","{!}tutorial_student_3","{!}tutorial_student_3",tf_guarantee_boots|tf_guarantee_armor, 0, 0, fac_neutral,
   [itm_practice_staff, itm_leather_jerkin,itm_padded_leather,itm_leather_armor,itm_ankle_boots,itm_padded_coif],
   def_attrib|level(2),wp(20),knows_common, swadian_face_young_1, swadian_face_old_2],
  ["tutorial_student_4","{!}tutorial_student_4","{!}tutorial_student_4",tf_guarantee_boots|tf_guarantee_armor, 0, 0, fac_neutral,
   [itm_practice_staff, itm_leather_jerkin,itm_padded_leather,itm_leather_armor,itm_ankle_boots,itm_padded_coif],
   def_attrib|level(2),wp(20),knows_common, swadian_face_young_1, swadian_face_old_2],

#Sargoth
  #halkard, hardawk. lord_taucard lord_caupard. lord_paugard

#Salt mine
  ["Galeas","Galeas","Galeas",tf_hero, 0, reserved, fac_commoners,[itm_village_robe6,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,0x000000000004718201c073191a9bb10c],

#Dhorak keep

  ["farmer_from_bandit_village","Farmer","Farmers",tf_guarantee_boots|tf_guarantee_armor,no_scene,reserved,fac_commoners,
   [itm_beduin_turban1,itm_nomad_boots,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,man_face_middle_1, man_face_older_2],

  ["trainer_1","Trainer","Trainer",tf_hero, scn_training_ground_ranged_melee_1|entry(6),reserved,  fac_commoners,[itm_village_robe,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x0000000d0d1030c74ae8d661b651c6840000000000000e220000000000000000],
  ["trainer_2","Trainer","Trainer",tf_hero, scn_training_ground_ranged_melee_2|entry(6),reserved,  fac_commoners,[itm_village_robe1,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x0000000e5a04360428ec253846640b5d0000000000000ee80000000000000000],
  ["trainer_3","Trainer","Trainer",tf_hero, scn_training_ground_ranged_melee_3|entry(6),reserved,  fac_commoners,[itm_village_robe2,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x0000000e4a0445822ca1a11ab1e9eaea0000000000000f510000000000000000],
  ["trainer_4","Trainer","Trainer",tf_hero, scn_training_ground_ranged_melee_4|entry(6),reserved,  fac_commoners,[itm_village_robe3,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x0000000e600452c32ef8e5bb92cf1c970000000000000fc20000000000000000],
  ["trainer_5","Trainer","Trainer",tf_hero, scn_training_ground_ranged_melee_5|entry(6),reserved,  fac_commoners,[itm_village_robe4,itm_hide_boots],def_attrib|level(2),wp(20),knows_common,0x0000000e77082000150049a34c42ec960000000000000e080000000000000000],

# Ransom brokers.
  ["ransom_broker_1","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_2","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe1,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_3","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_4","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe3,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_5","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe4,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_6","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe5,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_7","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe6,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_8","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_9","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe1,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["ransom_broker_10","Ransom_Broker","Ransom_Broker",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe2,itm_hide_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],

# Tavern traveler.
  ["tavern_traveler_1","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_2","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe1,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_3","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe2,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_4","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe3,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_5","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe4,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_6","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe5,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_7","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe6,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_8","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_9","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe1,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],
  ["tavern_traveler_10","Traveller","Traveller",tf_hero|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe2,itm_nomad_boots],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],

# Tavern traveler.
## CC
  ["tavern_bookseller_1","Book_Merchant","Book_Merchant",tf_hero|tf_is_merchant|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe,itm_hide_boots,
itm_book_tactics, itm_book_persuasion, itm_book_spotting_reference, itm_book_leadership, itm_book_intelligence, itm_book_training_reference, itm_book_surgery_reference, itm_book_trade_ledger],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2], ## Merchant's Trade Ledger
  ["tavern_bookseller_2","Book_Merchant","Book_Merchant",tf_hero|tf_is_merchant|tf_randomize_face, 0, reserved, fac_commoners,[itm_village_robe1,itm_hide_boots,
itm_book_wound_treatment_reference, itm_book_prisoner_management, itm_book_first_aid_reference, itm_book_trade, itm_book_engineering, itm_book_weapon_mastery, itm_book_pathfinding_reference],def_attrib|level(5),wp(20),knows_common,merchant_face_1, merchant_face_2],
## CC

# Tavern minstrel.
  ["tavern_minstrel_1","Wandering Ashik","Ashik",tf_hero|tf_randomize_face|tf_guarantee_shield|tf_guarantee_armor|tf_guarantee_boots, 0, reserved, fac_commoners,[itm_village_robe, itm_hide_boots, itm_lute],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2], #lute
  ["tavern_minstrel_2","Wandering Ashik","Ashik",tf_hero|tf_randomize_face|tf_guarantee_shield|tf_guarantee_armor|tf_guarantee_boots, 0, reserved, fac_commoners,[itm_village_robe1, itm_hide_boots, itm_lyre],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2],  #early harp/lyre
  ["tavern_minstrel_3","Wandering Ashik","Ashik",tf_hero|tf_randomize_face|tf_guarantee_shield|tf_guarantee_armor|tf_guarantee_boots, 0, reserved, fac_commoners,[itm_village_robe2, itm_hide_boots, itm_lute],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2], #lute/oud or rebab
  ["tavern_minstrel_4","Wandering Ashik","Ashik",tf_hero|tf_randomize_face|tf_guarantee_shield|tf_guarantee_armor|tf_guarantee_boots, 0, reserved, fac_commoners,[itm_village_robe3, itm_hide_boots, itm_lyre],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2], #No instrument or lyre
  ["tavern_minstrel_5","Wandering Ashik","Ashik",tf_hero|tf_randomize_face|tf_guarantee_shield|tf_guarantee_armor|tf_guarantee_boots, 0, reserved, fac_commoners,[itm_village_robe4, itm_hide_boots, itm_lute],def_attrib|level(5),wp(20),knows_common,merchant_face_1,merchant_face_2], #Lute or Byzantine/Occitan lyra
  
#NPC system changes begin
#Companions
  ["kingdom_heroes_including_player_begin",  "kingdom_heroes_including_player_begin",  "kingdom_heroes_including_player_begin",  tf_hero, 0,reserved,  fac_kingdom_1,[],          lord_attrib,wp(220),knows_lord_1, 0x000000000010918a01f248377289467d],

  ["npc1","Doruk","Doruk",tf_hero|tf_unmoveable_in_party_window, 0, reserved, fac_commoners,[itm_tunic_sar1,itm_boots_light_sar1,itm_sword_arabian_small],
   str_8|agi_7|int_12|cha_7|level(3),wp(60),knows_tracker_npc|
   knows_ironflesh_1|knows_power_strike_1|knows_pathfinding_3|knows_athletics_2|knows_tracking_1|knows_riding_2, #skills 2/3 player at that level
   0x00000001b60043c55ad9ae67244a82a200000000001ecb120000000000000000],
  ["npc2","Aldric","Aldric", tf_hero|tf_unmoveable_in_party_window, 0,reserved, fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3,itm_sword_medieval_b_small],
   str_7|agi_7|int_11|cha_6|level(1),wp(40),knows_merchant_npc|
   knows_trade_2|knows_weapon_master_1|knows_ironflesh_1|knows_wound_treatment_1|knows_athletics_2|knows_first_aid_1|knows_leadership_1,
   0x00000001880815904514a59aee6664a400000000001db4d50000000000000000],
  ["npc3","Chryssa","Chryssa",tf_female|tf_hero|tf_unmoveable_in_party_window, 0, reserved, fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3,itm_falchion],
   str_6|agi_9|int_11|cha_6|level(1),wp(20),knows_merchant_npc|
   knows_wound_treatment_1|knows_trade_1|knows_first_aid_3|knows_surgery_1|knows_athletics_1|knows_riding_1,
   0x00000001800c10033716add53368b8dc00000000001e53940000000000000000],
  ["npc4","Afzal","Afzal",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_tunic_sar1,itm_boots_light_sar1,itm_sword_arabian_small],
   str_10|agi_9|int_13|cha_10|level(10),wp(110),knows_warrior_npc|
   knows_weapon_master_2|knows_power_strike_2|knows_riding_2|knows_athletics_2|knows_power_throw_2|knows_first_aid_1|knows_surgery_1|knows_tactics_2|knows_leadership_2,
   0x00000001a20c42846b114ddb228db72900000000001de5190000000000000000],
  ["npc5","Adil","Adil",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_tunic_sar1,itm_boots_light_sar1, itm_sword_arabian_small],
   str_9|agi_9|int_12|cha_7|level(5),wp(90),knows_warrior_npc|
   knows_riding_2|knows_horse_archery_3|knows_power_draw_3|knows_leadership_2|knows_weapon_master_1,
   0x000000018410428c2a5396bccdb4eb4b00000000001e365b0000000000000000],
  ["npc6","Fulbert","Fulbert",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3, itm_sword_medieval_b_small],
   str_10|agi_12|int_10|cha_5|level(6),wp(105),knows_warrior_npc|
   knows_riding_2|knows_weapon_master_2|knows_power_strike_2|knows_athletics_3|knows_trainer_1|knows_leadership_1,
  0x00000001b700058f4a6d6d574e5a2aeb00000000001db9610000000000000000],
  ["npc7","Cassandra","Cassandra",tf_female|tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3, itm_hunting_bow, itm_arrows,itm_falchion],
   str_8|agi_9|int_10|cha_6|level(2),wp(80),knows_tracker_npc|
   knows_tracking_2|knows_athletics_2|knows_spotting_1|knows_pathfinding_1|knows_power_draw_2,
   0x000000018f100006261c51ac916f594d00000000001cca2d0000000000000000],
  ["npc8","Adele","Adele",tf_female|tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_sword_medieval_b_small],
   str_9|agi_10|int_9|cha_10|level(7),wp(90),knows_warrior_npc|
   knows_weapon_master_3|knows_power_strike_2|knows_athletics_2|knows_leadership_3|knows_tactics_1,
   0x000000018000000136db6db6db6db6db00000000001db6db0000000000000000],
  ["npc9","Jason","Jason",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3, itm_sword_medieval_b_small],
   str_11|agi_8|int_7|cha_8|level(2),wp(100),knows_warrior_npc|
   knows_weapon_master_1|knows_riding_1|knows_athletics_1|knows_leadership_1|knows_tactics_1|knows_power_strike_1,
   0x000000018a0c6289469a4636a416370e00000000001c2b1c0000000000000000],
  ["npc10","Hector","Hector",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_crossbow, itm_bolts,itm_falchion],
   str_12|agi_8|int_9|cha_11|level(9),wp(105),knows_warrior_npc|
   knows_weapon_master_3|knows_tactics_1|knows_leadership_1|knows_ironflesh_3|knows_trainer_2|knows_first_aid_2,
   0x000000018b0452413adbedb65caebcdc00000000001e120a0000000000000000],
  ["npc11","Jeanne","Jeanne",tf_female|tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1, itm_sword_medieval_b_small, itm_boots_light_cru3],
   str_8|agi_11|int_10|cha_10|level(8),wp(70),knows_merchant_npc|
   knows_weapon_master_1|knows_first_aid_1|knows_wound_treatment_2|knows_ironflesh_3|knows_inventory_management_5,
   0x00000001800420067ad9955ace3159e400000000001dcadc0000000000000000],
  ["npc12","Pierre","Pierre",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3, itm_falchion],
   str_8|agi_7|int_13|cha_7|level(4),wp(30),   knows_merchant_npc|
   knows_ironflesh_1|knows_power_strike_1|knows_surgery_4|knows_wound_treatment_3|knows_first_aid_3,
   0x000000085108500e232caab48d85cc5c00000000001e56eb0000000000000000],
  ["npc13","Haidar","Haidar",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_tunic_sar2,itm_boots_light_sar1, itm_scimitar],
   str_7|agi_7|int_12|cha_8|level(3),wp(80),knows_warrior_npc|
   knows_riding_2|knows_leadership_2|knows_athletics_2|knows_ironflesh_2|knows_power_strike_1|knows_weapon_master_1,
   0x00000001ac0441883b24a6a5238c592300000000001da6b50000000000000000],
  ["npc14","Levon","Levon",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_sword_medieval_b_small],
   str_9|agi_8|int_11|cha_8|level(5),wp(100),knows_warrior_npc|
   knows_trainer_4|knows_weapon_master_3|knows_leadership_2|knows_power_strike_1,
   0x000000018e0855821526bb94cb8a32db00000000001d444c0000000000000000],
  ["npc15","Gautier","Gautier",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru3, itm_falchion],
   str_9|agi_9|int_12|cha_8|level(7),wp(80),knows_warrior_npc|
   knows_tactics_2|knows_engineer_4|knows_trade_3|knows_tracking_1|knows_spotting_1,
   0x000000018108028f4ac98d9aa3bac25300000000001eb6b00000000000000000],
  ["npc16","Catherine","Catherine",tf_female|tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_hunting_bow, itm_arrows,itm_falchion],
   str_7|agi_11|int_8|cha_7|level(2),wp(80),knows_tracker_npc|
   knows_power_draw_3|knows_athletics_2|knows_power_strike_1,
   0x00000001b5101007599b46b2e3395d2d000000000019dd230000000000000000],
   
## Teutonic Companions Begin

  ["npc17","Walpot von Bassenheim","Walpot von Bassenheim",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_sword_medieval_b_small2],
   str_12|agi_9|int_13|cha_12|level(10),wp(115),knows_warrior_npc|
   knows_weapon_master_4|knows_power_strike_3|knows_riding_4|knows_athletics_3|knows_first_aid_1|knows_surgery_1|knows_tactics_3|knows_leadership_3,
   0x00000001800813484d6156c8a353576400000000001d1cac0000000000000000],
   
  ["npc18","Otto von Kerpen","Otto von Kerpen",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary2,itm_boots_light_cru4, itm_sword_medieval_b_small2],
   str_12|agi_9|int_13|cha_12|level(10),wp(115),knows_warrior_npc|
   knows_weapon_master_4|knows_power_strike_3|knows_riding_4|knows_athletics_3|knows_first_aid_1|knows_surgery_1|knows_tactics_3|knows_leadership_3,
   0x00000002000002813aacb3a919b758dd00000000001deaf10000000000000000],

  ["npc19","Heinrich von Tunna","Heinrich von Tunna",tf_hero|tf_unmoveable_in_party_window, 0, reserved,  fac_commoners,[itm_novici_mercenary1,itm_boots_light_cru3, itm_sword_medieval_b_small2],
   str_12|agi_9|int_13|cha_12|level(10),wp(115),knows_warrior_npc|
   knows_weapon_master_4|knows_power_strike_3|knows_riding_4|knows_athletics_3|knows_first_aid_1|knows_surgery_1|knows_tactics_3|knows_leadership_3,
   0x000000021408131024e46ea715755d7300000000001dd6d30000000000000000],   

## Teutonic Companions End
#NPC system changes end


#governers olgrel rasevas                                                                        Horse          Bodywear                Footwear_in                     Footwear_out                    Armor                       Weapon                  Shield                  Headwaer
  ["kingdom_1_lord",  "King Baldwin IV",  "Baldwin IV",  tf_hero, 0,reserved,  fac_kingdom_1,[itm_horse_jer_lord,   itm_courtly_outfit_baldwin,        itm_courtly_mail_boots,    itm_courtly_mask_jer,              itm_mail_boots1,               itm_lord_jer, itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,      itm_shield_knight_jer7,       itm_mask_jer],          knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000000005000479249d79b55a15600000000001cc4a60000000000000000],
  ["kingdom_2_lord",  "Prince Bohemond III",  "Bohemond III",  tf_hero, 0,reserved,  fac_kingdom_2,[itm_horse_ant2,    itm_courtly_outfit_ant,      itm_courtly_mail_boots,             itm_mail_boots1,              itm_knight_ant8, itm_mail_mittens1,      itm_sword_medieval_a2,itm_lance_banner_ant,      itm_shield_knight_ant7,      itm_helm_red],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000060610100258e26aa58c80b00b00000000001d36660000000000000000],
  ["kingdom_3_lord",  "Sultan Kilij Arslan II",  "Kilij Arslan II",  tf_hero, 0,reserved,  fac_kingdom_3,[itm_horse_sel_lord,   itm_courtly_outfit_sel,             itm_courtly_seljuk_boots,              itm_boots_cav_sel1,           itm_mamluk_sel3,  itm_gauntlets_sar1,       itm_scimitar3,itm_lance_banner_sar,              itm_shield_ayycav5,       itm_helm_sel3],      knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001bf1044c168e9713b634d96e200000000001eab420000000000000000],
  ["kingdom_4_lord",  "Gandmaster Gerard de Ridefort",  "Gerard de Ridefort",  tf_hero, 0,reserved,  fac_kingdom_4,[itm_horse_tem_lord,    itm_courtly_master_tem,    itm_courtly_mail_boots,              itm_mail_boots1,                 itm_lord_tem,  itm_mail_mittens1,    itm_sword_medieval_tem, itm_lance_banner_tem,          itm_shield_knight_tem3,    itm_helm_tem],            knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000004cc101252491e8dc9632a14d400000000001c476a0000000000000000],
  ["kingdom_5_lord",  "Gandmaster Roger de Moulins",  "Roger de Moulins",  tf_hero, 0,reserved,  fac_kingdom_5,[itm_horse_hos_lord,  itm_courtly_master_hos,             itm_courtly_mail_boots,              itm_mail_boots1,   itm_lord_hos,  itm_mail_mittens1,         itm_sword_medieval_hos, itm_lance_banner_hos,        itm_shield_knight_hos4,        itm_helm_hos],         knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000018a0411d22b1355ab6a78d50c00000000001ec8ae0000000000000000],
  ["kingdom_6_lord",  "Sultan Salah al-Din",  "Salah al-Din",  tf_hero, 0,reserved,  fac_kingdom_6,[itm_horse_ayy_lord,  itm_courtly_outfit_saladin,   itm_courtly_saracen_boots,   itm_boots_cav_ayy2,      itm_lord_sar,    itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,    itm_shield_ayycav2, itm_helmet_lord_sar],         knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_5, 0x000000023f004347471a8e34d345b91b00000000001db4da0000000000000000],


#    Imbrea   Belinda Ruby Qaelmas Rose    Willow 
#  Alin  Ganzo            Zelka Rabugti
#  Qlurzach Ruhbus Givea_alsev  Belanz        Bendina  
# Dunga        Agatha     Dibus Crahask

#                                                                               Horse                   Bodywear                Armor                               Footwear_in                 Footwear_out                        Headwear                    Weapon               Shield
  #Swadian civilian clothes: itm_courtly_outfit itm_gambeson itm_blue_gambeson itm_red_gambeson itm_nobleman_outfit itm_rich_outfit itm_short_tunic itm_tabard
  #Older knights with higher skills moved to top
  ["knight_1_1", "Baron Raymond de Tripoli", "Raymond de Tripoli", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,      itm_courtly_outfit_jer,      itm_knight_jer4,   itm_courtly_mail_boots, itm_mail_boots1,       itm_helm_jer,           itm_sword_medieval_a1,itm_lance_banner_jer,  itm_mail_mittens1,         itm_shield_knight_jer7],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000064a001005589394964ef5c26500000000001f291b0000000000000000],
  ["knight_1_2", "Baron Guy de Lusignan", "Guy de Lusignan", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,           itm_courtly_outfit_jer,      itm_knight_jer4,               itm_courtly_mail_boots,            itm_mail_boots1,                    itm_helm_jer,  itm_mail_mittens1,        itm_sword_medieval_a1,itm_lance_banner_jer,    itm_shield_knight_jer7],       knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000029003507269c71a7a26ea32c00000000001ee51a0000000000000000],
  ["knight_1_3", "Baron Joscelin d'Edessa", "Joscelin d'Edessa", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,          itm_courtly_outfit_jer,     itm_knight_jer4,                 itm_courtly_mail_boots,          itm_mail_boots1,        itm_helm_jer, itm_mail_mittens1, itm_sword_medieval_a1,itm_lance_banner_jer,   itm_shield_knight_jer7],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c370c1194546469ca6c4e450e00000000001ebac40000000000000000, swadian_face_older_2],
  ["knight_1_4", "Baron Aimery de Jerusalem", "Aimery de Jerusalem", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,      itm_courtly_outfit_jer,       itm_knight_jer4,           itm_courtly_mail_boots,          itm_mail_boots1,                   itm_helm_jer, itm_mail_mittens1,       itm_sword_medieval_a1,itm_lance_banner_jer,  itm_shield_knight_jer7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c0f08000458739a9a1476199800000000001fb6f10000000000000000, swadian_face_old_2],
  ["knight_1_5", "Baron Reginald de Sidon", "Reginald de Sidon", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,            itm_courtly_outfit_jer,        itm_knight_jer4,      itm_courtly_mail_boots,       itm_mail_boots1, itm_helm_jer, itm_mail_mittens1,         itm_sword_medieval_a1,itm_lance_banner_jer,    itm_shield_knight_jer7],      knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c0c1064864ba34e2ae291992b00000000001da8720000000000000000, swadian_face_older_2],
  ["knight_1_6", "Baron Walter Grenier", "Walter Grenier", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,            itm_courtly_outfit_jer,      itm_knight_jer4,               itm_courtly_mail_boots,          itm_mail_boots1,                      itm_helm_jer, itm_mail_mittens1, itm_sword_medieval_a1,itm_lance_banner_jer,  itm_shield_knight_jer7], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c0a08038736db74c6a396a8e500000000001db8eb0000000000000000, swadian_face_older_2],
  ["knight_1_7", "Baron Walter de Brisebarre", "Walter de Brisebarre", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,            itm_courtly_outfit_jer,      itm_knight_jer4,               itm_courtly_mail_boots,          itm_mail_boots1,                      itm_helm_jer, itm_mail_mittens1, itm_sword_medieval_a1,itm_lance_banner_jer, itm_shield_knight_jer7], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c1e001500589dae4094aa291c00000000001e37a80000000000000000, swadian_face_young_2],
  ["knight_1_8", "Baron Walter Durus", "Walter Durus", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,          itm_courtly_outfit_jer,     itm_knight_jer4,                 itm_courtly_mail_boots,          itm_mail_boots1,        itm_helm_jer,  itm_mail_mittens1,itm_sword_medieval_a1,itm_lance_banner_jer, itm_shield_knight_jer7],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c330855054aa9aa431a48d74600000000001ed5240000000000000000, swadian_face_older_2],

#Swadian younger knights  
  ["knight_1_9", "Baron Renaud de Chatillon", "Renaud de Chatillon", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,      itm_courtly_outfit_jer,     itm_knight_jer4,                 itm_courtly_mail_boots,              itm_mail_boots1,                      itm_helm_jer,  itm_mail_mittens1,     itm_sword_medieval_a1,itm_lance_banner_jer,   itm_shield_knight_jer7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001980c12811253e51b2faec76d00000000001dc8cb0000000000000000],
  ["knight_1_10", "Baron Balian d'Ibelin", "Balian d'Ibelin", tf_hero, 0, reserved,  fac_kingdom_1, [itm_horse_jer2,           itm_courtly_outfit_jer,        itm_knight_jer4,                   itm_courtly_mail_boots,            itm_mail_boots1,                   itm_helm_jer,    itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,        itm_shield_knight_jer7],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000003904514925752d469b4dea7d00000000001e37310000000000000000],
#  ["knight_1_11", "Baron Stamar", "Stamar", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,           itm_red_gambeson,      itm_templar_mail,               itm_leather_boots,            itm_mail_boots,                    itm_templar_helmet_2,   itm_mail_mittens,       itm_bastard_sword_b,itm_heavy_lance,    itm_tab_shield_heater_cav_b],       knight_attrib_3,wp(220),knight_skills_3, 0x0000000c03104490280a8cb2a24196ab00000000001eb4dc0000000000000000, swadian_face_older_2],
#  ["knight_1_12", "Baron Meltor", "Meltor", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_rich_outfit,        itm_templar_mail,                    itm_leather_boots,            itm_mail_boots,                      itm_templar_helmet_2,   itm_mail_mittens,         itm_bastard_sword_b,itm_heavy_lance,   itm_tab_shield_heater_cav_b],    knight_attrib_3,wp(130),knight_skills_3, 0x0000000c2a0805442b2c6cc98c8dbaac00000000001d389b0000000000000000, swadian_face_older_2],
#  ["knight_1_13", "Baron Beranz", "Beranz", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_ragged_outfit,      itm_templar_mail,           itm_leather_boots,            itm_mail_boots,                itm_templar_helmet_2,   itm_mail_mittens,         itm_bastard_sword_b,itm_heavy_lance,     itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(160),knight_skills_3, 0x0000000c380c30c2392a8e5322a5392c00000000001e5c620000000000000000, swadian_face_older_2],
#  ["knight_1_14", "Baron Rafard", "Rafard", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_short_tunic,       itm_templar_mail,           itm_leather_boots,          itm_mail_boots,                   itm_templar_helmet_2,  itm_mail_mittens,     itm_bastard_sword_b,itm_heavy_lance,    itm_tab_shield_heater_cav_b],    knight_attrib_2,wp(190),knight_skills_3|knows_trainer_6, 0x0000000c3f10000532d45203954e192200000000001e47630000000000000000, swadian_face_older_2],
#  ["knight_1_15", "Baron Regas", "Regas", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,            itm_rich_outfit,        itm_templar_mail,                   itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,   itm_mail_mittens,       itm_bastard_sword_b,itm_heavy_lance,  itm_tab_shield_heater_cav_b],      knight_attrib_4,wp(140),knight_skills_3, 0x0000000c5c0840034895654c9b660c5d00000000001e34530000000000000000, swadian_face_young_2],
#  ["knight_1_16", "Baron Devlian", "Devlian", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_courtly_outfit,      itm_templar_mail,                     itm_leather_boots,            itm_mail_boots,                itm_templar_helmet_2,   itm_mail_mittens,         itm_bastard_sword_b,itm_heavy_lance,           itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(130),knight_skills_3, 0x000000095108144657a1ba3ad456e8cb00000000001e325a0000000000000000, swadian_face_young_2],
#  ["knight_1_17", "Baron Rafarch", "Rafarch", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_gambeson,     itm_templar_mail,                 itm_leather_boots,              itm_mail_boots,                      itm_templar_helmet_2,   itm_mail_mittens,    itm_bastard_sword_b, itm_heavy_lance,  itm_tab_shield_heater_cav_b],    knight_attrib_3,wp(190),knight_skills_3|knows_trainer_4, 0x0000000c010c42c14d9d6918bdb336e200000000001dd6a30000000000000000, swadian_face_young_2],
#  ["knight_1_18", "Baron Rochabarth", "Rochabarth", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,           itm_blue_gambeson,        itm_templar_mail,                   itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,   itm_mail_mittens,     itm_bastard_sword_b,  itm_heavy_lance,      itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(210),knight_skills_3, 0x0000000c150045c6365d8565932a8d6400000000001ec6940000000000000000, swadian_face_young_2],
#  ["knight_1_19", "Baron Despin", "Despin", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_rich_outfit,        itm_templar_mail,                    itm_leather_boots,            itm_mail_boots,                      itm_templar_helmet_2, itm_mail_mittens,           itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_a],    knight_attrib_3,wp(120),knight_skills_3, 0x00000008200012033d9b6d4a92ada53500000000001cc1180000000000000000, swadian_face_young_2],
#  ["knight_1_20", "Baron Montewar", "Montewar", tf_hero, 0, reserved,  fac_kingdom_1, [itm_templar_charger,      itm_ragged_outfit,      itm_templar_mail,           itm_leather_boots,            itm_mail_boots,                itm_templar_helmet_2, itm_mail_mittens,           itm_bastard_sword_b,itm_heavy_lance,   itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(150),knight_skills_3, 0x0000000c4d0840d24a9b2ab4ac2a332400000000001d34db0000000000000000, swadian_face_young_2],



  
#  ["knight_1_21", "Lord Swadian 21", "knight_1_7", tf_hero, 0, reserved,  fac_kingdom_1, [itm_saddle_horse,      itm_ragged_outfit,      itm_heraldic_mail_with_surcoat,           itm_nomad_boots,            itm_splinted_greaves,                itm_great_helmet, itm_gauntlets,           itm_sword_medieval_c,   itm_sword_two_handed_a,   itm_tab_shield_heater_cav_a],   knight_attrib_2,wp(150),knight_skills_2, 0x0000000c4d0840d24a9b2ab4ac2a332400000000001d34db0000000000000000, swadian_face_young_2],
 # ["knight_1_22", "Lord Swadian 22", "knight_1_8", tf_hero, 0, reserved,  fac_kingdom_1, [itm_saddle_horse,      itm_short_tunic,       itm_heraldic_mail_with_surcoat,           itm_leather_boots,          itm_mail_chausses,                   itm_winged_great_helmet, itm_gauntlets,       itm_bastard_sword_a,  itm_sword_two_handed_a,  itm_tab_shield_heater_d],    knight_attrib_3,wp(180),knight_skills_3|knows_trainer_4, 0x0000000c370c1194546469ca6c4e450e00000000001ebac40000000000000000, swadian_face_older_2],
#  ["knight_1_23", "Lord Swadian 23", "knight_1_9", tf_hero, 0, reserved,  fac_kingdom_1, [itm_hunter,            itm_rich_outfit,        itm_mail_hauberk,                   itm_woolen_hose,            itm_mail_chausses,                   itm_guard_helmet, itm_gauntlets,         itm_sword_medieval_c,    itm_tab_shield_heater_d],      knight_attrib_4,wp(200),knight_skills_4|knows_trainer_6, 0x0000000c0c1064864ba34e2ae291992b00000000001da8720000000000000000, swadian_face_older_2],
#  ["knight_1_24", "Lord Swadian 24", "knight_1_0", tf_hero, 0, reserved,  fac_kingdom_1, [itm_hunter,            itm_tabard,      itm_heraldic_mail_with_surcoat,               itm_leather_boots,          itm_mail_boots,                      itm_winged_great_helmet, itm_gauntlets, itm_bastard_sword_b, itm_sword_two_handed_b,  itm_tab_shield_heater_cav_b], knight_attrib_5,wp(240),knight_skills_5|knows_trainer_5, 0x0000000c0a08038736db74c6a396a8e500000000001db8eb0000000000000000, swadian_face_older_2],

  
  
  ["knight_2_1", "Baron Ralph des Monts", "Ralph des Monts", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,     itm_knight_ant8,                   itm_courtly_mail_boots,            itm_mail_boots1,        itm_helm_red,    itm_mail_mittens1,       itm_sword_medieval_a2, itm_lance_banner_ant,          itm_shield_knight_ant7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000005590011c33d9b6d4a92ada53500000000001cc1180000000000000000, vaegir_face_middle_2],
  ["knight_2_2", "Baron William de Cava", "William de Cava", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,        itm_knight_ant8,               itm_courtly_mail_boots,            itm_mail_boots1,                   itm_helm_red,  itm_mail_mittens1,      itm_sword_medieval_a2,itm_lance_banner_ant,    itm_shield_knight_ant7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c2a0015d249b68b46a98e176400000000001d95a40000000000000000, vaegir_face_old_2],
  ["knight_2_3", "Baron Hugh Flauncurt", "Hugh Flauncurt", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,            itm_courtly_outfit_ant,        itm_knight_ant8,                   itm_courtly_mail_boots,            itm_mail_boots1,                   itm_helm_red, itm_mail_mittens1,           itm_sword_medieval_a2, itm_lance_banner_ant,          itm_shield_knight_ant7],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c131031c546a38a2765b4c86000000000001e58d30000000000000000, vaegir_face_older_2],
  ["knight_2_4", "Baron Gervais de Sarmenia", "Gervais de Sarmenia", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,     itm_knight_ant8,               itm_courtly_mail_boots,          itm_mail_boots1,                      itm_helm_red, itm_mail_mittens1,         itm_sword_medieval_a2,itm_lance_banner_ant,   itm_shield_knight_ant7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c2f0832c748f272540d8ab65900000000001d34e60000000000000000, vaegir_face_older_2],
  ["knight_2_5", "Baron Simon Burgevin", "Simon Burgevin", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,            itm_courtly_outfit_ant,        itm_knight_ant8,                     itm_courtly_mail_boots,          itm_mail_boots1,                   itm_helm_red, itm_mail_mittens1,   itm_sword_medieval_a2, itm_lance_banner_ant,  itm_shield_knight_ant7],       knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000e310061435d76bb5f55bad9ad00000000001ed8ec0000000000000000, vaegir_face_older_2],
  ["knight_2_6", "Baron William de Moci", "William de Moci", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,      itm_knight_ant8,                   itm_courtly_mail_boots,            itm_mail_boots1,                   itm_helm_red,  itm_mail_mittens1,          itm_sword_medieval_a2, itm_lance_banner_ant,          itm_shield_knight_ant7],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000a0100421038da7157aa4e430a00000000001da8bc0000000000000000, vaegir_face_middle_2],
  ["knight_2_7", "Baron Guarin Malmuz", "Guarin Malmuz", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,     itm_knight_ant8,                   itm_courtly_mail_boots,          itm_mail_boots1,                      itm_helm_red,  itm_mail_mittens1,          itm_sword_medieval_a2, itm_lance_banner_ant,   itm_shield_knight_ant7],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c04100153335ba9390b2d277500000000001d89120000000000000000, vaegir_face_old_2],
  ["knight_2_8", "Baron Peter Salvarici", "Peter Salvarici", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,            itm_courtly_outfit_ant,             itm_knight_ant8,                     itm_courtly_mail_boots,            itm_mail_boots1,                   itm_helm_red, itm_mail_mittens1,       itm_sword_medieval_a2,itm_lance_banner_ant,    itm_shield_knight_ant7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c00046581234e8da2cdd248db00000000001f569c0000000000000000, vaegir_face_older_2],
  ["knight_2_9", "Baron Martin de Margat", "Martin de Margat", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,      itm_courtly_outfit_ant,        itm_knight_ant8,                     itm_courtly_mail_boots,          itm_mail_boots1,                   itm_helm_red,  itm_mail_mittens1,        itm_sword_medieval_a2, itm_lance_banner_ant,  itm_shield_knight_ant7],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c160451d2136469c4d9b159ad00000000001e28f10000000000000000, vaegir_face_older_2],
  ["knight_2_10", "Baron Bartholomew Tirel", "Bartholomew Tirel", tf_hero, 0, reserved,  fac_kingdom_2, [itm_horse_ant2,          itm_courtly_outfit_ant,        itm_knight_ant8,               itm_courtly_mail_boots,            itm_mail_boots1,                      itm_helm_red,  itm_mail_mittens1,      itm_sword_medieval_a2,itm_lance_banner_ant,   itm_shield_knight_ant7],      knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000f7c00520e66b76edd5cd5eb6e00000000001f691e0000000000000000, vaegir_face_older_2],
#  ["knight_2_11", "Baron Crahask", "Crahask", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_leather_jacket,     itm_hospitaller_mail,                   itm_nomad_boots,            itm_mail_boots,        itm_templar_helmet_2, itm_mail_mittens,           itm_bastard_sword_b, itm_heavy_lance,          itm_tab_shield_heater_cav_b],    knight_attrib_3,wp(130),knight_skills_3, 0x0000000c1d0821d236acd6991b74d69d00000000001e476c0000000000000000, vaegir_face_middle_2],
#  ["knight_2_12", "Baron Bracha", "Bracha", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_rich_outfit,        itm_hospitaller_mail,               itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,  itm_mail_mittens,      itm_bastard_sword_b,itm_heavy_lance,    itm_tab_shield_heater_cav_b],    knight_attrib_3,wp(170),knight_skills_3, 0x0000000c0f04024b2509d5d53944c6a300000000001d5b320000000000000000, vaegir_face_old_2],
#  ["knight_2_13", "Baron Druli", "Druli", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,            itm_short_tunic,        itm_hospitaller_mail,                   itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,  itm_mail_mittens,          itm_bastard_sword_b, itm_heavy_lance,          itm_tab_shield_heater_cav_b],     knight_attrib_3,wp(190),knight_skills_3, 0x0000000c680432d3392230cb926d56ca00000000001da69b0000000000000000, vaegir_face_older_2],
#  ["knight_2_14", "Baron Marmun", "Marmun", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_courtly_outfit,     itm_hospitaller_mail,               itm_leather_boots,          itm_mail_boots,                      itm_templar_helmet_2,  itm_mail_mittens,        itm_bastard_sword_b,itm_heavy_lance,   itm_tab_shield_heater_cav_b],    knight_attrib_4,wp(220),knight_skills_4|knows_trainer_6, 0x0000000c27046000471bd2e93375b52c00000000001dd5220000000000000000, vaegir_face_older_2],
#  ["knight_2_15", "Baron Gastya", "Gastya", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,            itm_rich_outfit,        itm_hospitaller_mail,                     itm_leather_boots,          itm_mail_boots,                   itm_templar_helmet_2, itm_mail_mittens,   itm_bastard_sword_b, itm_heavy_lance, itm_shortened_military_scythe, itm_tab_shield_heater_cav_b],       knight_attrib_5,wp(250),knight_skills_5, 0x0000000de50052123b6bb36de5d6eb7400000000001dd72c0000000000000000, vaegir_face_older_2],
#  ["knight_2_16", "Baron Harish", "Harish", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_rich_outfit,      itm_hospitaller_mail,                   itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,  itm_mail_mittens,          itm_bastard_sword_b,itm_heavy_lance,           itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(120),knight_skills_3, 0x000000085f00000539233512e287391d00000000001db7200000000000000000, vaegir_face_middle_2],
#  ["knight_2_17", "Baron Taisa", "Taisa", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_leather_jacket,     itm_hospitaller_mail,                   itm_leather_boots,          itm_mail_boots,                      itm_templar_helmet_2,   itm_mail_mittens,         itm_bastard_sword_b, itm_heavy_lance,   itm_tab_shield_heater_cav_b],     knight_attrib_3,wp(150),knight_skills_3, 0x0000000a070c4387374bd19addd2a4ab00000000001e32cc0000000000000000, vaegir_face_old_2],
#  ["knight_2_18", "Baron Valishin", "Valishin", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,            itm_rich_outfit,             itm_hospitaller_mail,                     itm_leather_boots,            itm_mail_boots,                   itm_templar_helmet_2,  itm_mail_mittens,      itm_bastard_sword_b,itm_heavy_lance,    itm_tab_shield_heater_cav_b],    knight_attrib_3,wp(180),knight_skills_3, 0x0000000b670012c23d9b6d4a92ada53500000000001cc1180000000000000000, vaegir_face_older_2],
#  ["knight_2_19", "Baron Rudin", "Rudin", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,      itm_rich_outfit,        itm_hospitaller_mail,                     itm_leather_boots,          itm_mail_boots,                   itm_templar_helmet_2, itm_mail_mittens,         itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],    knight_attrib_4,wp(210),knight_skills_4|knows_trainer_4, 0x0000000e070050853b0a6e4994ae272a00000000001db4e10000000000000000, vaegir_face_older_2],
#  ["knight_2_20", "Baron Kumipa", "Kumipa", tf_hero, 0, reserved,  fac_kingdom_2, [itm_hospitaller_charger,          itm_short_tunic,        itm_hospitaller_mail,               itm_leather_boots,            itm_mail_boots,                      itm_templar_helmet_2,  itm_mail_mittens,      itm_bastard_sword_b,itm_heavy_lance,   itm_tab_shield_heater_cav_b],      knight_attrib_5,wp(240),knight_skills_5|knows_trainer_5, 0x0000000f800021c63b0a6e4994ae272a00000000001db4e10000000000000000, vaegir_face_older_2],

#khergit civilian clothes: itm_nomad_vest, itm_nomad_robe, itm_lamellar_vest,itm_tribal_warrior_outfit
  ["knight_3_1", "Emir Selim al-Rashid", "Selim al-Rashid", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3,itm_courtly_seljuk_boots,  itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1,  itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000043000318b54b246b7094dc39c00000000001d31270000000000000000, khergit_face_middle_2],
  ["knight_3_2", "Emir Salih al-Alai",  "Salih al-Alai", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,   itm_mamluk_sel3, itm_courtly_seljuk_boots,  itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c280461004929b334ad632aa200000000001e05120000000000000000, khergit_face_old_2],
  ["knight_3_3", "Emir Mehmed Shah",  "Mehmed Shah", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel, itm_mamluk_sel3,itm_courtly_seljuk_boots,  itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000e880062c53b0a6e4994ae272a00000000001db4e10000000000000000, khergit_face_older_2],
  ["knight_3_4", "Emir Orhan Arikan", "Orhan Arikan", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3, itm_courtly_seljuk_boots,  itm_boots_cav_sel1,   itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3, itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c23085386391b5ac72a96d95c00000000001e37230000000000000000, khergit_face_older_2],
  ["knight_3_5", "Emir Mehmed al-Alai",  "Mehmed al-Alai", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3, itm_courtly_seljuk_boots,  itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3, itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000efe0051ca4b377b4964b6eb6500000000001f696c0000000000000000, khergit_face_older_2],
  ["knight_3_6", "Emir Uthman al-Su'ud", "Uthman al-Su'ud", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3,itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3,  itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000006f600418b54b246b7094dc31a00000000001d37270000000000000000, khergit_face_middle_2],
  ["knight_3_7", "Emir Abaaq al-Khwarazmi","Abaaq al-Khwarazmi", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel,  itm_mamluk_sel3,itm_courtly_seljuk_boots, itm_boots_cav_sel1, itm_skullcap, itm_helm_sel3, itm_gauntlets_sar1,  itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000bdd00510a44be2d14d370c65c00000000001ed6df0000000000000000, khergit_face_old_2],
  ["knight_3_8", "Emir Muhi ad-Din", "Muhi ad-Din", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1,   itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000abc00518b5af4ab4b9c8e596400000000001dc76d0000000000000000, khergit_face_older_2],
  ["knight_3_9", "Emir Zahir ad-Din","Zahir ad-Din", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel, itm_mamluk_sel3,  itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1,  itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000a180441c921a30ea68b54971500000000001e54db0000000000000000, khergit_face_older_2],
  ["knight_3_10", "Emir Taj al-Muluk","Taj al-Muluk", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1,  itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000a3b00418c5b36c686d920a76100000000001c436f0000000000000000, khergit_face_older_2],
  ["knight_3_11", "Emir Shams al-Mulk", "Shams al-Mulk", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3,  itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000007d100534b44962d14d370c65c00000000001ed6df0000000000000000, khergit_face_middle_2],
  ["knight_3_12", "Emir Shihab ad-Din", "Shihab ad-Din", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3,  itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000bf400610c5b33d3c9258edb6c00000000001eb96d0000000000000000, khergit_face_old_2],
  ["knight_3_13", "Emir Jamal ad-Din","Jamal ad-Din", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000bfd0061c65b6eb33b25d2591d00000000001f58eb0000000000000000, khergit_face_older_2],
  ["knight_3_14", "Emir Mujir ad-Din",  "Mujir ad-Din", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel,  itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar,  itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000b6900514144be2d14d370c65c00000000001ed6df0000000000000000, khergit_face_older_2],
  ["knight_3_15", "Emir Sa'id Taj", "Sa'id Taj", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,   itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1,  itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c360c524b6454465b59b9d93500000000001ea4860000000000000000, khergit_face_older_2],
  ["knight_3_16", "Emir Janbirdi al-Ghazali","Janbirdi al-Ghazali", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel,  itm_mamluk_sel3,  itm_courtly_seljuk_boots,  itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1,   itm_scimitar3,  itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c350c418438ab85b75c61b8d300000000001d21530000000000000000, khergit_face_middle_2],
  ["knight_3_17", "Emir Mohammad Kuzal", "Mohammad Kuzal", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,  itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1,   itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c3c0821c647264ab6e68dc4d500000000001e42590000000000000000, khergit_face_old_2],
  ["knight_3_18", "Emir Inal al-Su'ud", "Inal al-Su'ud", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,   itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1,   itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c0810500347ae7acd0d3ad74a00000000001e289a0000000000000000, khergit_face_older_2],
  ["knight_3_19", "Emir Topal Sulayman","Topal Sulayman", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1,   itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1,  itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3, itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c1500510528f50d52d20b152300000000001d66db0000000000000000, khergit_face_older_2],
  ["knight_3_20", "Emir Hadim Sinan","Hadim Sinan", tf_hero, 0, reserved,  fac_kingdom_3, [itm_arabian_cav1, itm_courtly_outfit_sel, itm_mamluk_sel3, itm_courtly_seljuk_boots, itm_boots_cav_sel1, itm_helm_sel3, itm_gauntlets_sar1, itm_scimitar3,itm_lance_banner_sar, itm_shield_ayycav5],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000f7800620d66b76edd5cd5eb6e00000000001f691e0000000000000000, khergit_face_older_2],

  ["knight_4_1", "Master Robert de Sable", "Robert de Sable", tf_hero, 0, reserved,  fac_kingdom_4, [itm_horse_tem2,   itm_courtly_outfit_tem,  itm_knight_tem3,   itm_courtly_mail_boots,  itm_mail_boots1,  itm_helm_tem, itm_mail_mittens1, itm_sword_medieval_tem,itm_lance_banner_tem, itm_shield_knight_tem3], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c13002254340eb1d91159392d00000000001eb75a0000000000000000, nord_face_middle_2],
  ["knight_4_2", "Master Aimon de Ais", "Aimon de Ais", tf_hero, 0, reserved,  fac_kingdom_4, [itm_horse_tem2,   itm_courtly_outfit_tem,  itm_knight_tem3,   itm_courtly_mail_boots,  itm_mail_boots1,  itm_helm_tem, itm_mail_mittens1, itm_sword_medieval_tem,itm_lance_banner_tem, itm_shield_knight_tem3],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c1610218368e29744e9a5985b00000000001db2a10000000000000000, nord_face_old_2],
#  ["knight_4_3", "Master Olaf", "Olaf", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_rich_outfit,  itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots, itm_mail_mittens,   itm_winged_great_helmet,   itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_3,wp(190),knight_skills_3, 0x0000000c03040289245a314b744b30a400000000001eb2a90000000000000000, nord_face_older_2],
#  ["knight_4_4", "Master Reamald", "Reamald", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,   itm_rich_outfit,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots, itm_mail_mittens,  itm_winged_great_helmet, itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_4,wp(210),knight_skills_4, 0x0000000c3f1001ca3d6955b26a8939a300000000001e39b60000000000000000, nord_face_older_2],
#  ["knight_4_5", "Master Turya", "Turya", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,  itm_courtly_outfit,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,  itm_mail_mittens, itm_winged_great_helmet, itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b], knight_attrib_5,wp(250),knight_skills_5, 0x0000000ff508330546dc4a59422d450c00000000001e51340000000000000000, nord_face_older_2],
#  ["knight_4_6", "Master Gundur", "Gundur", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,   itm_short_tunic,   itm_teutonic_mail_a,  itm_leather_boots,  itm_mail_boots,   itm_winged_great_helmet, itm_mail_mittens,   itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(130),knight_skills_3, 0x00000005b00011813d9b6d4a92ada53500000000001cc1180000000000000000, nord_face_middle_2],
#  ["knight_4_7", "Master Harald", "Harald", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,  itm_courtly_outfit,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet, itm_mail_mittens,   itm_bastard_sword_b,itm_heavy_lance,  itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(160),knight_skills_3|knows_trainer_4, 0x00000006690002873d9b6d4a92ada53500000000001cc1180000000000000000, nord_face_old_2],
#  ["knight_4_8", "Master Knudarr", "Knudarr", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_rich_outfit,  itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,   itm_winged_great_helmet, itm_mail_mittens, itm_bastard_sword_b,itm_heavy_lance,  itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(190),knight_skills_3, 0x0000000f830051c53b026e4994ae272a00000000001db4e10000000000000000, nord_face_older_2],
#  ["knight_4_9", "Master Haeda", "Haeda", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_short_tunic,   itm_teutonic_mail_a, itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet, itm_mail_mittens, itm_arrows, itm_bastard_sword_b, itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_4,wp(220),knight_skills_4|knows_trainer_5|knows_power_draw_4, 0x00000000080c54c1345bd21349b1b67300000000001c90c80000000000000000, nord_face_older_2],
  ["knight_4_10", "Master Arn de Gothia", "Arn de Gothia", tf_hero, 0, reserved,  fac_kingdom_4, [itm_horse_tem2,   itm_courtly_outfit_tem,  itm_knight_tem3,   itm_courtly_mail_boots,  itm_mail_boots1,  itm_helm_tem, itm_mail_mittens1, itm_sword_medieval_tem,itm_lance_banner_tem, itm_shield_knight_tem3],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000000041144395c4d27d576234b00000000001c370a0000000000000000],
#  ["knight_4_11", "Master Logarson", "Logarson", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_rich_outfit,  itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet,  itm_mail_mittens,  itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b], knight_attrib_3,wp(140),knight_skills_3, 0x000000002d100005471d4ae69ccacb1d00000000001dca550000000000000000, nord_face_middle_2],
#  ["knight_4_12", "Master Aeric", "Aeric", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_short_tunic,  itm_teutonic_mail_a, itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet,  itm_mail_mittens,  itm_bastard_sword_b, itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_3,wp(200),knight_skills_3, 0x0000000b9500020824936cc51cb5bb2500000000001dd4d80000000000000000, nord_face_old_2],
#  ["knight_4_13", "Master Faarn", "Faarn", tf_hero, 0, reserved,  fac_kingdom_4, [itm_warhorse, itm_rich_outfit,  itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots, itm_mail_mittens,   itm_winged_great_helmet,   itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_3,wp(250),knight_skills_3|knows_trainer_3, 0x0000000a300012c439233512e287391d00000000001db7200000000000000000, nord_face_older_2],
#  ["knight_4_14", "Master Bulba", "Bulba", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,  itm_rich_outfit,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet, itm_mail_mittens, itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_4,wp(200),knight_skills_4, 0x0000000c0700414f2cb6aa36ea50a69d00000000001dc55c0000000000000000, nord_face_older_2],
#  ["knight_4_15", "Master Rayeck", "Rayeck", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,   itm_courtly_outfit,   itm_teutonic_mail_a,   itm_leather_boots, itm_mail_mittens,  itm_mail_boots,  itm_winged_great_helmet, itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b], knight_attrib_5,wp(290),knight_skills_5|knows_trainer_6, 0x0000000d920801831715d1aa9221372300000000001ec6630000000000000000, nord_face_older_2],
#  ["knight_4_16", "Master Dirigun", "Dirigun", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,   itm_short_tunic,   itm_teutonic_mail_a,  itm_leather_boots,  itm_mail_boots,   itm_winged_great_helmet, itm_mail_mittens,   itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(120),knight_skills_3, 0x000000099700124239233512e287391d00000000001db7200000000000000000, nord_face_middle_2],
#  ["knight_4_17", "Master Marayirr", "Marayirr", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,  itm_fur_coat,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet, itm_mail_mittens,   itm_bastard_sword_b,itm_heavy_lance,  itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(150),knight_skills_3|knows_trainer_4, 0x0000000c2f0442036d232a2324b5b81400000000001e55630000000000000000, nord_face_old_2],
#  ["knight_4_18", "Master Gearth", "Gearth", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_rich_outfit,  itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots,   itm_winged_great_helmet, itm_mail_mittens, itm_bastard_sword_b,itm_heavy_lance,  itm_tab_shield_heater_cav_b],   knight_attrib_3,wp(180),knight_skills_3, 0x0000000c0d00118866e22e3d9735a72600000000001eacad0000000000000000, nord_face_older_2],
#  ["knight_4_19", "Master Surdun", "Surdun", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b, itm_short_tunic,   itm_teutonic_mail_a, itm_leather_boots,  itm_mail_boots,  itm_winged_great_helmet, itm_mail_mittens,   itm_bastard_sword_b, itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_4,wp(210),knight_skills_4|knows_trainer_5, 0x0000000c0308225124e26d4a6295965a00000000001d23e40000000000000000, nord_face_older_2],
#  ["knight_4_20", "Master Gerlad", "Gerlad", tf_hero, 0, reserved,  fac_kingdom_4, [itm_teu_war_horse_b,   itm_courtly_outfit,   itm_teutonic_mail_a,   itm_leather_boots,  itm_mail_boots, itm_mail_mittens,  itm_winged_great_helmet,itm_bastard_sword_b,itm_heavy_lance, itm_tab_shield_heater_cav_b],  knight_attrib_5,wp(240),knight_skills_5, 0x0000000f630052813b6bb36de5d6eb7400000000001dd72c0000000000000000, nord_face_older_2],

  ["knight_5_1", "Master Armengol de Aspa", "Armengol de Aspa", tf_hero, 0, reserved,  fac_kingdom_5, [itm_horse_hos1,   itm_courtly_outfit_hos,   itm_knight_hos4,       itm_courtly_mail_boots,    itm_mail_boots1,    itm_helm_hos, itm_mail_mittens1,     itm_sword_medieval_hos, itm_lance_banner_hos,  itm_shield_knight_hos4],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000a1b0c00483adcbaa5ac9a34a200000000001ca2d40000000000000000, rhodok_face_middle_2],
  ["knight_5_2", "Master Garnier de Nablus", "Garnier de Nablus", tf_hero, 0, reserved,  fac_kingdom_5, [itm_horse_hos1,   itm_courtly_outfit_hos,   itm_knight_hos4,       itm_courtly_mail_boots,    itm_mail_boots1,    itm_helm_hos, itm_mail_mittens1,     itm_sword_medieval_hos, itm_lance_banner_hos,  itm_shield_knight_hos4],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000c390c659229136db45a75251300000000001f16930000000000000000, rhodok_face_old_2],
#  ["knight_5_3", "Master Laruqen", "Laruqen", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_short_tunic,  itm_rus_scale_a,     itm_leather_boots,      itm_mail_chausses,  itm_munitionshelm2, itm_scale_gauntlets, itm_sword_viking_3,itm_heavy_lance,  itm_celtic_shield_small_round_f],    knight_attrib_3,wp(190),knight_skills_3, 0x0000000c2f10415108b1aacba27558d300000000001d329c0000000000000000, rhodok_face_older_2],
#  ["knight_5_4", "Master Raichs", "Raichs", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_leather_jacket,     itm_rus_scale_a,       itm_leather_boots,      itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets, itm_sword_viking_3, itm_heavy_lance,   itm_celtic_shield_small_round_f],    knight_attrib_4,wp(220),knight_skills_4, 0x0000000c3c005110345c59d56975ba1200000000001e24e40000000000000000, rhodok_face_older_2],
#  ["knight_5_5", "Master Reland", "Reland", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_rich_outfit,  itm_rus_scale_a,     itm_leather_boots,    itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets, itm_sword_viking_3,itm_heavy_lance,  itm_celtic_shield_small_round_f], knight_attrib_5,wp(250),knight_skills_5, 0x0000000c060400c454826e471092299a00000000001d952d0000000000000000, rhodok_face_older_2],
#  ["knight_5_6", "Master Tarchias", "Tarchias", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,    itm_ragged_outfit,      itm_rus_scale_a,       itm_leather_boots,      itm_mail_chausses, itm_scale_gauntlets,   itm_munitionshelm2,     itm_sword_viking_3,itm_heavy_lance,   itm_celtic_shield_small_round_f],    knight_attrib_3,wp(130),knight_skills_3, 0x000000001100000648d24d36cd964b1d00000000001e2dac0000000000000000, rhodok_face_middle_2],
#  ["knight_5_7", "Master Gharmall", "Gharmall", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_coarse_tunic,       itm_rus_scale_a,   itm_leather_boots,    itm_mail_chausses,  itm_scale_gauntlets,      itm_munitionshelm2,       itm_sword_viking_3,itm_heavy_lance,    itm_celtic_shield_small_round_f],     knight_attrib_3,wp(160),knight_skills_3, 0x0000000c3a0455c443d46e4c8b91291a00000000001ca51b0000000000000000, rhodok_face_old_2],
#  ["knight_5_8", "Master Talbar", "Talbar", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12, itm_courtly_outfit,     itm_rus_scale_a,    itm_leather_boots,      itm_mail_chausses,    itm_munitionshelm2,  itm_scale_gauntlets,      itm_sword_viking_3,itm_heavy_lance,  itm_celtic_shield_small_round_f],    knight_attrib_3,wp(190),knight_skills_3|knows_trainer_3, 0x0000000c2c0844d42914d19b2369b4ea00000000001e331b0000000000000000, rhodok_face_older_2],
#  ["knight_5_9", "Master Rimusk", "Rimusk", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_leather_jacket,     itm_rus_scale_a,   itm_leather_boots,    itm_mail_chausses,       itm_munitionshelm2, itm_scale_gauntlets,   itm_sword_viking_3, itm_heavy_lance,  itm_celtic_shield_small_round_f],   knight_attrib_4,wp(220),knight_skills_4|knows_trainer_6, 0x00000000420430c32331b5551c4724a100000000001e39a40000000000000000, rhodok_face_older_2],
  ["knight_5_10", "Master Geoffroy de Donjon", "Geoffroy de Donjon", tf_hero, 0, reserved,  fac_kingdom_5, [itm_horse_hos1,   itm_courtly_outfit_hos,   itm_knight_hos4,       itm_courtly_mail_boots,    itm_mail_boots1,    itm_helm_hos, itm_mail_mittens1,     itm_sword_medieval_hos, itm_lance_banner_hos,  itm_shield_knight_hos4],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000008e20011063d9b6d4a92ada53500000000001cc1180000000000000000, rhodok_face_older_2],
#  ["knight_5_11", "Master Etrosq", "Etrosq", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_tabard,       itm_rus_scale_a,       itm_leather_boots,    itm_mail_chausses,    itm_munitionshelm2,  itm_scale_gauntlets,    itm_sword_viking_3,itm_heavy_lance,   itm_celtic_shield_small_round_f],     knight_attrib_3,wp(130),knight_skills_3, 0x0000000c170c14874752adb6eb3228d500000000001c955c0000000000000000, rhodok_face_middle_2],
#  ["knight_5_12", "Master Kurnias", "Kurnias", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,    itm_red_gambeson,       itm_rus_scale_a,    itm_leather_boots,    itm_mail_chausses,    itm_munitionshelm2,  itm_scale_gauntlets,      itm_sword_viking_3,itm_heavy_lance,   itm_celtic_shield_small_round_f],     knight_attrib_3,wp(160),knight_skills_3|knows_trainer_5, 0x0000000c080c13d056ec8da85e3126ed00000000001d4ce60000000000000000, rhodok_face_old_2],
#  ["knight_5_13", "Master Tellrog", "Tellrog", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_short_tunic,  itm_rus_scale_a,     itm_leather_boots,      itm_mail_chausses,  itm_munitionshelm2, itm_scale_gauntlets,       itm_sword_viking_3, itm_heavy_lance, itm_celtic_shield_small_round_f],    knight_attrib_3,wp(190),knight_skills_3, 0x0000000cbf10100562a4954ae731588a00000000001d6b530000000000000000, rhodok_face_older_2],
#  ["knight_5_14", "Master Tribidan", "Tribidan", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_leather_jacket,     itm_rus_scale_a,       itm_leather_boots,      itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets, itm_sword_viking_3,itm_heavy_lance,    itm_celtic_shield_small_round_f],    knight_attrib_4,wp(220),knight_skills_4, 0x0000000c330805823baa77556c4e331a00000000001cb9110000000000000000, rhodok_face_older_2],
#  ["knight_5_15", "Master Gerluchs", "Gerluchs", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_rich_outfit,  itm_rus_scale_a,     itm_leather_boots,    itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets,       itm_sword_viking_3,itm_heavy_lance,  itm_celtic_shield_small_round_f], knight_attrib_5,wp(250),knight_skills_5, 0x0000000d51000106370c4d4732b536de00000000001db9280000000000000000, rhodok_face_older_2],
#  ["knight_5_16", "Master Fudreim", "Fudreim", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,    itm_courtly_outfit,      itm_rus_scale_a,       itm_leather_boots,      itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets,     itm_sword_viking_3, itm_heavy_lance,  itm_celtic_shield_small_round_f],    knight_attrib_3,wp(120),knight_skills_3, 0x0000000c06046151435b5122a37756a400000000001c46e50000000000000000, rhodok_face_middle_2],
#  ["knight_5_17", "Master Nealcha", "Nealcha", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_coarse_tunic,       itm_rus_scale_a,   itm_leather_boots,    itm_mail_chausses,       itm_munitionshelm2,  itm_scale_gauntlets,      itm_sword_viking_3,itm_heavy_lance,    itm_celtic_shield_small_round_f],     knight_attrib_3,wp(150),knight_skills_3, 0x0000000c081001d3465c89a6a452356300000000001cda550000000000000000, rhodok_face_old_2],
#  ["knight_5_18", "Master Fraichin", "Fraichin", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12, itm_courtly_outfit,     itm_rus_scale_a,    itm_leather_boots,      itm_mail_chausses,    itm_munitionshelm2, itm_scale_gauntlets,       itm_sword_viking_3, itm_heavy_lance,  itm_celtic_shield_small_round_f],    knight_attrib_3,wp(180),knight_skills_3, 0x0000000a3d0c13c3452aa967276dc95c00000000001dad350000000000000000, rhodok_face_older_2],
#  ["knight_5_19", "Master Trimbau", "Trimbau", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_leather_jacket,     itm_rus_scale_a,   itm_leather_boots,    itm_mail_chausses,       itm_munitionshelm2, itm_scale_gauntlets,   itm_sword_viking_3, itm_heavy_lance, itm_celtic_shield_small_round_f],   knight_attrib_4,wp(210),knight_skills_4|knows_trainer_5, 0x0000000038043194092ab4b2d9adb44c00000000001e072c0000000000000000, rhodok_face_older_2],
#  ["knight_5_20", "Master Reichsin", "Reichsin", tf_hero, 0, reserved,  fac_kingdom_5, [itm_rnd_horse_12,     itm_rich_outfit,  itm_rus_scale_a,     itm_leather_boots,  itm_mail_chausses,       itm_munitionshelm2, itm_scale_gauntlets,       itm_sword_viking_3, itm_heavy_lance,  itm_celtic_shield_small_round_f],  knight_attrib_5,wp(240),knight_skills_5|knows_trainer_6, 0x000000003600420515a865b45c64d64c00000000001d544b0000000000000000, rhodok_face_older_2],

  ["knight_6_1", "Emir Al Adil", "Al Adil", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy, itm_mamluk_ayy2,  itm_courtly_saracen_boots,    itm_boots_cav_ayy2,    itm_helm_ayy5, itm_gauntlets_sar2,    itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000000600c2084486195383349eae500000000001d16a30000000000000000, khergit_face_middle_2],
  ["knight_6_2", "Emir Al Muzaffar Umar", "Al Muzaffar Umar", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,  itm_mamluk_ayy2,  itm_courtly_saracen_boots, itm_boots_cav_ayy2,    itm_helm_ayy5, itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,  itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001380825d444cb68b92b8d3b1d00000000001dd71e0000000000000000, khergit_face_old_2],
  ["knight_6_3", "Emir Turan Shah", "Turan Shah", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2, itm_courtly_saracen_boots,   itm_boots_cav_ayy2,      itm_helm_ayy5,  itm_scimitar2,itm_lance_banner_sar, itm_gauntlets_sar2,  itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000002208428579723147247ad4e500000000001f14d40000000000000000, khergit_face_older_2],
  ["knight_6_4", "Emir Muhammad ibn Shirkuh", "Muhammad ibn Shirkuh", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,    itm_courtly_saracen_boots,    itm_boots_cav_ayy2,          itm_helm_ayy5,   itm_gauntlets_sar2, itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000009bf084285050caa7d285be51a00000000001d11010000000000000000, khergit_face_older_2],
  ["knight_6_5", "Emir Sayf al-Islam", "Sayf al-Islam", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,  itm_courtly_saracen_boots,   itm_boots_cav_ayy2,    itm_helm_ayy5,    itm_gauntlets_sar2, itm_scimitar2,itm_lance_banner_sar,  itm_shield_ayycav2], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000002a084003330175aae175da9c00000000001e02150000000000000000, khergit_face_older_2],
  ["knight_6_6", "Emir Mu'izz al-Din", "Mu'izz al-Din", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,  itm_mamluk_ayy2,    itm_courtly_saracen_boots,    itm_boots_cav_ayy2,     itm_helm_ayy5, itm_gauntlets_sar2,    itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001830043834733294c89b128e200000000001259510000000000000000, rhodok_face_middle_2],
  ["knight_6_7", "Emir Az Zahir Ghazi", "Az Zahir Ghazi", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,     itm_courtly_saracen_boots,    itm_boots_cav_ayy2,          itm_helm_ayy5,  itm_gauntlets_sar2,     itm_scimitar2,itm_lance_banner_sar,  itm_mail_mittens,  itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000cbf10434020504bbbda9135d500000000001f62380000000000000000, khergit_face_old_2],
  ["knight_6_8", "Emir Farrukh Shah", "Farrukh Shah", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,   itm_mamluk_ayy2,    itm_courtly_saracen_boots,   itm_boots_cav_ayy2,      itm_helm_ayy5,    itm_gauntlets_sar2,    itm_scimitar2, itm_lance_banner_sar,  itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000190044003336dcd3ca2cacae300000000001f47640000000000000000, khergit_face_older_2],
  ["knight_6_9", "Emir Al Awhad Ayyub", "Al Awhad Ayyub", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,   itm_mamluk_ayy2,  itm_courtly_saracen_boots,   itm_boots_cav_ayy2,    itm_helm_ayy5, itm_gauntlets_sar2,  itm_scimitar2, itm_lance_banner_sar, itm_shield_ayycav2],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000dde0040c4549dd5ca6f4dd56500000000001e291b0000000000000000, khergit_face_older_2],
  ["knight_6_10", "Emir An Nasir Ayyub", "An Nasir Ayyub", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,   itm_courtly_saracen_boots,   itm_boots_cav_ayy2,  itm_helm_ayy5, itm_gauntlets_sar2,   itm_scimitar2, itm_lance_banner_sar,  itm_shield_ayycav2],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001a60441c66ce99256b4ad4b3300000000001d392c0000000000000000, khergit_face_older_2],
  ["knight_6_11", "Emir Al Ashraf", "Al Ashraf", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,      itm_courtly_saracen_boots,       itm_boots_cav_ayy2,    itm_helm_ayy5,  itm_gauntlets_sar2,    itm_scimitar2, itm_lance_banner_sar,  itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000fff08134726c28af8dc96e4da00000000001e541d0000000000000000, khergit_face_middle_2],
  ["knight_6_12", "Emir Al Muzaffar Sulayman", "Al Muzaffar Sulayman", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,  itm_mamluk_ayy2,      itm_courtly_saracen_boots,    itm_boots_cav_ayy2,    itm_helm_ayy5,   itm_gauntlets_sar2,  itm_scimitar2, itm_lance_banner_sar,  itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x0000000035104084635b74ba5491a7a400000000001e46d60000000000000000, khergit_face_old_2],
  ["knight_6_13", "Emir Al Mas'ud Yusuf", "Al Mas'ud Yusuf", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,   itm_courtly_saracen_boots,   itm_boots_cav_ayy2,      itm_helm_ayy5,   itm_gauntlets_sar2,     itm_scimitar2,itm_lance_banner_sar,  itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000000001021435b734d4ad94eba9400000000001eb8eb0000000000000000, khergit_face_older_2],
  ["knight_6_14", "Emir Al Mansur Muhammad", "Al Mansur Muhammad", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,    itm_courtly_outfit_ayy, itm_mamluk_ayy2,   itm_courtly_saracen_boots,  itm_boots_cav_ayy2,      itm_helm_ayy5,   itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,    itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000000c0c45c63a5b921ac22db8e200000000001cca530000000000000000, khergit_face_older_2],
  ["knight_6_15", "Emir Al Muzaffar Ghazi", "Al Muzaffar Ghazi", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,   itm_mamluk_ayy2,  itm_courtly_saracen_boots,  itm_boots_cav_ayy2,    itm_helm_ayy5,  itm_gauntlets_sar2,    itm_scimitar2,itm_lance_banner_sar,  itm_shield_ayycav2], knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000001b0c4185369a6938cecde95600000000001f25210000000000000000, khergit_face_older_2],
  
  ["knight_6_16", "Emir Al Mujahid", "Al Mujahid", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,  itm_mamluk_ayy2,      itm_courtly_saracen_boots,     itm_boots_cav_ayy2,      itm_helm_ayy5, itm_gauntlets_sar2,  itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000007770841c80a01e1c5eb51ffff00000000001f12d80000000000000000, khergit_face_middle_2],
  ["knight_6_17", "Emir Al Muzaffar Mahmud", "Al Muzaffar Mahmud", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,   itm_mamluk_ayy2,   itm_courtly_saracen_boots,     itm_boots_cav_ayy2,    itm_helm_ayy5,  itm_gauntlets_sar2,      itm_scimitar2,itm_lance_banner_sar,    itm_shield_ayycav2],     knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000007f0462c32419f47a1aba8bcf00000000001e7e090000000000000000, khergit_face_old_2],
  ["knight_6_18", "Emir An Nasir Dawud", "An Nasir Dawud", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1, itm_courtly_outfit_ayy, itm_mamluk_ayy2,   itm_courtly_saracen_boots,  itm_boots_cav_ayy2,      itm_helm_ayy5,  itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],    knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000003410410070d975caac91aca500000000001c27530000000000000000, khergit_face_older_2],
  ["knight_6_19", "Emir As Salih Ayyub", "As Salih Ayyub", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,   itm_courtly_outfit_ayy,  itm_mamluk_ayy2,    itm_courtly_saracen_boots,   itm_boots_cav_ayy2,    itm_helm_ayy5, itm_gauntlets_sar2,   itm_scimitar2,  itm_lance_banner_sar, itm_shield_ayycav2],   knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x000000018a08618016ac36bc8b6e4a9900000000001dd45d0000000000000000, khergit_face_older_2],
  ["knight_6_20", "Emir Al Awhad", "Al Awhad", tf_hero, 0, reserved,  fac_kingdom_6, [itm_arabian_cav1,  itm_courtly_outfit_ayy,   itm_mamluk_ayy2,  itm_courtly_saracen_boots,   itm_boots_cav_ayy2,  itm_helm_ayy5,  itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,   itm_shield_ayycav2],  knight_attrib_5,wp(260),knight_skills_5|knows_trainer_6|knows_shield_7, 0x00000001bd0040c0281a899ac956b94b00000000001ec8910000000000000000, khergit_face_older_2],
  


  
  ["kingdom_1_pretender",  "Princess Sibylla",       "Sibylla",  tf_hero|tf_female|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_1,[itm_horse_jer2,   itm_lady_dress_green,  itm_blue_hose,    itm_leather_boots,   itm_mail_boots1,         itm_knight_jer4,    itm_mail_mittens1,  itm_sword_medieval_a1,itm_lance_banner_jer,      itm_shield_knight_jer7,       itm_helm_jer],          lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x00000000ef00000237dc71b90c31631200000000001e371b0000000000000000],
#claims pre-salic descent

  ["kingdom_2_pretender",  "Count Philip of Flanders", "Philip of Flanders",  tf_hero|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_2,[itm_horse_ant2,    itm_courtly_outfit_ant,      itm_courtly_mail_boots,              itm_mail_boots1,              itm_knight_ant8,    itm_mail_mittens1,   itm_sword_medieval_a2, itm_lance_banner_ant,     itm_shield_knight_ant7,      itm_helm_red],    lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x00000000200412142452ed631b30365c00000000001c94e80000000000000000, vaegir_face_middle_2],
#had his patrimony falsified

  ["kingdom_3_pretender",  "Emir Mesud Kutbeddin",               "Mesud Kutbeddin",  tf_hero|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_3,[itm_arabian_cav1,   itm_courtly_outfit_sel,             itm_courtly_seljuk_boots,              itm_boots_cav_sel1,           itm_mamluk_sel3,    itm_gauntlets_sar1,     itm_scimitar3, itm_lance_banner_sar,             itm_shield_ayycav5,       itm_helm_sel3],      lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x000000065504310b30d556b51238f66100000000001c256d0000000000000000, khergit_face_middle_2],
#of the family

  ["kingdom_4_pretender",  "Master James of Mailly",   "James of Mailly",  tf_hero|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_4,[itm_horse_tem2,    itm_courtly_outfit_tem,    itm_courtly_mail_boots,              itm_mail_boots1,                 itm_knight_tem3,      itm_mail_mittens1,     itm_sword_medieval_tem, itm_lance_banner_tem,          itm_shield_knight_tem3,    itm_helm_tem],            lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x00000004340c01841d89949529a6776a00000000001c910a0000000000000000, nord_face_young_2],
#dispossessed and wronged

  ["kingdom_5_pretender",  "Master William Borrel",  "William Borrel",  tf_hero|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_5,[itm_horse_hos1,  itm_courtly_outfit_hos,             itm_courtly_mail_boots,              itm_mail_boots1,   itm_knight_hos4,     itm_mail_mittens1,      itm_sword_medieval_hos,  itm_lance_banner_hos,       itm_shield_knight_hos4,        itm_helm_hos],         lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x0000000bed1031051da9abc49ecce25e00000000001e98680000000000000000, rhodok_face_old_2],
#republican

  ["kingdom_6_pretender",  "Amirah Mavia",       "Mavia",  tf_hero|tf_female|tf_unmoveable_in_party_window, 0,reserved,  fac_kingdom_6,[itm_arabian_cav1, itm_brown_dress,   itm_mamluk_ayy2, itm_nomad_boots,   itm_boots_cav_ayy2,  itm_gauntlets_sar2,     itm_scimitar2,  itm_lance_banner_sar,    itm_shield_ayycav2,      itm_helm_ayy5],          lord_attrib,wp(260),knight_skills_5|knows_shield_7, 0x000000050b003004072d51c293a9a70b00000000001dd6a90000000000000000],


#Royal family members

  ["knight_1_1_wife","Error - knight_1_1_wife should not appear in game","knight_1_1_wife",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_commoners, [itm_lady_dress_ruby ,   itm_turret_hat_ruby,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000055910200107632d675a92b92d00000000001e45620000000000000000],

  #Swadian ladies - eight mothers, eight daughters, four sisters
  ["kingdom_1_lady_1","Lady Eschiva","Eschiva",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,          itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000055910200107632d675a92b92d00000000001e45620000000000000000],
  ["kingdom_1_lady_2","Lady Constance","Constance",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054f08100232636aa90d6e194b00000000001e43130000000000000000],
  ["knight_1_lady_3","Lady Sibylla","Sibylla",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1,  [itm_lady_dress_green,       itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000018f0410064854c742db74b52200000000001d448b0000000000000000],
  ["knight_1_lady_4","Lady Jeanne","Jeanne",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1,  [itm_lady_dress_green,       itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000000204200629b131e90d6a8ae400000000001e28dd0000000000000000],
  ["kingdom_l_lady_5","Lady Stephanie","Stephanie",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_6","Lady Alix","Alix",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,   0x000000000d0820011693b142ca6a271a00000000001db6920000000000000000],
  ["kingdom_1_lady_7","Lady Agnes","Agnes",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_8","Lady Beatrice","Beatrice",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,        itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000001900000542ac4e76d5d0d35300000000001e26a40000000000000000],
  ["kingdom_1_lady_9","Lady Heloise","Heloise",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_10","Lady Euphemia","Euphemia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,   0x000000003a00200646a129464baaa6db00000000001de7a00000000000000000],
  ["kingdom_1_lady_11","Lady Isabella","Isabella",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_12","Lady Corinne","Corinne",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,  0x000000003f04100148d245d6526d456b00000000001e3b350000000000000000],
  ["kingdom_l_lady_13","Lady Juliane","Juliane",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,     itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_14","Lady Margaret","Margaret",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000003a0c3003358a56d51c8e399400000000000944dc0000000000000000],
  ["kingdom_1_lady_15","Lady Marie","Marie",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1, swadian_woman_face_2],
  ["kingdom_1_lady_16","Lady Adele","Adele",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000003b080003531e8932e432bb5a000000000008db6a0000000000000000],
  ["kingdom_1_lady_17","Lady Amelie","Amelie",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000446e4b4c2cc5234d200000000001ea3120000000000000000],
  ["kingdom_1_lady_18","Lady Anne","Anne",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000000083006465800000901161200000000001e38cc0000000000000000],

  ["kingdom_2_lady_17","Lady Bourgogne","Bourgogne",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1],
  ["kingdom_2_lady_18","Lady Melisende","Melisende",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_2],
  
  #Vaegir ladies
  ["kingdom_2_lady_1","Lady Catherine","Catherine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
  ["kingdom_2_lady_2","Lady Christine","Christine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
  ["kingdom_2_lady_3","Lady Jeanette","Jeanette",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,   itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
  ["kingdom_2_lady_4","Lady Josephine","Josephine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,    itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],
  ["kingdom_2_lady_5","Lady Nathalie","Nathalie",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
  ["kingdom_2_lady_6","Lady Lucienne","Lucienne",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
  ["kingdom_2_lady_7","Lady Madeleine","Madeleine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
  ["kingdom_2_lady_8","Lady Lydia","Lydia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,    itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],
  ["kingdom_2_lady_9","Lady Sylvaine","Sylvaine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
  ["kingdom_2_lady_10","Lady Claire","Claire",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
  ["kingdom_2_lady_11","Lady Michele","Michele",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,    itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
  ["kingdom_2_lady_12","Lady Monique","Monique",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,      itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],
  ["kingdom_2_lady_13","Lady Morgaine","Morgaine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
  ["kingdom_2_lady_14","Lady Nadine","Nadine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,     itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
  ["kingdom_2_lady_15","Lady Nicole","Nicole",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
  ["kingdom_2_lady_16","Lady Valerie","Valerie",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,       itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],
#  ["kingdom_2_lady_17","Lady Sihavan","Sihavan",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
#  ["kingdom_2_lady_18","Lady Erenchina","Erenchina",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2, [itm_lady_dress_green,  itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
#  ["kingdom_2_lady_19","Lady Tamar","Tamar",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
#  ["kingdom_2_lady_20","Lady Valka","Valka",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_2,  [itm_lady_dress_green,   itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],


  ["kingdom_3_lady_1","Sayyida Asli","Asli",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1],
  ["kingdom_3_lady_2","Sayyida Emine","Emine",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008ec0820062ce4d246b38e632e00000000001d52910000000000000000],
  ["kingdom_3_lady_3","Sayyida Gizem","Gizem",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_2],
  ["kingdom_3_lady_4","Sayyida Hazan","Hazan",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000002a0c200348a28f2a54aa391c00000000001e46d10000000000000000],
  ["kingdom_3_lady_5","Sayyida Sanaz","Sanaz",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000056e082002471c91c8aa2a130b00000000001d48a40000000000000000],
  ["kingdom_3_lady_6","Sayyida Su","Su",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000056e082002471c91c8aa2a130b00000000001d48a40000000000000000],
  ["kingdom_3_lady_7","Sayyida Umut","Umut",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000320c30023ce23a145a8f27a300000000001ea6dc0000000000000000],
  ["kingdom_3_lady_8","Sayyida Nesrin","Nesrin",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000320c30023ce23a145a8f27a300000000001ea6dc0000000000000000],
  ["kingdom_3_lady_9","Sayyida Esin","Esin",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001940c3006019c925165d1129b00000000001d13240000000000000000],
  ["kingdom_3_lady_10","Sayyida Ceren","Ceren",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008ec0820062ce4d246b38e632e00000000001d52910000000000000000],
  ["kingdom_3_lady_11","Sayyida Melek","Melek",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000019b083005389591941379b8d100000000001e63150000000000000000],
  ["kingdom_3_lady_12","Sayyida Ayla","Ayla",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000002a0c200348a28f2a54aa391c00000000001e46d10000000000000000],
  ["kingdom_3_lady_13","Sayyida Canan","Canan",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000056e082002471c91c8aa2a130b00000000001d48a40000000000000000],
  ["kingdom_3_lady_14","Sayyida Bercu","Bercu",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1],
  ["kingdom_3_lady_15","Sayyida Elmas","Elmas",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_2],
  ["kingdom_3_lady_16","Sayyida Yildiz","Yildiz",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001ad003001628c54b05d2e48b200000000001d56e60000000000000000],
  ["kingdom_3_lady_17","Sayyida Tulay", "Tulay",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001a700300265cb6db15d6db6da00000000001f82180000000000000000],
  ["kingdom_3_lady_18","Sayyida Dilara","Dilara",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3, [      itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008ec0820062ce4d246b38e632e00000000001d52910000000000000000],
  ["kingdom_3_lady_19","Sayyida Basak","Basak",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000320c30023ce23a145a8f27a300000000001ea6dc0000000000000000],
  ["kingdom_3_lady_20","Sayyida Aysu","Aysu",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_3,  [    itm_brown_dress ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000002a0c200348a28f2a54aa391c00000000001e46d10000000000000000],
  
#  ["kingdom_4_lady_21","Sayyida Sihavan","Sihavan",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007c0101002588caf17142ab93d00000000001ddfa40000000000000000],
#  ["kingdom_4_lady_22","Sayyida Erenchina","Erenchina",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_lady_dress_green,  itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000008c00c20032aa5ae36b4259b9300000000001da6a50000000000000000],
#  ["kingdom_4_lady_23","Sayyida Tamar","Tamar",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [itm_lady_dress_green,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000007080004782a6cc4ecae4d1e00000000001eb6e30000000000000000],
#  ["kingdom_4_lady_24","Sayyida Valka","Valka",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [itm_lady_dress_green,   itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054008200638db99d89eccbd3500000000001ec91d0000000000000000],
  
  
#  ["kingdom_4_lady_1","Lady Jadeth","Jadeth",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054b100003274d65d2d239eb1300000000001d49080000000000000000],
#  ["kingdom_4_lady_2","Lady Miar","Miar",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000058610000664d3693664f0c54b00000000001d332d0000000000000000],
#  ["kingdom_4_lady_3","Lady Dria","Dria",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress, itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000469a4d5cda4b1349c00000000001cd6600000000000000000],
#  ["kingdom_4_lady_4","Lady Glunde","Glunde",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000000021564d196e2aa279400000000001dc4ed0000000000000000],
#  ["kingdom_4_lady_5","Lady Loeka","Loeka",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054b100003274d65d2d239eb1300000000001d49080000000000000000],
#  ["kingdom_4_lady_6","Lady Bryn","Bryn",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000058610000664d3693664f0c54b00000000001d332d0000000000000000],
#  ["kingdom_6_lady_25","Sayyida Eir","Eir",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000469a4d5cda4b1349c00000000001cd6600000000000000000],
#  ["knight_4_2b_daughter_1","Lady Thera","Thera",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000000021564d196e2aa279400000000001dc4ed0000000000000000],
#  ["kingdom_4_lady_9","Lady Hild","Hild",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,  itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054b100003274d65d2d239eb1300000000001d49080000000000000000],
#  ["knight_4_2c_wife_1","Lady Endegrid","Endegrid",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000058610000664d3693664f0c54b00000000001d332d0000000000000000],
#  ["kingdom_6_lady_26","Sayyida Herjasa","Herjasa",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000469a4d5cda4b1349c00000000001cd6600000000000000000],
#  ["knight_4_2c_daughter","Lady Svipul","Svipul",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000000021564d196e2aa279400000000001dc4ed0000000000000000],
#  ["knight_4_1b_wife","Lady Ingunn","Ingunn",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054b100003274d65d2d239eb1300000000001d49080000000000000000],
#  ["kingdom_6_lady_27","Sayyida Kaeteli","Kaeteli",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000058610000664d3693664f0c54b00000000001d332d0000000000000000],
#  ["knight_4_1b_daughter","Lady Eilif","Eilif",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000469a4d5cda4b1349c00000000001cd6600000000000000000],
#  ["knight_4_2b_daughter_2","Lady Gudrun","Gudrun",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000000021564d196e2aa279400000000001dc4ed0000000000000000],
#  ["kingdom_6_lady_28","Sayyida Bergit","Bergit",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [      itm_court_dress ,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054b100003274d65d2d239eb1300000000001d49080000000000000000],
#  ["knight_4_2c_wife_2","Lady Aesa","Aesa",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4, [      itm_court_dress ,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000058610000664d3693664f0c54b00000000001d332d0000000000000000],
#  ["knight_4_1c_daughter","Lady Alfrun","Alfrun",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_4,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000469a4d5cda4b1349c00000000001cd6600000000000000000],
#  ["kingdom_6_lady_29","Sayyida Afrid","Afrid",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [    itm_court_dress,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000000021564d196e2aa279400000000001dc4ed0000000000000000],


#  ["kingdom_5_lady_1","Lady Brina","Brina",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,     itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007e900200416ed96e88b8d595a00000000001cb8ac0000000000000000],
#  ["kingdom_5_lady_2","Lady Aliena","Aliena",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057008200222d432cf6d4a2ae300000000001d37a10000000000000000],
#  ["kingdom_5_lady_3","Lady Aneth","Aneth",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001b9002002364dd8aa5475d76400000000001db8d30000000000000000],
#  ["kingdom_5_lady_4","Lady Reada","Reada",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057a0000014123dae69e8e48e200000000001e08db0000000000000000],
#  ["kingdom_5_5_wife","Lady Saraten","Saraten",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, swadian_woman_face_1],
#  ["kingdom_5_2b_wife_1","Lady Baotheia","Baotheia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [itm_lady_dress_green,     itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000bf0400035913aa236b4d975a00000000001eb69c0000000000000000],
#  ["kingdom_5_1c_daughter_1","Lady Eleandra","Eleandra",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001b9002002364dd8aa5475d76400000000001db8d30000000000000000],
#  ["kingdom_5_2c_daughter_1","Lady Meraced","Meraced",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,     itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057a0000014123dae69e8e48e200000000001e08db0000000000000000],
#  ["kingdom_5_1c_wife_1","Lady Adelisa","Adelisa",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007e900200416ed96e88b8d595a00000000001cb8ac0000000000000000],
#  ["kingdom_5_2c_wife_1","Lady Calantina","Calantina",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057008200222d432cf6d4a2ae300000000001d37a10000000000000000],
#  ["kingdom_5_1c_daughter_2","Lady Forbesa","Forbesa",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001b9002002364dd8aa5475d76400000000001db8d30000000000000000],
#  ["kingdom_5_2c_daughter_2","Lady Claudora","Claudora",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057a0000014123dae69e8e48e200000000001e08db0000000000000000],
#  ["kingdom_5_1b_wife","Lady Anais","Anais",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007e900200416ed96e88b8d595a00000000001cb8ac0000000000000000],
#  ["kingdom_5_2b_wife_2","Lady Miraeia","Miraeia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057008200222d432cf6d4a2ae300000000001d37a10000000000000000],
#  ["kingdom_5_1c_daughter_3","Lady Agasia","Agasia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001b9002002364dd8aa5475d76400000000001db8d30000000000000000],
#  ["kingdom_6_lady_26","Sayyida Geneiava","Geneiava",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057a0000014123dae69e8e48e200000000001e08db0000000000000000],
#  ["kingdom_5_1c_wife_2","Lady Gwenael","Gwenael",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000007e900200416ed96e88b8d595a00000000001cb8ac0000000000000000],
#  ["kingdom_5_2c_wife_2","Lady Ysueth","Ysueth",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5, [      itm_lady_dress_green,   itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057008200222d432cf6d4a2ae300000000001d37a10000000000000000],
#  ["kingdom_5_1c_daughter_4","Lady Ellian","Ellian",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_5,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000001b9002002364dd8aa5475d76400000000001db8d30000000000000000],
#  ["kingdom_6_lady_27","Sayyida Timethi","Timethi",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [ itm_lady_dress_ruby ,  itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000057a0000014123dae69e8e48e200000000001e08db0000000000000000],
  
#Sarranid ladies
  ["kingdom_6_lady_1","Sayyida Aamina","Aamina",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,  itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000055910200107632d675a92b92d00000000001e45620000000000000000],
  ["kingdom_6_lady_2","Sayyida Fahima","Fahima",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000054f08100232636aa90d6e194b00000000001e43130000000000000000],
  ["kingdom_6_lady_3","Sayyida Bahija","Bahija",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [itm_brown_dress,       itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000018f0410064854c742db74b52200000000001d448b0000000000000000],
  ["kingdom_6_lady_4","Sayyida Fadia","Fadia",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6,  [itm_brown_dress,       itm_leather_boots], def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000000204200629b131e90d6a8ae400000000001e28dd0000000000000000],
  ["kingdom_6_lady_5","Sayyida Bawthan","Bawthan",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_6","Sayyida Fakhriya","Fakhriya",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,   0x000000000d0820011693b142ca6a271a00000000001db6920000000000000000],
  ["kingdom_6_lady_7","Sayyida Ghufran","Ghufran",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_8","Sayyida Hadiya","Hadiya",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,        itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000001900000542ac4e76d5d0d35300000000001e26a40000000000000000],
  ["kingdom_6_lady_9","Sayyida Jamillah","Jamillah",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_10","Sayyida Khalila","Khalila",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,   0x000000003a00200646a129464baaa6db00000000001de7a00000000000000000],
  ["kingdom_6_lady_11","Sayyida Layla","Layla",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_12","Sayyida Lawahiz","Lawahiz",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2,  0x000000003f04100148d245d6526d456b00000000001e3b350000000000000000],
  ["kingdom_6_lady_13","Sayyida Marwa","Marwa",tf_hero|tf_randomize_face|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,     itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_14","Sayyida Na'ima","Na'ima",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000003a0c3003358a56d51c8e399400000000000944dc0000000000000000],
  ["kingdom_6_lady_15","Sayyida Nuha","Nuha",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,       itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1, khergit_woman_face_2],
  ["kingdom_6_lady_16","Sayyida Sahar","Sahar",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000003b080003531e8932e432bb5a000000000008db6a0000000000000000],
  ["kingdom_6_lady_17","Sayyida Batul","Batul",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x00000000000c000446e4b4c2cc5234d200000000001ea3120000000000000000],
  ["kingdom_6_lady_18","Sayyida Widad","Widad",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x0000000000083006465800000901161200000000001e38cc0000000000000000],
  ["kingdom_6_lady_19","Sayyida Tijah","Tijah",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_1],
  ["kingdom_6_lady_20","Sayyida Aidah","Aidah",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_6, [itm_brown_dress,      itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, khergit_woman_face_2],

  ["heroes_end", "{!}heroes end", "{!}heroes end", tf_hero, 0,reserved,  fac_neutral,[itm_saddle_horse1,itm_leather_jacket,itm_nomad_boots],def_attrib|level(2),wp(20),knows_common, 0x000000000008318101f390c515555594],

  
#Seneschals
  ["town_1_seneschal", "{!}Town 1 Seneschal", "{!}Town 1 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c218501ef4f5d2ccb0026],
  ["town_2_seneschal", "{!}Town 2 Seneschal", "{!}Town 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000c03cc01cc34a9a467fdfd],
  ["town_3_seneschal", "{!}Town 3 Seneschal", "{!}Town 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c500e01dbb2115a55f3cd],
  ["town_4_seneschal", "{!}Town 4 Seneschal", "{!}Town 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000008035201e6eebaf3f3eb2b],
  ["town_5_seneschal", "{!}Town 5 Seneschal", "{!}Town 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000000249101e7898999ac54c6],
  ["town_6_seneschal", "{!}Town 6 Seneschal", "{!}Town 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x000000000010360b01cef8b57553d34e],
  ["town_7_seneschal", "{!}Town 7 Seneschal", "{!}Town7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000000018101f9487aa831dce4],
  ["town_8_seneschal", "{!}Town 8 Seneschal", "{!}Town 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x000000000004715201ea236c60a2bcae],
  ["town_9_seneschal", "{!}Town 9 Seneschal", "{!}Town 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["town_10_seneschal", "{!}Town 10 Seneschal", "{!}Town 10 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,     itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000010230c01ef41badb50465e],
  ["town_11_seneschal", "{!}Town 11 Seneschal", "{!}Town 11 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,     itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x000000000008061301fb89acfb95332f],
  ["town_12_seneschal", "{!}Town 12 Seneschal", "{!}Town 12 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c13ce01dc4723ab936c82],
  ["town_13_seneschal", "{!}Town 13 Seneschal", "{!}Town 13 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000008548e01d952a9b25d6d5a],
  ["town_14_seneschal", "{!}Town 14 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_15_seneschal", "{!}Town 15 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_16_seneschal", "{!}Town 16 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_17_seneschal", "{!}Town17 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_18_seneschal", "{!}Town 18 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_19_seneschal", "{!}Town 19 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_20_seneschal", "{!}Town 20 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_21_seneschal", "{!}Town 21 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],
  ["town_22_seneschal", "{!}Town 22 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000000004728b01c293c694944b05],

  ["castle_1_seneschal", "{!}Castle 1 Seneschal", "{!}Castle 1 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,          itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x000000000010360b01cef8b57553d34e],
  ["castle_2_seneschal", "{!}Castle 2 Seneschal", "{!}Castle 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000008061301fb89acfb95332f],
  ["castle_3_seneschal", "{!}Castle 3 Seneschal", "{!}Castle 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008548e01d952a9b25d6d5a],
  ["castle_4_seneschal", "{!}Castle 4 Seneschal", "{!}Castle 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000004715201ea236c60a2bcae],
  ["castle_5_seneschal", "{!}Castle 5 Seneschal", "{!}Castle 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c500e01dbb2115a55f3cd],
  ["castle_6_seneschal", "{!}Castle 6 Seneschal", "{!}Castle 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,          itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c03cc01cc34a9a467fdfd],
  ["castle_7_seneschal", "{!}Castle 7 Seneschal", "{!}Castle 7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,         itm_blue_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000c13ce01dc4723ab936c82],
  ["castle_8_seneschal", "{!}Castle 8 Seneschal", "{!}Castle 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c218501ef4f5d2ccb0026],
  ["castle_9_seneschal", "{!}Castle 9 Seneschal", "{!}Castle 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008035201e6eebaf3f3eb2b],
  ["castle_10_seneschal", "{!}Castle 10 Seneschal", "{!}Castle 10 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_11_seneschal", "{!}Castle 11 Seneschal", "{!}Castle 11 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_12_seneschal", "{!}Castle 2 Seneschal", "{!}Castle 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000008061301fb89acfb95332f],
  ["castle_13_seneschal", "{!}Castle 3 Seneschal", "{!}Castle 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008548e01d952a9b25d6d5a],
  ["castle_14_seneschal", "{!}Castle 4 Seneschal", "{!}Castle 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000004715201ea236c60a2bcae],
  ["castle_15_seneschal", "{!}Castle 5 Seneschal", "{!}Castle 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c500e01dbb2115a55f3cd],
  ["castle_16_seneschal", "{!}Castle 6 Seneschal", "{!}Castle 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,          itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c03cc01cc34a9a467fdfd],
  ["castle_17_seneschal", "{!}Castle 7 Seneschal", "{!}Castle 7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,         itm_blue_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000c13ce01dc4723ab936c82],
  ["castle_18_seneschal", "{!}Castle 8 Seneschal", "{!}Castle 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c218501ef4f5d2ccb0026],
  ["castle_19_seneschal", "{!}Castle 9 Seneschal", "{!}Castle 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008035201e6eebaf3f3eb2b],
  ["castle_20_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_21_seneschal", "{!}Castle 11 Seneschal", "{!}Castle 11 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_22_seneschal", "{!}Castle 2 Seneschal", "{!}Castle 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000008061301fb89acfb95332f],
  ["castle_23_seneschal", "{!}Castle 3 Seneschal", "{!}Castle 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008548e01d952a9b25d6d5a],
  ["castle_24_seneschal", "{!}Castle 4 Seneschal", "{!}Castle 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000004715201ea236c60a2bcae],
  ["castle_25_seneschal", "{!}Castle 5 Seneschal", "{!}Castle 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c500e01dbb2115a55f3cd],
  ["castle_26_seneschal", "{!}Castle 6 Seneschal", "{!}Castle 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,          itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c03cc01cc34a9a467fdfd],
  ["castle_27_seneschal", "{!}Castle 7 Seneschal", "{!}Castle 7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,         itm_blue_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000c13ce01dc4723ab936c82],
  ["castle_28_seneschal", "{!}Castle 8 Seneschal", "{!}Castle 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c218501ef4f5d2ccb0026],
  ["castle_29_seneschal", "{!}Castle 9 Seneschal", "{!}Castle 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008035201e6eebaf3f3eb2b],
  ["castle_30_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_31_seneschal", "{!}Castle 11 Seneschal", "{!}Castle 11 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_32_seneschal", "{!}Castle 2 Seneschal", "{!}Castle 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000008061301fb89acfb95332f],
  ["castle_33_seneschal", "{!}Castle 3 Seneschal", "{!}Castle 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008548e01d952a9b25d6d5a],
  ["castle_34_seneschal", "{!}Castle 4 Seneschal", "{!}Castle 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,           itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000004715201ea236c60a2bcae],
  ["castle_35_seneschal", "{!}Castle 5 Seneschal", "{!}Castle 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c500e01dbb2115a55f3cd],
  ["castle_36_seneschal", "{!}Castle 6 Seneschal", "{!}Castle 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,          itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000000000c03cc01cc34a9a467fdfd],
  ["castle_37_seneschal", "{!}Castle 7 Seneschal", "{!}Castle 7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,         itm_blue_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000c13ce01dc4723ab936c82],
  ["castle_38_seneschal", "{!}Castle 8 Seneschal", "{!}Castle 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,        itm_hide_boots],    def_attrib|level(2),wp(20),knows_common, 0x00000000000c218501ef4f5d2ccb0026],
  ["castle_39_seneschal", "{!}Castle 9 Seneschal", "{!}Castle 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,        itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000000008035201e6eebaf3f3eb2b],
  ["castle_40_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_41_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_42_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_43_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_44_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_45_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_46_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_47_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_48_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
## CC
  ["castle_49_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_50_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_51_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_52_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_53_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_54_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_55_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_56_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_57_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_58_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_59_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_60_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_61_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_62_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_63_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
  ["castle_64_seneschal", "{!}Castle 20 Seneschal", "{!}Castle 20 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,    itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000000000440c601e1cd45cfb38550],
## CC

#Arena Masters
  ["town_1_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_1_arena|entry(52),reserved,   fac_commoners,[itm_village_robe,      itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_2_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_2_arena|entry(52),reserved,   fac_commoners,[itm_village_robe1,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_3_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_3_arena|entry(52),reserved,   fac_commoners,[itm_village_robe2,       itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_4_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_4_arena|entry(52),reserved,   fac_commoners,[itm_village_robe3,      itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_5_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_5_arena|entry(52),reserved,   fac_commoners,[itm_village_robe4,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_6_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_6_arena|entry(52),reserved,   fac_commoners,[itm_village_robe5,    itm_leather_boots], def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_7_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_7_arena|entry(52),reserved,   fac_commoners,[itm_village_robe6,    itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_8_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_8_arena|entry(52),reserved,   fac_commoners,[itm_village_robe,       itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_9_arena_master", "Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_9_arena|entry(52),reserved,   fac_commoners,[itm_village_robe1,    itm_leather_boots], def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_10_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_10_arena|entry(52),reserved,  fac_commoners,[itm_village_robe2,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_11_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_11_arena|entry(52),reserved,  fac_commoners,[itm_village_robe3,      itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_12_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_12_arena|entry(52),reserved,  fac_commoners,[itm_village_robe4,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_13_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_13_arena|entry(52),reserved,  fac_commoners,[itm_village_robe5,      itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_14_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_14_arena|entry(52),reserved,  fac_commoners,[itm_village_robe6,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_15_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_15_arena|entry(52),reserved,  fac_commoners,[itm_village_robe,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_16_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_16_arena|entry(52),reserved,  fac_commoners,[itm_village_robe1,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_17_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_17_arena|entry(52),reserved,  fac_commoners,[itm_village_robe2,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_18_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_18_arena|entry(52),reserved,  fac_commoners,[itm_village_robe3,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_19_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_19_arena|entry(52),reserved,  fac_commoners,[itm_village_robe4,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_20_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_20_arena|entry(52),reserved,  fac_commoners,[itm_village_robe5,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_21_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_21_arena|entry(52),reserved,  fac_commoners,[itm_village_robe6,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],
  ["town_22_arena_master","Tournament Master","{!}Tournament Master",tf_hero|tf_randomize_face, scn_town_22_arena|entry(52),reserved,  fac_commoners,[itm_village_robe,    itm_hide_boots],    def_attrib|level(2),wp(20),knows_common,man_face_middle_1, man_face_older_2],


# Armor Merchants
  #arena_masters_end = zendar_armorer

  ["town_1_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,           itm_leather_boots   ],def_attrib|level(2),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_2_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,          itm_hide_boots       ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_3_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,        itm_hide_boots      ],def_attrib|level(2),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_4_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe3,         itm_leather_boots   ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_5_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,          itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_6_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,       itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_7_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe6,       itm_blue_hose       ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_8_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,       itm_leather_boots   ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_9_armorer","Armorer",  "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe1,        itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_10_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,       itm_hide_boots      ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_11_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe3,        itm_leather_boots   ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_12_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,         itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_13_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,       itm_hide_boots      ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_14_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,         itm_hide_boots       ],def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_15_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,        itm_leather_boots   ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_16_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe1,         itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_17_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,       itm_hide_boots      ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_18_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,         itm_hide_boots       ],def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_19_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,        itm_leather_boots   ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_20_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,         itm_nomad_boots     ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_21_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe6,       itm_hide_boots      ],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_22_armorer","Armorer", "{!}Armorer",  tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,         itm_hide_boots      ],def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],

# Weapon merchants

  ["town_1_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,      itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_2_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,     itm_nomad_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_3_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe3,   itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_4_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,            itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_5_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,   itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_6_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe6,      itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_7_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,            itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_8_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|tf_female|tf_is_merchant, 0, 0, fac_commoners,[itm_sarranid_common_dress,     itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_9_weaponsmith", "Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,   itm_leather_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_10_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe3,     itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_11_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,  itm_woolen_hose],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_12_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,           itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_13_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe6,     itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_14_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,     itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_15_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe1,  itm_woolen_hose],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_16_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe2,           itm_hide_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_17_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe3,     itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_18_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe4,     itm_wrapping_boots],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_19_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe5,  itm_sarranid_boots_a],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_20_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe6,           itm_sarranid_boots_a],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_21_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe,     itm_sarranid_boots_a],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],
  ["town_22_weaponsmith","Weaponsmith","{!}Weaponsmith",tf_hero|tf_randomize_face|          tf_is_merchant, 0, 0, fac_commoners,[itm_village_robe1,     itm_sarranid_boots_a],def_attrib|level(5),wp(20),knows_inventory_management_10, mercenary_face_1, mercenary_face_2],

#Tavern keepers

  ["town_1_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_1_tavern|entry(9),0,   fac_commoners,[itm_village_robe,       itm_wrapping_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_2_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_2_tavern|entry(9),0,   fac_commoners,[itm_village_robe1,       itm_leather_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_3_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_3_tavern|entry(9),0,   fac_commoners,[itm_sarranid_common_dress,        itm_hide_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_4_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_4_tavern|entry(9),0,   fac_commoners,[itm_village_robe2,       itm_leather_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_5_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_5_tavern|entry(9),0,   fac_commoners,[itm_village_robe3,       itm_hide_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_6_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_6_tavern|entry(9),0,   fac_commoners,[itm_sarranid_common_dress,        itm_hide_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_7_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_7_tavern|entry(9),0,   fac_commoners,[itm_sarranid_common_dress,        itm_leather_boots,      itm_sarranid_felt_head_cloth_b],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_8_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_8_tavern|entry(9),0,   fac_commoners,[itm_village_robe4,      itm_leather_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_9_tavernkeeper", "Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_9_tavern|entry(9),0,   fac_commoners,[itm_sarranid_common_dress,        itm_nomad_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_10_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_10_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_hide_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_11_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_11_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_nomad_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_12_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_12_tavern|entry(9),0,  fac_commoners,[itm_village_robe5,       itm_hide_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_13_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_13_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_hide_boots,     itm_sarranid_felt_head_cloth_b],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_14_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_14_tavern|entry(9),0,  fac_commoners,[itm_village_robe6,               itm_leather_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_15_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_15_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_nomad_boots],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_16_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_16_tavern|entry(9),0,  fac_commoners,[itm_village_robe,       itm_hide_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_17_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_17_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_hide_boots,     itm_sarranid_felt_head_cloth_b],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_18_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_18_tavern|entry(9),0,  fac_commoners,[itm_village_robe1,               itm_leather_boots],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_19_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_19_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_sarranid_boots_a],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_20_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_20_tavern|entry(9),0,  fac_commoners,[itm_village_robe2,       itm_sarranid_boots_a],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],
  ["town_21_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face|tf_female, scn_town_21_tavern|entry(9),0,  fac_commoners,[itm_sarranid_common_dress,        itm_sarranid_boots_a,     itm_sarranid_felt_head_cloth_b],def_attrib|level(2),wp(20),knows_common, woman_face_1, woman_face_2],
  ["town_22_tavernkeeper","Tavern_Keeper","{!}Tavern_Keeper",tf_hero|tf_randomize_face,           scn_town_22_tavern|entry(9),0,  fac_commoners,[itm_village_robe3,               itm_sarranid_boots_a],def_attrib|level(2),wp(20),knows_common, mercenary_face_1, mercenary_face_2],

#Goods Merchants

  ["town_1_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_1_store|entry(9),0, fac_commoners,     [itm_village_robe,  itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_2_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_2_store|entry(9),0, fac_commoners,     [itm_village_robe1, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_3_merchant", "Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_3_store|entry(9),0, fac_commoners,     [itm_sarranid_common_dress,         itm_leather_boots   ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_4_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_4_store|entry(9),0, fac_commoners,     [itm_village_robe3, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_5_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_5_store|entry(9),0, fac_commoners,     [itm_village_robe4,   itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_6_merchant", "Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_6_store|entry(9),0, fac_commoners,     [itm_village_robe5,  itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_7_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_7_store|entry(9),0, fac_commoners,     [itm_village_robe6,itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_8_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_8_store|entry(9),0, fac_commoners,     [itm_village_robe, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_9_merchant", "Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_9_store|entry(9),0, fac_commoners,     [itm_village_robe1, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_10_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_10_store|entry(9),0, fac_commoners,    [itm_village_robe2,itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_11_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_11_store|entry(9),0, fac_commoners,    [itm_village_robe3, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_12_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_12_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,  itm_leather_boots,  itm_sarranid_felt_head_cloth_b ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_13_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_13_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,         itm_leather_boots   ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_14_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_14_store|entry(9),0, fac_commoners,    [itm_village_robe6, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_15_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_15_store|entry(9),0, fac_commoners,    [itm_village_robe, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_16_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_16_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,  itm_leather_boots,  itm_sarranid_felt_head_cloth_b ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_17_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_17_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,         itm_leather_boots   ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_18_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_18_store|entry(9),0, fac_commoners,    [itm_village_robe3, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_19_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_19_store|entry(9),0, fac_commoners,    [itm_village_robe4, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_20_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_20_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,  itm_leather_boots, itm_sarranid_felt_head_cloth_b  ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_21_merchant","Merchant","{!}Merchant",tf_female|tf_hero|tf_randomize_face|tf_is_merchant, scn_town_21_store|entry(9),0, fac_commoners,    [itm_sarranid_common_dress,         itm_leather_boots,  itm_sarranid_felt_head_cloth  ],def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_22_merchant","Merchant","{!}Merchant",          tf_hero|tf_randomize_face|tf_is_merchant, scn_town_22_store|entry(9),0, fac_commoners,    [itm_village_robe, itm_leather_boots                   ],def_attrib|level(2),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],

  ["salt_mine_merchant","Barezan","Barezan",                tf_hero|tf_randomize_face|tf_is_merchant, scn_salt_mine|entry(1),0, fac_commoners,        [itm_village_robe, itm_leather_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, merchant_face_1, merchant_face_2], # CC

# Horse Merchants

  ["town_1_horse_merchant","Horse Merchant","{!}Town 1 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,    0, 0, fac_commoners,[itm_sarranid_common_dress,           itm_nomad_boots,      itm_sarranid_felt_head_cloth_b],   def_attrib|level(2),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_2_horse_merchant","Horse Merchant","{!}Town 2 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe1,          itm_nomad_boots],                      def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_3_horse_merchant","Horse Merchant","{!}Town 3 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe2,          itm_hide_boots],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_4_horse_merchant","Horse Merchant","{!}Town 4 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe3,       itm_nomad_boots],                       def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_5_horse_merchant","Horse Merchant","{!}Town 5 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,    0, 0, fac_commoners,[itm_sarranid_common_dress,                itm_nomad_boots,    itm_sarranid_felt_head_cloth_b],   def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_6_horse_merchant","Horse Merchant","{!}Town 6 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe5,         itm_hide_boots],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_7_horse_merchant","Horse Merchant","{!}Town 7 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe6,         itm_leather_boots],                     def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_8_horse_merchant","Horse Merchant","{!}Town 8 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe1,         itm_hide_boots],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_9_horse_merchant","Horse Merchant","{!}Town 9 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,              0, 0, fac_commoners,[itm_village_robe2,       itm_nomad_boots],                       def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_10_horse_merchant","Horse Merchant","{!}Town 10 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,  0, 0, fac_commoners,[itm_sarranid_common_dress,          itm_nomad_boots],     def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_11_horse_merchant","Horse Merchant","{!}Town 11 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe4,         itm_leather_boots],                     def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_12_horse_merchant","Horse Merchant","{!}Town 12 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe5,      itm_hide_boots],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_13_horse_merchant","Horse Merchant","{!}Town 13 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe6,        itm_nomad_boots],                       def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_14_horse_merchant","Horse Merchant","{!}Town 14 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,  0, 0, fac_commoners,[itm_sarranid_common_dress,       itm_nomad_boots,      itm_sarranid_felt_head_cloth_b],     def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_15_horse_merchant","Horse Merchant","{!}Town 15 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe1,         itm_leather_boots],                     def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_16_horse_merchant","Horse Merchant","{!}Town 16 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe2,      itm_hide_boots],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_17_horse_merchant","Horse Merchant","{!}Town 17 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe3,        itm_nomad_boots],                       def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_18_horse_merchant","Horse Merchant","{!}Town 18 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,  0, 0, fac_commoners,[itm_sarranid_common_dress,       itm_blue_hose,      itm_sarranid_felt_head_cloth_b],     def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],
  ["town_19_horse_merchant","Horse Merchant","{!}Town 15 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe5,         itm_sarranid_boots_a],                     def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_20_horse_merchant","Horse Merchant","{!}Town 16 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe6,      itm_sarranid_boots_a],                        def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_21_horse_merchant","Horse Merchant","{!}Town 17 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant,            0, 0, fac_commoners,[itm_village_robe,        itm_sarranid_boots_a],                       def_attrib|level(5),wp(20),knows_inventory_management_10, man_face_young_1, man_face_older_2],
  ["town_22_horse_merchant","Horse Merchant","{!}Town 18 Horse Merchant",tf_hero|tf_randomize_face|tf_is_merchant|tf_female,  0, 0, fac_commoners,[itm_sarranid_common_dress,       itm_blue_hose,      itm_sarranid_felt_head_cloth_b],     def_attrib|level(5),wp(20),knows_inventory_management_10, woman_face_1, woman_face_2],


#Town Mayors    #itm_courtly_outfit itm_gambeson itm_blue_gambeson itm_red_gambeson itm_nobleman_outfit itm_rich_outfit
  ["town_1_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_tem, itm_bishop_coif_tem, itm_religious_boots], def_attrib|level(2),wp(20),knows_common, swadian_face_middle_1, swadian_face_older_2],
  ["town_2_mayor", "Archbishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_archbishop_hos,   itm_archbishop_coif_hos,    itm_religious_boots],   def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_3_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,    itm_mufti_turban,   itm_leather_boots], def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_4_mayor", "Archbishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_archbishop_tem,  itm_archbishop_coif_tem,     itm_religious_boots],     def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_5_mayor", "Grand Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,   itm_mufti_turban,  itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_6_mayor", "Archbishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_archbishop_tem,  itm_archbishop_coif_tem,     itm_religious_boots],   def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_7_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_tem, itm_bishop_coif_tem, itm_religious_boots],   def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_8_mayor", "Archbishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_archbishop_hos,   itm_archbishop_coif_hos,    itm_religious_boots],   def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_9_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_hos, itm_bishop_coif_hos, itm_religious_boots], def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_10_mayor", "Grand Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,  itm_mufti_turban,   itm_blue_hose],     def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_11_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_hos, itm_bishop_coif_hos, itm_religious_boots],   def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_12_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_hos, itm_bishop_coif_hos, itm_religious_boots], def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_13_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,  itm_mufti_turban,  itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_14_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,   itm_mufti_turban,   itm_blue_hose],     def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_15_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,   itm_mufti_turban,  itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_16_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_tem, itm_bishop_coif_tem, itm_religious_boots], def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_17_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,  itm_mufti_turban,  itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_18_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,   itm_mufti_turban,   itm_blue_hose],     def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_19_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,  itm_mufti_turban,   itm_sarranid_boots_a],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_20_mayor", "Bishop", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_bishop_tem, itm_bishop_coif_tem, itm_religious_boots], def_attrib|level(2),wp(20),knows_common,  swadian_face_middle_1, swadian_face_older_2],
  ["town_21_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,  itm_mufti_turban,  itm_sarranid_boots_a],   def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],
  ["town_22_mayor", "Mufti", "{!}Guild_Master", tf_hero|tf_randomize_face, 0,reserved,  fac_neutral,[itm_mufti_tunic,   itm_mufti_turban,   itm_sarranid_boots_a],     def_attrib|level(2),wp(20),knows_common,  khergit_face_middle_1, khergit_face_older_2],


#Village stores
  ["village_1_elder", "Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,            khergit_face_middle_1, khergit_face_older_2],
  ["village_2_elder", "Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_3_elder", "Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_4_elder", "Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,        swadian_face_middle_1, swadian_face_older_2],
  ["village_5_elder", "Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                      swadian_face_middle_1, swadian_face_older_2],
  ["village_6_elder", "Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                          swadian_face_middle_1, swadian_face_older_2],
  ["village_7_elder", "Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_8_elder", "Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,        swadian_face_middle_1, swadian_face_older_2],
  ["village_9_elder", "Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,         khergit_face_middle_1, khergit_face_older_2],
  ["village_10_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_11_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_12_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_13_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_14_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_15_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,            khergit_face_middle_1, khergit_face_older_2],
  ["village_16_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_17_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_18_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_19_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,            swadian_face_middle_1, swadian_face_older_2],
  ["village_20_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10, swadian_face_middle_1, swadian_face_older_2],
  ["village_21_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_22_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_23_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,            swadian_face_middle_1, swadian_face_older_2],
  ["village_24_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_25_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                      swadian_face_middle_1, swadian_face_older_2],
  ["village_26_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_27_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,        swadian_face_middle_1, swadian_face_older_2],
  ["village_28_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_29_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                          swadian_face_middle_1, swadian_face_older_2],
  ["village_30_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_31_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_32_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_33_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_34_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_35_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_36_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_37_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_38_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_39_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_40_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_41_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_42_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_43_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_44_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_45_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_46_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_47_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_48_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                          swadian_face_middle_1, swadian_face_older_2],
  ["village_49_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_50_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_51_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_52_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_53_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,            khergit_face_middle_1, khergit_face_older_2],
  ["village_54_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_55_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_56_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_57_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_58_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_59_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_60_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_61_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_62_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_63_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_64_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_65_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_66_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_67_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_68_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_69_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_70_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_71_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_72_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10, swadian_face_middle_1, swadian_face_older_2],
  ["village_73_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_74_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10, swadian_face_middle_1, swadian_face_older_2],
  ["village_75_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10, swadian_face_middle_1, swadian_face_older_2],
  ["village_76_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_77_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_78_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_79_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_80_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10, khergit_face_middle_1, khergit_face_older_2],
  ["village_81_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_82_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_83_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_84_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_85_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_86_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_87_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_88_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                          swadian_face_middle_1, swadian_face_older_2],
  ["village_89_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_90_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_91_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_92_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_93_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_94_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_95_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_96_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_97_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                              swadian_face_middle_1, swadian_face_older_2],
  ["village_98_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,                          swadian_face_middle_1, swadian_face_older_2],
  ["village_99_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_100_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_101_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                         khergit_face_middle_1, khergit_face_older_2],
  ["village_102_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_103_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_tem, itm_priest_coif_tem, itm_boots_light_cru3],def_attrib|level(2),wp(20),knows_inventory_management_10,             swadian_face_middle_1, swadian_face_older_2],
  ["village_104_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_nomad_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,             khergit_face_middle_1, khergit_face_older_2],
  ["village_105_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_106_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_107_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
  ["village_108_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_hide_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                          khergit_face_middle_1, khergit_face_older_2],
  ["village_109_elder","Priest", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_priest_hos, itm_priest_coif_hos, itm_boots_light_cru4],def_attrib|level(2),wp(20),knows_inventory_management_10,                         swadian_face_middle_1, swadian_face_older_2],
  ["village_110_elder","Mufti", "{!}village_1_elder",tf_hero|tf_randomize_face|tf_is_merchant, 0,0, fac_commoners,[itm_mufti_tunic, itm_mufti_turban, itm_wrapping_boots],def_attrib|level(2),wp(20),knows_inventory_management_10,                              khergit_face_middle_1, khergit_face_older_2],
# Place extra merchants before this point
  ["merchants_end","merchants_end","merchants_end",tf_hero, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10,0],

  #Used for player enterprises
  ["town_1_master_craftsman", "{!}Town 1 Craftsman", "{!}Town 1 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000003a0c629346edb2335a82b6e300000000000d634a0000000000000000],
  ["town_2_master_craftsman", "{!}Town 2 Craftsman", "{!}Town 2 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x0000000f010811c92d3295e46a96c72300000000001f5a980000000000000000],
  ["town_3_master_craftsman", "{!}Town 3 Craftsman", "{!}Town 3 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x000000001b083203151d2ad5648e52b400000000001b172e0000000000000000],
  ["town_4_master_craftsman", "{!}Town 4 Craftsman", "{!}Town 4 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000001a10114f091b2c259cd4c92300000000000228dd0000000000000000],
  ["town_5_master_craftsman", "{!}Town 5 Craftsman", "{!}Town 5 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000000d1044c578598cd92b5256db00000000001f23340000000000000000],
  ["town_6_master_craftsman", "{!}Town 6 Craftsman", "{!}Town 6 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x000000001f046285493eaf1b048abcdb00000000001a8aad0000000000000000],
  ["town_7_master_craftsman", "{!}Town 7 Craftsman", "{!}Town 7 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x000000002b0052c34c549225619356d400000000001cc6e60000000000000000],
  ["town_8_master_craftsman", "{!}Town 8 Craftsman", "{!}Town 8 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,       itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x0000000fdb0c20465b6e51e8a12c82d400000000001e148c0000000000000000],
  ["town_9_master_craftsman", "{!}Town 9 Craftsman", "{!}Town 9 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000009f7005246071db236e296a45300000000001a8b0a0000000000000000],
  ["town_10_master_craftsman", "{!}Town 10 Craftsman", "{!}Town 10 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,     itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000009f71012c2456a921aa379321a000000000012c6d90000000000000000],
  ["town_11_master_craftsman", "{!}Town 11 Craftsman", "{!}Town 11 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,    itm_nomad_boots],   def_attrib|level(2),wp(20),knows_common, 0x00000009f308514428db71b9ad70b72400000000001dc9140000000000000000],
  ["town_12_master_craftsman", "{!}Town 12 Seneschal", "{!}Town 12 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,       itm_leather_boots], def_attrib|level(2),wp(20),knows_common, 0x00000009e90825863853a5b91cd71a5b00000000000598db0000000000000000],
  ["town_13_master_craftsman", "{!}Town 13 Seneschal", "{!}Town 13 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,     itm_woolen_hose],   def_attrib|level(2),wp(20),knows_common, 0x00000009fa0c708f274c8eb4c64e271300000000001eb69a0000000000000000],
  ["town_14_master_craftsman", "{!}Town 14 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000007590c3206155c8b475a4e439a00000000001f489a0000000000000000],
  ["town_15_master_craftsman", "{!}Town 15 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000007440022d04b2c6cb7d3723d5a00000000001dc90a0000000000000000],
  ["town_16_master_craftsman", "{!}Town 16 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe1,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000007680c3586054b8e372e4db65c00000000001db7230000000000000000],
  ["town_17_master_craftsman", "{!}Town 17 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe2,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x0000000766046186591b564cec85d2e200000000001e4cea0000000000000000],
  ["town_18_master_craftsman", "{!}Town 18 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe3,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x0000000e7e0075523a6aa9b6da61e8dd00000000001d96d30000000000000000],
  ["town_19_master_craftsman", "{!}Town 19 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe4,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000002408314852a432e88aaa42e100000000001e284e0000000000000000],
  ["town_20_master_craftsman", "{!}Town 20 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe5,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x000000001104449136e44cbd1c9352bc000000000005e8d10000000000000000],
  ["town_21_master_craftsman", "{!}Town 21 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe6,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000000131032d3351c6e43226ec96c000000000005b5240000000000000000],
  ["town_22_master_craftsman", "{!}Town 22 Seneschal", "{!}Town 14 Seneschal", tf_hero|tf_is_merchant, 0,reserved,  fac_neutral,[itm_village_robe,      itm_blue_hose],     def_attrib|level(2),wp(20),knows_common, 0x00000000200c658a5723b1a3148dc455000000000015ab920000000000000000],
  
  
  
# Chests
  ["zendar_chest","{!}Zendar Chest","{!}Zendar Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,
   [],def_attrib|level(18),wp(60),knows_common, 0],
  ["tutorial_chest_1","{!}Melee Weapons Chest","{!}Melee Weapons Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_tutorial_sword, itm_tutorial_axe, itm_tutorial_spear, itm_tutorial_club, itm_tutorial_battle_axe],def_attrib|level(18),wp(60),knows_common, 0],
  ["tutorial_chest_2","{!}Ranged Weapons Chest","{!}Ranged Weapons Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_tutorial_short_bow, itm_tutorial_arrows, itm_tutorial_crossbow, itm_tutorial_bolts, itm_tutorial_throwing_daggers],def_attrib|level(18),wp(60),knows_common, 0],
## CC
  ["bonus_chest_1","{!}Bonus Chest","{!}Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_khergit_guard_boots,itm_black_greaves,itm_strange_boots,itm_strange_short_sword,itm_sword_medieval_a],def_attrib|level(18),wp(60),knows_common, 0],
  ["bonus_chest_2","{!}Bonus Chest","{!}Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_khergit_guard_helmet,itm_black_helmet,itm_strange_helmet,itm_strange_sword,itm_bastard_sword_a],def_attrib|level(18),wp(60),knows_common, 0],
  ["bonus_chest_3","{!}Bonus Chest","{!}Bonus Chest",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[itm_khergit_guard_armor,itm_black_armor,itm_strange_armor,itm_strange_great_sword,itm_bastard_sword_b],def_attrib|level(18),wp(60),knows_common, 0],
## CC

  ["household_possessions","{!}household_possessions","{!}household_possessions",tf_hero|tf_inactive|tf_is_merchant, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_inventory_management_10, 0],  
  
# These are used as arrays in the scripts.
## CC
  ["temp_array_a","{!}temp_array_a","{!}temp_array_a",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_inventory_management_10, 0],
  ["temp_array_b","{!}temp_array_b","{!}temp_array_b",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_inventory_management_10, 0],
  ["temp_array_c","{!}temp_array_c","{!}temp_array_c",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_inventory_management_10, 0],
  ["stack_selection_amounts","{!}stack_selection_amounts","{!}stack_selection_amounts",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["stack_selection_ids","{!}stack_selection_ids","{!}stack_selection_ids",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["notification_menu_types","{!}notification_menu_types","{!}notification_menu_types",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["notification_menu_var1","{!}notification_menu_var1","{!}notification_menu_var1",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["notification_menu_var2","{!}notification_menu_var2","{!}notification_menu_var2",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["banner_background_color_array","{!}banner_background_color_array","{!}banner_background_color_array",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["multiplayer_data","{!}multiplayer_data","{!}multiplayer_data",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_inventory_management_10,0],
  ["book_read","{!}na","{!}na",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_common,0],
  ["book_reading_progress","{!}na","{!}na",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_common,0],
  ["mod_global_vars","{!}na","{!}na",tf_hero|tf_inactive,0,reserved,fac_neutral,[],def_attrib,0,knows_common,0],
  ## CC

# Add Extra Quest NPCs below this point  
  ["local_merchant","Local Merchant","Local Merchants",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_village_robe,itm_leather_boots,itm_dagger],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["tax_rebel","Peasant Rebel","Peasant Rebels",tf_guarantee_armor,0,reserved,fac_commoners,
   [itm_dagger,itm_pitch_fork,itm_club,itm_stones,itm_village_robe,itm_village_robe1,itm_village_robe2,itm_village_robe3,itm_village_robe4,itm_village_robe5,itm_village_robe6,itm_nomad_boots,itm_wrapping_boots],
   def_attrib|level(4),wp(60),knows_common,vaegir_face1, vaegir_face2],
  ["trainee_peasant","Peasant","Peasants",tf_guarantee_armor,0,reserved,fac_commoners,
   [itm_dagger,itm_pitch_fork,itm_club,itm_stones,itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6],
   def_attrib|level(4),wp(60),knows_common,vaegir_face1, vaegir_face2],
  ["fugitive","Nervous Man","Nervous Men",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6, itm_sword_arabian_small],
   def_attrib|str_24|agi_25|level(26),wp(180),knows_common|knows_power_throw_6|knows_power_strike_6|knows_ironflesh_9,man_face_middle_1, man_face_old_2],
   
  ["belligerent_drunk","Belligerent Drunk","Belligerent Drunks",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_beduin_turban1,itm_wrapping_boots,itm_sarranid_boots_a,itm_village_robe, itm_village_robe1,itm_village_robe2, itm_village_robe3,itm_village_robe4, itm_village_robe5,itm_village_robe6, itm_sword_arabian_small],
   def_attrib|str_20|agi_8|level(15),wp(120),knows_common|knows_power_strike_2|knows_ironflesh_9,    bandit_face1, bandit_face2],

  ["hired_assassin","Hashshashin","Hashshashin",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners, #they look like belligerent drunks
   [itm_armor_ayy1,itm_armor_ayy2,itm_armor_ayy3,itm_armor_ayy4,itm_armor_ayy5,itm_armor_ayy6,itm_armor_ayy7,itm_armor_ayy8,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_nomad_boots,itm_leather_boots,itm_sword_arabian_small],
   def_attrib|str_20|agi_16|level(20),wp(180),knows_common|knows_power_strike_5|knows_ironflesh_3,    bandit_face1, bandit_face2],

  ["fight_promoter","Rough-Looking Character","Rough-Looking Character",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_commoners,
   [itm_village_robe1, itm_nomad_boots,  itm_dagger],
   def_attrib|str_20|agi_16|level(20),wp(180),knows_common|knows_power_strike_5|knows_ironflesh_3,    bandit_face1, bandit_face2],

   
   
  ["spy","Ordinary Townsman","Ordinary Townsmen", tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse,0,0,fac_neutral,
   [itm_sword_arabian_small,itm_village_robe2,itm_leather_boots,itm_arabian_bandit1,itm_leather_gloves],
   def_attrib|agi_11|level(20),wp(130),knows_common,man_face_middle_1, man_face_older_2],
   
  ["spy_partner","Unremarkable Townsman","Unremarkable Townsmen", tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse,0,0,fac_neutral,
   [itm_sword_arabian_small,itm_village_robe4,itm_leather_boots,itm_arabian_bandit3,itm_leather_gloves],
   def_attrib|agi_11|level(10),wp(130),knows_common,vaegir_face1, vaegir_face2],

   ["nurse_for_lady","Nurse","Nurse",tf_female|tf_guarantee_armor,0,reserved,fac_commoners,
   [itm_sarranid_common_dress_b, itm_wrapping_boots],
   def_attrib|level(4),wp(60),knows_common,woman_face_1, woman_face_2],   
   ["temporary_minister","Minister","Minister",tf_guarantee_armor|tf_guarantee_boots,0,reserved,fac_commoners,
   [itm_nobleman_outfit, itm_wrapping_boots],
   def_attrib|level(4),wp(60),knows_common,man_face_middle_1, man_face_older_2], 

  # Kingdom Advisors here
  ["finances_array_this","finances_array_this","finances_array_this",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],
  ["finances_array_last","finances_array_last","finances_array_last",tf_hero|tf_inactive, 0,reserved,  fac_neutral,[],def_attrib|level(18),wp(60),knows_common, 0],   
   
   
##  ["conspirator","Conspirator","Conspirators", tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse,0,0,fac_neutral,
##   [itm_sword,itm_leather_jerkin,itm_leather_boots,itm_hunter,itm_leather_gloves],
##   def_attrib|agi_11|level(10),wp(130),knows_common,vaegir_face1, vaegir_face2],
##  ["conspirator_leader","Conspirator","Conspirators", tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_horse,0,0,fac_neutral,
##   [itm_sword,itm_leather_jerkin,itm_leather_boots,itm_hunter,itm_leather_gloves],
##   def_attrib|agi_11|level(10),wp(130),knows_common,vaegir_face1, vaegir_face2],
##  ["peasant_rebel","Peasant Rebel","Peasant Rebels",tf_guarantee_armor,0,reserved,fac_peasant_rebels,
##   [itm_cleaver,itm_knife,itm_pitch_fork,itm_sickle,itm_club,itm_stones,itm_leather_cap,itm_felt_hat,itm_felt_hat,itm_coarse_tunic,itm_nomad_boots,itm_wrapping_boots],
##   def_attrib|level(4),wp(60),knows_common,vaegir_face1, vaegir_face2],
##  ["noble_refugee","Noble Refugee","Noble Refugees",tf_guarantee_boots|tf_guarantee_armor,0,0,fac_noble_refugees,
##   [itm_sword,itm_leather_jacket,itm_hide_boots, itm_saddle_horse, itm_leather_jacket, itm_leather_cap],
##   def_attrib|level(9),wp(100),knows_common,swadian_face1, swadian_face2],
##  ["noble_refugee_woman","Noble Refugee Woman","Noble Refugee Women",tf_female|tf_guarantee_armor|tf_guarantee_boots,0,0,fac_noble_refugees,
##   [itm_knife,itm_dagger,itm_hunting_crossbow,itm_dress,itm_robe,itm_woolen_dress, itm_headcloth, itm_woolen_hood, itm_wrapping_boots],
##   def_attrib|level(3),wp(45),knows_common,refugee_face1,refugee_face2],


  ["quick_battle_6_player", "{!}quick_battle_6_player", "{!}quick_battle_6_player", tf_hero, 0, reserved,  fac_player_faction, [itm_padded_cloth,itm_nomad_boots, itm_splinted_leather_greaves, itm_skullcap, itm_sword_medieval_b,  itm_crossbow, itm_bolts, itm_plate_covered_round_shield],    knight_attrib_1,wp(130),knight_skills_1, 0x000000000008010b01f041a9249f65fd],

#Multiplayer ai troops
  ["swadian_crossbowman_multiplayer_ai","Swadian Crossbowman","Swadian Crossbowmen",tf_guarantee_all,0,0,fac_kingdom_1,
   [itm_bolts,itm_crossbow,itm_sword_medieval_a,itm_tab_shield_heater_b,
    itm_leather_jerkin,itm_leather_armor,itm_ankle_boots],
   def_attrib|level(19),wp_melee(90)|wp_crossbow(100),knows_common|knows_ironflesh_4|knows_athletics_6|knows_shield_5|knows_power_strike_3,swadian_face_young_1, swadian_face_old_2],
  ["swadian_infantry_multiplayer_ai","Swadian Infantry","Swadian Infantry",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_1,
   [itm_pike,itm_bastard_sword_a,
    itm_studded_leather_coat,itm_ankle_boots,itm_flat_topped_helmet],
   def_attrib|level(19),wp_melee(105),knows_common|knows_ironflesh_5|knows_shield_4|knows_power_strike_5|knows_athletics_4,swadian_face_middle_1, swadian_face_old_2],
  ["swadian_man_at_arms_multiplayer_ai","Swadian Man at Arms","Swadian Men at Arms",tf_mounted|tf_guarantee_all_wo_ranged,0,0,fac_kingdom_1,
   [itm_lance,itm_bastard_sword_a,itm_tab_shield_heater_cav_a,
    itm_mail_with_surcoat,itm_hide_boots,itm_norman_helmet,itm_hunter],
   def_attrib|level(19),wp_melee(100),knows_common|knows_riding_4|knows_ironflesh_4|knows_shield_4|knows_power_strike_4|knows_athletics_1,swadian_face_young_1, swadian_face_old_2],
  ["vaegir_archer_multiplayer_ai","Vaegir Archer","Vaegir Archers",tf_guarantee_all,0,0,fac_kingdom_2,
   [itm_arrows,itm_scimitar,itm_nomad_bow,
    itm_nomad_boots,itm_spiked_helmet,itm_nomad_cap],
   def_attrib|str_12|level(19),wp_melee(70)|wp_archery(110),knows_ironflesh_4|knows_power_draw_5|knows_athletics_6|knows_shield_2,vaegir_face_young_1, vaegir_face_older_2],
  ["vaegir_spearman_multiplayer_ai","Vaegir Spearman","Vaegir Spearmen",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_2,
   [itm_padded_leather,itm_nomad_boots,itm_spiked_helmet,itm_nomad_cap, itm_spear, itm_tab_shield_kite_b, itm_mace_1, itm_javelin],
   def_attrib|str_12|level(19),wp_melee(90),knows_ironflesh_4|knows_athletics_6|knows_power_throw_3|knows_power_strike_3|knows_shield_2,vaegir_face_young_1, vaegir_face_older_2],
  ["vaegir_horseman_multiplayer_ai","Vaegir Horseman","Vaegir Horsemen",tf_mounted|tf_guarantee_all_wo_ranged,0,0,fac_kingdom_2,
   [itm_battle_axe,itm_scimitar,itm_lance,itm_tab_shield_kite_cav_a,
     itm_studded_leather_coat,itm_lamellar_vest,itm_nomad_boots,itm_spiked_helmet,itm_saddle_horse],
   def_attrib|level(19),wp(100),knows_riding_4|knows_ironflesh_4|knows_power_strike_4|knows_shield_3,vaegir_face_young_1, vaegir_face_older_2],
  ["khergit_dismounted_lancer_multiplayer_ai","Khergit Dismounted Lancer","Khergit Dismounted Lancer",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_3,
   [itm_sword_khergit_4,itm_spiked_mace,itm_one_handed_war_axe_b,itm_one_handed_war_axe_a,itm_hafted_blade_a,itm_hafted_blade_b,itm_heavy_lance,itm_lance,
    itm_khergit_guard_helmet,itm_khergit_cavalry_helmet,itm_khergit_war_helmet,itm_lamellar_vest_khergit,itm_lamellar_armor,itm_khergit_leather_boots,itm_splinted_leather_greaves,itm_leather_gloves,itm_mail_mittens,itm_tab_shield_small_round_b,itm_tab_shield_small_round_c],
   def_attrib|level(23),wp(150),knows_riding_7|knows_power_strike_5|knows_power_draw_4|knows_power_throw_2|knows_ironflesh_5|knows_horse_archery_1,khergit_face_middle_1, khergit_face_older_2],
  ["khergit_veteran_horse_archer_multiplayer_ai","Khergit Horse Archer","Khergit Horse Archers",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_3,
   [itm_sword_khergit_3,itm_khergit_bow,itm_khergit_arrows,itm_tab_shield_small_round_b,
    itm_khergit_cavalry_helmet,itm_tribal_warrior_outfit,itm_khergit_leather_boots,itm_steppe_horse],
   def_attrib|level(21),wp(90)|wp_archery(150),knows_riding_6|knows_power_draw_5|knows_shield_2|knows_horse_archery_5,khergit_face_middle_1, khergit_face_older_2],
  ["khergit_lancer_multiplayer_ai","Khergit Lancer","Khergit Lancers",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_3,
   [itm_sword_khergit_4,itm_spiked_mace,itm_one_handed_war_axe_b,itm_one_handed_war_axe_a,itm_hafted_blade_a,itm_hafted_blade_b,itm_heavy_lance,itm_lance,
    itm_khergit_guard_helmet,itm_khergit_cavalry_helmet,itm_khergit_war_helmet,itm_lamellar_vest_khergit,itm_lamellar_armor,itm_khergit_leather_boots,itm_splinted_leather_greaves,itm_leather_gloves,itm_mail_mittens,itm_scale_gauntlets,itm_tab_shield_small_round_b,itm_tab_shield_small_round_c,itm_courser],
   def_attrib|level(23),wp(130),knows_riding_7|knows_power_strike_5|knows_power_draw_4|knows_power_throw_2|knows_ironflesh_5|knows_horse_archery_1,khergit_face_middle_1, khergit_face_older_2],
  ["nord_veteran_multiplayer_ai","Nord Footman","Nord Footmen",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_4,
   [itm_sword_viking_2,itm_one_handed_battle_axe_b,itm_two_handed_axe,itm_tab_shield_round_d,itm_throwing_axes,
    itm_nordic_helmet,itm_nordic_fighter_helmet,itm_mail_hauberk,itm_splinted_leather_greaves,itm_leather_boots,itm_leather_gloves],
   def_attrib|level(19),wp(130),knows_ironflesh_3|knows_power_strike_5|knows_power_throw_3|knows_athletics_5|knows_shield_3,nord_face_young_1, nord_face_older_2],
  ["nord_scout_multiplayer_ai","Nord Scout","Nord Scouts",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_4,
   [itm_javelin,itm_sword_viking_1,itm_two_handed_axe,itm_spear,itm_tab_shield_round_a,
    itm_skullcap,itm_nordic_archer_helmet,itm_leather_jerkin,itm_leather_boots,itm_saddle_horse],
   def_attrib|level(19),wp(100),knows_riding_5|knows_ironflesh_2|knows_power_strike_2|knows_shield_1|knows_horse_archery_2|knows_power_throw_3,nord_face_young_1, nord_face_older_2],
  ["nord_archer_multiplayer_ai","Nord Archer","Nord Archers",tf_guarantee_all,0,0,fac_kingdom_4,
   [itm_arrows,itm_two_handed_axe,itm_sword_viking_2,itm_short_bow,
    itm_leather_jerkin,itm_blue_tunic,itm_leather_boots,itm_nasal_helmet,itm_leather_cap],
   def_attrib|str_11|level(19),wp_melee(80)|wp_archery(110),knows_ironflesh_4|knows_power_strike_2|knows_shield_1|knows_power_draw_5|knows_athletics_6,nord_face_young_1, nord_face_old_2],
  ["rhodok_veteran_crossbowman_multiplayer_ai","Rhodok Crossbowman","Rhodok Crossbowmen",tf_guarantee_all,0,0,fac_kingdom_5,
   [itm_fighting_pick,itm_club_with_spike_head,itm_maul,itm_tab_shield_pavise_c,itm_heavy_crossbow,itm_bolts,
    itm_leather_cap,itm_padded_leather,itm_nomad_boots],
   def_attrib|level(19),wp_melee(100)|wp_crossbow(120),knows_common|knows_ironflesh_4|knows_shield_5|knows_power_strike_3|knows_athletics_6,rhodok_face_middle_1, rhodok_face_older_2],
  ["rhodok_veteran_spearman_multiplayer_ai","Rhodok Spearman","Rhodok Spearmen",tf_guarantee_all_wo_ranged,0,0,fac_kingdom_5,
   [itm_ashwood_pike,itm_war_spear,itm_pike,itm_club_with_spike_head,itm_sledgehammer,itm_tab_shield_pavise_c,itm_sword_medieval_a,
    itm_leather_cap,itm_byrnie,itm_ragged_outfit,itm_nomad_boots],
   def_attrib|level(19),wp(115),knows_common|knows_ironflesh_5|knows_shield_3|knows_power_strike_4|knows_athletics_3,rhodok_face_young_1, rhodok_face_older_2],
  ["rhodok_scout_multiplayer_ai","Rhodok Scout","Rhodok Scouts",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_5,
   #TODO: Change weapons, copied from Nord Scout
   [itm_sword_medieval_a,itm_tab_shield_heater_cav_a,itm_light_lance,itm_skullcap,itm_aketon_green,
    itm_ragged_outfit,itm_nomad_boots,itm_ankle_boots,itm_saddle_horse],
   def_attrib|level(19),wp(100),knows_riding_5|knows_ironflesh_2|knows_power_strike_2|knows_shield_1|knows_horse_archery_2|knows_power_throw_3,rhodok_face_young_1, rhodok_face_older_2],
  ["sarranid_infantry_multiplayer_ai","Sarranid Infantry","Sarranid Infantries",tf_guarantee_shield|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_kingdom_6,
   [itm_sarranid_mail_shirt,itm_sarranid_horseman_helmet,itm_sarranid_boots_b,itm_sarranid_boots_c,itm_splinted_leather_greaves,itm_arabian_sword_b,itm_mace_3,itm_spear,itm_tab_shield_kite_c],
   def_attrib|level(20),wp_melee(105),knows_common|knows_riding_3|knows_ironflesh_2|knows_shield_3,swadian_face_middle_1, swadian_face_old_2],
  ["sarranid_archer_multiplayer_ai","Sarranid Archer","Sarranid Archers",tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_kingdom_6,
   [itm_arrows,itm_nomad_bow,itm_arabian_sword_a,itm_archers_vest,itm_sarranid_boots_b,itm_sarranid_helmet1,itm_turban,itm_desert_turban],
   def_attrib|level(19),wp_melee(90)|wp_archery(100),knows_common|knows_riding_2|knows_ironflesh_1,swadian_face_young_1, swadian_face_old_2],
  ["sarranid_horseman_multiplayer_ai","Sarranid Horseman","Sarranid Horsemen",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_6,
   [itm_lance,itm_arabian_sword_b,itm_scimitar_b,itm_mace_4,itm_tab_shield_small_round_b,
    itm_sarranid_mail_shirt,itm_sarranid_boots_b,itm_sarranid_boots_c,itm_sarranid_horseman_helmet,itm_courser,itm_hunter],
   def_attrib|level(20),wp_melee(100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,swadian_face_young_1, swadian_face_old_2],

   
   
#Multiplayer troops (they must have the base items only, nothing else)
  ["swadian_crossbowman_multiplayer","Swadian Crossbowman","Swadian Crossbowmen",tf_guarantee_all,0,0,fac_kingdom_1,
   [itm_bolts,itm_crossbow,itm_sword_medieval_b_small,itm_tab_shield_heater_a,itm_red_shirt,itm_ankle_boots],
   def_attrib_multiplayer|level(19),wpe(90,60,180,90),knows_common|knows_ironflesh_2|knows_athletics_5|knows_shield_5|knows_power_strike_2|knows_riding_1,swadian_face_young_1, swadian_face_old_2],
  ["swadian_infantry_multiplayer","Swadian Infantry","Swadian Infantry",tf_guarantee_all,0,0,fac_kingdom_1,
   [itm_sword_medieval_a,itm_tab_shield_heater_a,itm_red_tunic,itm_ankle_boots],
   def_attrib_multiplayer|level(20),wpex(105,130,110,40,60,110),knows_common|knows_ironflesh_5|knows_shield_4|knows_power_strike_4|knows_power_throw_2|knows_athletics_6|knows_riding_1,swadian_face_middle_1, swadian_face_old_2],
  ["swadian_man_at_arms_multiplayer","Swadian Man at Arms","Swadian Men at Arms",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_1,
   [itm_lance,itm_sword_medieval_a,itm_tab_shield_heater_a,
    itm_red_tunic,itm_ankle_boots,itm_saddle_horse],
   def_attrib_multiplayer|level(20),wp_melee(110),knows_common|knows_riding_5|knows_ironflesh_3|knows_shield_2|knows_power_throw_2|knows_power_strike_3|knows_athletics_3,swadian_face_young_1, swadian_face_old_2],
#  ["swadian_mounted_crossbowman_multiplayer","Swadian Mounted Crossbowman","Swadian Mounted Crossbowmen",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_1,
#   [itm_bolts,itm_light_crossbow,itm_tab_shield_heater_cav_a,itm_bastard_sword_a,
#    itm_red_shirt,itm_hide_boots,itm_saddle_horse],
#   def_attrib_multiplayer|level(20),wp_melee(100)|wp_crossbow(120),knows_common|knows_riding_4|knows_shield_3|knows_ironflesh_3|knows_horse_archery_2|knows_power_strike_3|knows_athletics_2|knows_shield_2,swadian_face_young_1, swadian_face_old_2],
  ["vaegir_archer_multiplayer","Vaegir Archer","Vaegir Archers",tf_guarantee_all,0,0,fac_kingdom_2,
   [itm_arrows,itm_scimitar,itm_nomad_bow,
    itm_hide_boots],
   def_attrib_multiplayer|str_12|level(19),wpe(80,150,60,80),knows_ironflesh_2|knows_power_draw_6|knows_athletics_4|knows_shield_2|knows_riding_1,vaegir_face_young_1, vaegir_face_older_2],
  ["vaegir_spearman_multiplayer","Vaegir Spearman","Vaegir spearman",tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_ranged|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_spear, itm_tab_shield_kite_a, itm_mace_1,
    itm_hide_boots],
   def_attrib_multiplayer|str_12|level(19),wpex(110,100,130,30,50,120),knows_ironflesh_4|knows_shield_2|knows_power_throw_3|knows_power_strike_3|knows_athletics_6|knows_riding_1,vaegir_face_young_1, vaegir_face_older_2],
  ["vaegir_horseman_multiplayer","Vaegir Horseman","Vaegir Horsemen",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_2,
   [itm_scimitar,itm_lance,itm_tab_shield_kite_cav_a,
    itm_hide_boots,itm_saddle_horse],
   def_attrib_multiplayer|level(19),wpe(110,90,60,110),knows_riding_5|knows_ironflesh_3|knows_power_strike_2|knows_shield_3|knows_power_throw_2,vaegir_face_young_1, vaegir_face_older_2],
  ["khergit_veteran_horse_archer_multiplayer","Khergit Horse Archer","Khergit Horse Archers",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_3,
   [itm_sword_khergit_1,itm_nomad_bow,itm_arrows,
    itm_khergit_armor,itm_leather_steppe_cap_a,itm_hide_boots,itm_steppe_horse],
   def_attrib_multiplayer|level(21),wpe(70,130,60,100),knows_riding_2|knows_power_draw_3|knows_horse_archery_2|knows_athletics_4,khergit_face_middle_1, khergit_face_older_2],
  ["khergit_lancer_multiplayer","Khergit Lancer","Khergit Lancers",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_3,
   [itm_sword_khergit_1,itm_lance,itm_tab_shield_small_round_a,
    itm_khergit_armor,itm_leather_steppe_cap_a,itm_hide_boots,itm_steppe_horse],
   def_attrib_multiplayer|level(21),wp(115),knows_riding_6|knows_ironflesh_3|knows_power_throw_3|knows_shield_4|knows_power_strike_3|knows_athletics_5,khergit_face_middle_1, khergit_face_older_2],
  ["nord_archer_multiplayer","Nord Archer","Nord Archers",tf_guarantee_all,0,0,fac_kingdom_4,
   [itm_arrows,itm_sword_viking_2_small,itm_short_bow,
    itm_blue_tunic,itm_leather_boots],
   def_attrib_multiplayer|str_11|level(15),wpe(90,150,60,80),knows_ironflesh_2|knows_power_strike_2|knows_shield_2|knows_power_draw_5|knows_athletics_4|knows_riding_1,nord_face_young_1, nord_face_old_2],
  ["nord_veteran_multiplayer","Nord Huscarl","Nord Huscarls",tf_guarantee_all,0,0,fac_kingdom_4,
   [itm_sword_viking_1,itm_one_handed_war_axe_a,itm_tab_shield_round_a,
    itm_blue_tunic,itm_leather_boots],
   def_attrib_multiplayer|level(24),wpex(110,135,100,40,60,140),knows_ironflesh_4|knows_power_strike_5|knows_power_throw_4|knows_athletics_6|knows_shield_3|knows_riding_1,nord_face_young_1, nord_face_older_2],
  ["nord_scout_multiplayer","Nord Scout","Nord Scouts",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_4,
   [itm_javelin,itm_sword_viking_1,itm_spear,itm_tab_shield_small_round_a,
    itm_blue_tunic,itm_leather_boots,itm_saddle_horse],
   def_attrib_multiplayer|level(19),wp(105),knows_riding_6|knows_ironflesh_2|knows_power_strike_2|knows_shield_1|knows_horse_archery_2|knows_power_throw_3|knows_athletics_3,vaegir_face_young_1, vaegir_face_older_2],
  ["rhodok_veteran_crossbowman_multiplayer","Rhodok Crossbowman","Rhodok Crossbowmen",tf_guarantee_all,0,0,fac_kingdom_5,
   [itm_crossbow,itm_bolts,itm_fighting_pick,itm_tab_shield_pavise_a,
    itm_tunic_with_green_cape,itm_ankle_boots],
   def_attrib_multiplayer|level(20),wpe(100,60,180,90),knows_common|knows_ironflesh_2|knows_shield_2|knows_power_strike_2|knows_athletics_5|knows_riding_1,rhodok_face_middle_1, rhodok_face_older_2],
  ["rhodok_sergeant_multiplayer","Rhodok Sergeant","Rhodok Sergeants",tf_guarantee_all,0,0,fac_kingdom_5,
   [itm_fighting_pick,itm_tab_shield_pavise_a,itm_spear,
    itm_green_tunic,itm_ankle_boots],
   def_attrib_multiplayer|level(20),wpex(110,100,140,30,50,110),knows_common|knows_ironflesh_4|knows_shield_5|knows_power_strike_4|knows_power_throw_1|knows_athletics_6|knows_riding_1,rhodok_face_middle_1, rhodok_face_older_2],
  ["rhodok_horseman_multiplayer","Rhodok Horseman","Rhodok Horsemen",tf_guarantee_all,0,0,fac_kingdom_5,
   [itm_sword_medieval_a,itm_tab_shield_heater_cav_a, itm_light_lance, 
    itm_green_tunic,itm_ankle_boots,itm_saddle_horse],
   def_attrib_multiplayer|level(20),wp(100),knows_riding_4|knows_ironflesh_3|knows_shield_2|knows_power_strike_2|knows_power_throw_1|knows_athletics_3,rhodok_face_middle_1, rhodok_face_older_2],
  ["sarranid_archer_multiplayer","Sarranid Archer","Sarranid Archers",tf_guarantee_all,0,0,fac_kingdom_6,
   [itm_arrows,itm_arabian_sword_a,itm_nomad_bow,
    itm_sarranid_cloth_robe, itm_sarranid_boots_b],
   def_attrib_multiplayer|str_12|level(19),wpe(80,150,60,80),knows_ironflesh_2|knows_power_draw_5|knows_athletics_5|knows_shield_2|knows_riding_1,vaegir_face_young_1, vaegir_face_older_2],
  ["sarranid_footman_multiplayer","Sarranid Footman","Sarranid footman",tf_guarantee_all,0,0,fac_kingdom_6,
   [itm_bamboo_spear, itm_tab_shield_kite_a, itm_arabian_sword_a,
    itm_sarranid_cloth_robe, itm_sarranid_boots_b],
   def_attrib_multiplayer|str_12|level(19),wpex(110,100,130,30,50,120),knows_ironflesh_4|knows_shield_2|knows_power_throw_3|knows_power_strike_3|knows_athletics_6|knows_riding_1,vaegir_face_young_1, vaegir_face_older_2],
  ["sarranid_mamluke_multiplayer","Sarranid Mamluke","Sarranid Mamluke",tf_mounted|tf_guarantee_all,0,0,fac_kingdom_6,
   [itm_arabian_sword_a,itm_lance,itm_tab_shield_small_round_a,
    itm_sarranid_cloth_robe, itm_sarranid_boots_b,itm_saddle_horse],
   def_attrib_multiplayer|level(19),wpe(110,90,60,110),knows_riding_5|knows_ironflesh_3|knows_power_strike_2|knows_shield_3|knows_power_throw_2,vaegir_face_young_1, vaegir_face_older_2],

  ["multiplayer_end","{!}multiplayer_end","{!}multiplayer_end", 0, 0, 0, fac_kingdom_5, [], 0, 0, 0, 0, 0],

  #replacable troop, not used
  ["nurse","Nurse","{!}nurse",tf_hero|tf_female|tf_unmoveable_in_party_window,0,reserved,fac_kingdom_1, [      itm_lady_dress_ruby ,   itm_turret_hat_ruby,    itm_leather_boots],     def_attrib|level(2),wp(50),knows_common|knows_riding_2, 0x000000055910200107632d675a92b92d00000000001e45620000000000000000],
  #erase later added to avoid errors

#Player history array
  ["log_array_entry_type",            "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_entry_time",            "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_actor",                 "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_center_object",         "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_center_object_lord",    "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_center_object_faction", "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_troop_object",          "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_troop_object_faction",  "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],
  ["log_array_faction_object",        "{!}Local Merchant","{!}Local Merchant",tf_guarantee_boots|tf_guarantee_armor, 0,0, fac_commoners,[itm_leather_apron,itm_leather_boots,itm_butchering_knife],def_attrib|level(5),wp(40),knows_power_strike_1, merchant_face_1, merchant_face_2],

#  ["quick_battle_troop_1","Rodrigo de Braganca","Rodrigo de Braganca", tf_hero,0,0,fac_kingdom_1,
#   [itm_long_hafted_knobbed_mace, itm_wooden_shield, itm_iron_staff, itm_throwing_daggers,
#    itm_felt_hat, itm_fur_coat, itm_light_leather_boots, itm_leather_gloves],
#   str_9|agi_15|int_12|cha_12|level(15),wpex(109,33,132,15,32,100),knows_riding_3|knows_athletics_5|knows_shield_3|knows_weapon_master_3|knows_power_throw_3|knows_power_strike_2|knows_ironflesh_3,0x0000000e240070cd598bb02b9556428c00000000001eabce0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_2","Usiatra","Usiatra", tf_hero|tf_female,0,0,fac_kingdom_1,
#   [itm_nomad_bow, itm_barbed_arrows, itm_scimitar, itm_tab_shield_small_round_c, itm_sumpter_horse,
#    itm_leather_armor, itm_splinted_greaves],
#   str_12|agi_14|int_11|cha_18|level(22),wpex(182,113,112,159,82,115),knows_horse_archery_2|knows_riding_3|knows_athletics_4|knows_shield_2|knows_weapon_master_4|knows_power_draw_2|knows_power_throw_1|knows_power_strike_3|knows_ironflesh_4,0x000000007f004000719b69422165b71300000000001d5d1d0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_3","Hegen","Hegen", tf_hero,0,0,fac_kingdom_1,
#   [itm_heavy_lance, itm_sword_two_handed_b, itm_sword_medieval_c, itm_warhorse,
#    itm_guard_helmet, itm_mail_mittens, itm_mail_boots],
#   str_18|agi_16|int_12|cha_11|level(24),wpex(90,152,102,31,33,34),knows_riding_5|knows_athletics_5|knows_shield_3|knows_weapon_master_5|knows_power_strike_6|knows_ironflesh_6,0x000000018000324428db8a431491472400000000001e44a90000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_4","Konrad","Konrad", tf_hero,0,0,fac_kingdom_1,
#   [itm_sword_two_handed_a, itm_mace_4, itm_tab_shield_kite_d,
#     itm_scale_armor, itm_mail_mittens, itm_mail_boots],
#   str_18|agi_15|int_12|cha_12|level(24),wpex(130,150,130,30,50,90),knows_riding_2|knows_athletics_5|knows_shield_4|knows_weapon_master_5|knows_power_throw_3|knows_power_strike_6|knows_ironflesh_6,0x000000081700205434db6df4636db8e400000000001db6e30000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_5","Sverre","Sverre", tf_hero,0,0,fac_kingdom_1,
#   [itm_long_axe, itm_sword_viking_1, itm_light_throwing_axes, itm_tab_shield_round_d,
#    itm_nordic_fighter_helmet, itm_byrnie, itm_leather_gloves, itm_leather_boots],
#   str_15|agi_15|int_12|cha_12|level(21),wpex(110,130,110,80,15,110),knows_riding_1|knows_athletics_5|knows_shield_4|knows_weapon_master_5|knows_power_draw_2|knows_power_throw_4|knows_power_strike_5|knows_ironflesh_5,0x000000048a00024723134e24cb51c91b00000000001dc6aa0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_6","Borislav","Borislav", tf_hero,0,0,fac_kingdom_1,
#   [itm_strong_bow, itm_barbed_arrows, itm_barbed_arrows, itm_shortened_spear,
#    itm_leather_warrior_cap, itm_leather_jerkin, itm_leather_gloves, itm_ankle_boots],
#   str_12|agi_15|int_15|cha_9|level(18),wpex(70,70,100,140,15,100),knows_horse_archery_2|knows_riding_2|knows_athletics_5|knows_weapon_master_3|knows_power_draw_4|knows_power_throw_3|knows_power_strike_2|knows_ironflesh_2,0x000000089e00444415136e36e34dc8e400000000001d46d90000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_7","Stavros","Stavros", tf_hero,0,0,fac_kingdom_1,
#   [itm_heavy_crossbow, itm_bolts, itm_sword_medieval_b_small, itm_tab_shield_pavise_c,
#    itm_nasal_helmet, itm_padded_leather, itm_leather_gloves, itm_leather_boots],
#   str_12|agi_15|int_15|cha_12|level(21),wpex(100,70,70,30,140,80),knows_horse_archery_2|knows_riding_2|knows_athletics_5|knows_shield_3|knows_weapon_master_5|knows_power_throw_2|knows_power_strike_4|knows_ironflesh_4,0x0000000e1400659226e34dcaa46e36db00000000001e391b0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_8","Gamara","Gamara", tf_hero|tf_female,0,0,fac_kingdom_1,
#   [itm_throwing_spears, itm_throwing_spears, itm_scimitar, itm_leather_covered_round_shield,
#    itm_desert_turban, itm_leather_gloves, itm_sarranid_boots_b, itm_lamellar_vest],
#   str_12|agi_15|int_12|cha_12|level(18),wpex(100,40,100,85,15,130),knows_horse_archery_2|knows_riding_2|knows_athletics_5|knows_shield_2|knows_weapon_master_4|knows_power_draw_2|knows_power_throw_4|knows_power_strike_2|knows_ironflesh_2,0x000000015400300118d36636db6dc8e400000000001db6db0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_9","Aethrod","Aethrod", tf_hero,0,0,fac_kingdom_1,
#   [itm_nomad_bow, itm_barbed_arrows, itm_barbed_arrows, itm_scimitar_b,
#    itm_splinted_greaves, itm_lamellar_vest],
#   str_16|agi_21|int_12|cha_14|level(26),wpex(182,113,112,159,82,115),knows_horse_archery_2|knows_riding_2|knows_athletics_7|knows_shield_2|knows_weapon_master_4|knows_power_draw_7|knows_power_throw_3|knows_power_strike_3|knows_ironflesh_4,0x000000000000210536db6db6db6db6db00000000001db6db0000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_10","Zaira","Zaira", tf_hero|tf_female,0,0,fac_kingdom_1,
#   [itm_sarranid_cavalry_sword, itm_strong_bow, itm_bodkin_arrows, itm_bodkin_arrows, itm_arabian_horse_b,
#    itm_sarranid_felt_head_cloth_b, itm_sarranid_common_dress, itm_sarranid_boots_b],
#   str_13|agi_18|int_15|cha_9|level(18),wpex(126,19,23,149,41,26),knows_horse_archery_6|knows_riding_6|knows_weapon_master_2|knows_power_draw_4|knows_power_throw_1|knows_power_strike_4|knows_ironflesh_1,0x0000000502003001471a6a24dc6594cb00000000001da4840000000000000000, swadian_face_old_2],
#  ["quick_battle_troop_11","Argo Sendnar","Argo Sendnar", tf_hero,0,0,fac_kingdom_1,
#   [itm_morningstar, itm_tab_shield_round_d, itm_war_spear, itm_courser,
#    itm_leather_gloves, itm_fur_hat, itm_leather_boots, itm_leather_jacket],
#   str_15|agi_12|int_14|cha_20|level(28),wpex(101,35,136,15,17,19),knows_riding_4|knows_athletics_2|knows_shield_4|knows_weapon_master_4|knows_power_strike_5|knows_ironflesh_5,0x0000000e800015125adb702de3459a9c00000000001ea6d00000000000000000, swadian_face_old_2],
#  ["quick_battle_troops_end","{!}quick_battle_troops_end","{!}quick_battle_troops_end", 0, 0, 0, fac_kingdom_5, [], 0, 0, 0, 0, 0],

#batalla rapida #descripcion en module strings

  ["quick_battle_troop_1",  "King Baldwin IV",  "Baldwin IV",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_jer_lord,   itm_mail_boots1,               itm_lord_jer, itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,      itm_shield_knight_jer7,       itm_mask_jer],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x0000000000005000479249d79b55a15600000000001cc4a60000000000000000],
  ["quick_battle_troop_2",  "Prince Bohemond III",  "Bohemond III",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_ant2,    itm_mail_boots1,              itm_knight_ant8, itm_mail_mittens1,      itm_sword_medieval_a2,itm_lance_banner_ant,      itm_shield_knight_ant7,      itm_helm_red],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x000000060610100258e26aa58c80b00b00000000001d36660000000000000000],
  ["quick_battle_troop_3",  "Sultan Kilij Arslan II",  "Kilij Arslan II",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_sel_lord,   itm_mail_boots1,               itm_boots_cav_sel1,           itm_mamluk_sel3,  itm_gauntlets_sar1,       itm_scimitar3,itm_lance_banner_sar,              itm_shield_ayycav5,       itm_helm_sel3],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x00000001bf1044c168e9713b634d96e200000000001eab420000000000000000],
  ["quick_battle_troop_4",  "Gandmaster Gerard de Ridefort",  "Gerard de Ridefort",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_tem_lord,   itm_mail_boots1,                 itm_lord_tem,  itm_mail_mittens1,    itm_sword_medieval_tem, itm_lance_banner_tem,          itm_shield_knight_tem3,    itm_helm_tem],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x00000004cc101252491e8dc9632a14d400000000001c476a0000000000000000],
  ["quick_battle_troop_5",  "Gandmaster Roger de Moulins",  "Roger de Moulins",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_hos_lord,   itm_mail_boots1,   itm_lord_hos,  itm_mail_mittens1,         itm_sword_medieval_hos, itm_lance_banner_hos,        itm_shield_knight_hos4,        itm_helm_hos],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x000000018a0411d22b1355ab6a78d50c00000000001ec8ae0000000000000000],
  ["quick_battle_troop_6",  "Sultan Salah al-Din",  "Salah al-Din",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_ayy_lord,   itm_boots_cav_ayy2,      itm_lord_sar,    itm_gauntlets_sar2,   itm_scimitar2,itm_lance_banner_sar,    itm_shield_ayycav2, itm_helmet_lord_sar],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x000000023f004347471a8e34d345b91b00000000001db4da0000000000000000],
  ["quick_battle_troop_7",  "Baron Balian d'Ibelin",  "Balian d'Ibelin",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_jer2,   itm_mail_boots1,        itm_knight_jer4,           itm_helm_jer,    itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,        itm_shield_knight_jer7],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x000000003904514925752d469b4dea7d00000000001e37310000000000000000],
  ["quick_battle_troop_8",  "Master Arn de Gothia",  "Arn de Gothia",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_tem2,   itm_mail_boots1,  itm_knight_tem3,   itm_helm_tem, itm_mail_mittens1, itm_sword_medieval_tem,itm_lance_banner_tem, itm_shield_knight_tem3],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x0000000000041144395c4d27d576234b00000000001c370a0000000000000000],
  ["quick_battle_troop_9",  "Baron Renaud de Chatillon",  "Renaud de Chatillon",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_jer2,   itm_mail_boots1,        itm_knight_jer4,           itm_helm_jer,    itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,        itm_shield_knight_jer7],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x00000001980c12811253e51b2faec76d00000000001dc8cb0000000000000000],
  ["quick_battle_troop_10",  "Baron Raymond de Tripoli",  "Raymond de Tripoli",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_jer2,   itm_mail_boots1,        itm_knight_jer4,           itm_helm_jer,    itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,        itm_shield_knight_jer7],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x000000064a001005589394964ef5c26500000000001f291b0000000000000000],
  ["quick_battle_troop_11",  "Baron Guy de Lusignan",  "Guy de Lusignan",  tf_hero, 0,reserved,  fac_kingdom_1,
  [itm_horse_jer2,   itm_mail_boots1,        itm_knight_jer4,           itm_helm_jer,    itm_mail_mittens1,    itm_sword_medieval_a1,itm_lance_banner_jer,        itm_shield_knight_jer7],
   knight_attrib_3,wp(180),knight_skills_3|knows_trainer_3|knows_shield_3, 0x0000000029003507269c71a7a26ea32c00000000001ee51a0000000000000000],
  ["quick_battle_troops_end","{!}quick_battle_troops_end","{!}quick_battle_troops_end", 0, 0, 0, fac_kingdom_5, [], 0, 0, 0, 0, 0],   

  ["tutorial_fighter_1","Novice Fighter","Fighters",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|level(1),wp_melee(10),knows_athletics_1|knows_ironflesh_2|knows_shield_2,0x000000088c1073144252b1929a85569300000000000496a50000000000000000, vaegir_face_older_2],
  ["tutorial_fighter_2","Novice Fighter","Fighters",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|level(1),wp_melee(10),knows_athletics_1|knows_ironflesh_2|knows_shield_2,0x000000088b08049056ab56566135c46500000000001dda1b0000000000000000, vaegir_face_older_2],
  ["tutorial_fighter_3","Regular Fighter","Fighters",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|level(9),wp_melee(50),knows_athletics_1|knows_ironflesh_2|knows_shield_2,0x00000008bc00400654914a3b0d0de74d00000000001d584e0000000000000000, vaegir_face_older_2],
  ["tutorial_fighter_4","Veteran Fighter","Fighters",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|level(16),wp_melee(110),knows_athletics_1|knows_ironflesh_3|knows_power_strike_2|knows_shield_2,0x000000089910324a495175324949671800000000001cd8ab0000000000000000, vaegir_face_older_2],
  ["tutorial_archer_1","Archer","Archers",tf_guarantee_ranged|tf_guarantee_boots|tf_guarantee_armor,0,0,fac_kingdom_2,
   [itm_leather_jerkin,itm_nomad_boots,itm_vaegir_spiked_helmet,itm_vaegir_fur_helmet,itm_vaegir_fur_cap,itm_nomad_cap],
   def_attrib|str_12|level(19),wp_melee(70)|wp_archery(110),knows_ironflesh_1|knows_power_draw_2|knows_athletics_2|knows_power_throw_1,vaegir_face_young_1, vaegir_face_older_2],
  ["tutorial_master_archer","Archery Trainer","Archery Trainer",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|str_12|level(19),wp_melee(70)|wp_archery(110),knows_ironflesh_1|knows_power_draw_2|knows_athletics_2|knows_power_throw_1,0x0000000ea508540642f34d461d2d54a300000000001d5d9a0000000000000000, vaegir_face_older_2],
  ["tutorial_rider_1","Rider","{!}Vaegir Knights",tf_mounted|tf_guarantee_boots|tf_guarantee_gloves|tf_guarantee_armor|tf_guarantee_helmet|tf_guarantee_horse|tf_guarantee_shield,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_hunter, itm_saddle_horse,itm_leather_gloves],
   def_attrib|level(24),wp(130),knows_riding_4|knows_shield_2|knows_ironflesh_3|knows_power_strike_2,vaegir_face_middle_1, vaegir_face_older_2],
  ["tutorial_rider_2","Horse archer","{!}Khergit Horse Archers",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_ranged|tf_guarantee_horse,0,0,fac_kingdom_3,
   [itm_tribal_warrior_outfit,itm_nomad_robe,itm_hide_boots,itm_tab_shield_small_round_a,itm_steppe_horse],
   def_attrib|level(14),wp(80)|wp_archery(110),knows_riding_5|knows_power_draw_3|knows_ironflesh_1|knows_horse_archery_4|knows_power_throw_1,khergit_face_young_1, khergit_face_older_2],
  ["tutorial_master_horseman","Riding Trainer","Riding Trainer",tf_hero,0,0,fac_kingdom_2,
   [itm_green_tunic,itm_nomad_boots],
   def_attrib|str_12|level(19),wp_melee(70)|wp_archery(110),knows_ironflesh_1|knows_power_draw_2|knows_athletics_2|knows_power_throw_1,0x0000000ea0084140478a692894ba185500000000001d4af30000000000000000, vaegir_face_older_2],
   
  ["swadian_merchant", "Merchant of Praven", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_4, [itm_dagger,itm_village_robe1, itm_leather_boots], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],
  ["vaegir_merchant", "Merchant of Reyvadin", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_5, [itm_dagger,itm_village_robe2, itm_woolen_hose], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],
  ["khergit_merchant", "Merchant of Tulga", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_1, [itm_dagger,itm_village_robe3, itm_nomad_boots], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],
  ["nord_merchant", "Merchant of Sargoth", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_2, [itm_dagger,itm_village_robe4, itm_nomad_boots], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],
  ["rhodok_merchant", "Merchant of Jelkala", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_3, [itm_dagger,itm_village_robe5, itm_blue_hose], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],
  ["sarranid_merchant", "Merchant of Shariz", "{!}Prominent", tf_hero|tf_randomize_face, 0, reserved, fac_kingdom_6, [itm_dagger,itm_village_robe6, itm_sarranid_boots_a], def_attrib|level(2),wp(20),knows_common, man_face_middle_1, mercenary_face_2],       
  ["startup_merchants_end","startup_merchants_end","startup_merchants_end",tf_hero, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10,0],
 
  ["sea_raider_leader","Pirate Captain","Pirates Captain",tf_hero|tf_guarantee_all_wo_ranged,0,0,fac_outlaws,
   [itm_armor_ayy1,itm_beduin_turban1,itm_leather_boots,itm_scimitar,itm_shield_bandit1],
   def_attrib|level(21),wp_melee(120),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_3|knows_athletics_3,nord_face_young_1, nord_face_old_2],

  ["looter_leader","Bedouin Chief","Bedouins Chief",tf_hero|tf_mounted|tf_guarantee_horse|tf_guarantee_boots|tf_guarantee_helmet|tf_guarantee_armor,0,0,fac_outlaws,
   [itm_scimitar,itm_beduin_turban1,itm_boots_light_sar1,
    itm_shield_bandit1,itm_tunic_beduin3,itm_camel],
   def_attrib|level(9),wp(75),knows_common|knows_riding_4,0x00000001b80032473ac49738206626b200000000001da7660000000000000000, bandit_face2],
   
  ["bandit_leaders_end","bandit_leaders_end","bandit_leaders_end",tf_hero, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10,0],   
  
  ["relative_of_merchant", "Merchant's Brother", "{!}Prominent",tf_hero,0,0,fac_kingdom_2,
   [itm_village_robe5,itm_nomad_boots],
   def_attrib|level(1),wp_melee(10),knows_athletics_1|knows_ironflesh_2|knows_shield_2, 0x00000000320410022d2595495491afa400000000001d9ae30000000000000000, mercenary_face_2],   
   
  ["relative_of_merchants_end","relative_of_merchants_end","relative_of_merchants_end",tf_hero, 0,0, fac_commoners,[],def_attrib|level(2),wp(20),knows_inventory_management_10,0],
  ##diplomacy begin
  ["dplmc_chamberlain","Chamberlain", "Chamberlains",tf_hero|tf_male,0,0,fac_commoners,[itm_courtly_outfit, itm_leather_boots], def_attrib|level(10), wp(40),knows_inventory_management_10,0x0000000dfc0c238838e571c8d469c91b00000000001e39230000000000000000],

  ["dplmc_constable","Constable","Constables",tf_hero|tf_male,0,0,fac_commoners,[itm_rich_outfit, itm_leather_boots],
   knight_attrib_4,wp_melee(200),knows_common|knows_shield_3|knows_ironflesh_3|knows_power_strike_4|knows_athletics_4,0x0000000b4b1015054b1b4d591cba28d300000000001e472b0000000000000000],

  ["dplmc_chancellor","Chancellor","Chancellors",tf_hero|tf_male,0,0,fac_commoners,[itm_nobleman_outfit, itm_leather_boots],def_attrib|level(10), wp(40),knows_inventory_management_10, 0x00000009a20c21cf491bad28a28628d400000000001e371a0000000000000000],

  ["dplmc_messenger","Messenger","Messengers",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_neutral,
   [itm_sword_arabian_small,itm_armor_ayy1,itm_boots_average_sar1,itm_arabian1,itm_beduin_turban1],
   def_attrib|level(21),wp_melee(100)| wp_archery (100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,man_face_young_1,man_face_old_2],

  ["dplmc_scout","Scout","Scouts",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_neutral,
   [itm_sword_arabian_small,itm_armor_ayy2,itm_boots_average_sar1,itm_arabian1,itm_beduin_turban1],
   def_attrib|level(21),wp_melee(100)| wp_archery (100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,man_face_young_1,man_face_old_2],

# recruiter kit begin 
  ["dplmc_recruiter","Recruiter","Recruiter",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_neutral,
   [itm_sword_arabian_small,itm_armor_ayy3,itm_boots_average_sar1,itm_arabian1,itm_beduin_turban1],
   def_attrib|level(21),wp_melee(100)| wp_archery (100),knows_common|knows_riding_4|knows_ironflesh_2|knows_shield_2|knows_power_strike_3,swadian_face_young_1, swadian_face_old_2],
# recruiter kit end
  ##diplomacy end

#-## Outposts begin
 ["fort_walker","Patrol","Guards",tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_helmet,0,0,fac_player_faction,
   [itm_muslim_pike,itm_muslim_pike1,itm_fighting_axe,itm_falchion_sar,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10],
   def_attrib|level(9),wp(75),knows_common,khergit_face_younger_1, khergit_face_middle_2],
 ["fort_rider","Patrol","Guards",tf_mounted|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_horse,0,0,fac_player_faction,
   [itm_scimitar,itm_scimitar1,itm_beduin_turban1,itm_beduin_turban2,itm_beduin_turban3,itm_beduin_turban4,itm_boots_light_sar1,itm_boots_light_sar2,itm_arabian_bandit1,itm_arabian_bandit2,itm_arabian_bandit3,itm_arabian_bandit4,
    itm_shield_bandit1,itm_shield_bandit2,itm_shield_bandit3,itm_shield_bandit4,itm_shield_bandit5,itm_shield_bandit6,itm_tunic_sar1,itm_tunic_sar2,itm_tunic_sar3,itm_tunic_sar4,itm_tunic_sar5,itm_tunic_sar6,itm_tunic_sar7,itm_tunic_sar8,itm_tunic_sar9,itm_tunic_sar10],
   def_attrib|level(9),wp(75),knows_common|knows_riding_2,khergit_face_younger_1, khergit_face_middle_2],
 ["fort_slave","Slave","Slaves",0,0,0,fac_commoners,
   [itm_shirt],
   def_attrib|level(4),wp(20),knows_common,man_face_young_1, man_face_old_2],

  ["fort_captain","Fort Captain","Fort Captain",tf_hero|tf_male|tf_allways_fall_dead|tf_no_capture_alive|tf_guarantee_boots|tf_guarantee_armor|tf_guarantee_gloves|tf_guarantee_helmet|tf_guarantee_shield, scn_fort|entry(11),reserved,  fac_commoners,[itm_scimitar2,itm_mamluk_ayy2,itm_boots_cav_ayy2,itm_helm_ayy5,itm_gauntlets_sar2],knight_attrib_5|level(40),wp(150),knows_common,0x0000000a1a00200336db6db6db6db6db00000000001db6db0000000000000000, 0x0000000a1a00200336db6db6db6db6db00000000001db6db0000000000000000],
#-## Outposts end

####################################################################################################################################
# TOURNAMENT PLAY ENHANCEMENTS (BEGIN)
####################################################################################################################################
  # TPE 1.3 Additions
  ["tpe_presobj",                  "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,																																												[																																																																																																								],def_attrib|level(5),wp(40),knows_power_strike_1, 0],
  # Why: To remove needing so many global variables to track presentation objects.
  #["tpe_array_troop_joined",       "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,[],def_attrib|level(5),wp(40),knows_power_strike_1, 0],
  # Why: So that I can track who is actually fighting in a round so that those who weren't picked get averaged points added to them to be competitive.
  ["tpe_xp_table",                 "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,																																												[																																																																																																								],def_attrib|level(1),wp(40),knows_power_strike_1, 0],
  # Why: So that I can track who is actually fighting in a round so that those who weren't picked get averaged points added to them to be competitive.
  ["tpe_array_static_troops",      "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,																																												[																																																																																																								],def_attrib|level(5),wp(40),knows_power_strike_1, 0],
  # Why: This keeps the same static list of troop_ids throughout tournament.  Ie -> slot 1 = trp_somebody (throughout tournament rounds)
  ["tpe_array_sorted_troops",      "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,																																												[																																																																																																								],def_attrib|level(5),wp(40),knows_power_strike_1, 0],
  # Why: Sorting array for showing rankings without changing static troops.  Ie -> slot 1 = rank 1 = troop # associated with first agent
  ["tpe_array_tournament_stats",   "{!}Local Merchant","{!}Local Merchant",0,0,0, fac_commoners,																																												[																																																																																																								],def_attrib|level(5),wp(40),knows_power_strike_1, 0],
  # Why: So I can track stats going on in a round without the use of global variables for special awards.
  ["tpe_settings",          "TPE Persistent Settings",     "TPE Scaled Troops", 0,0,0, fac_kingdom_6,																																										[],str_15|agi_14|int_8|cha_16|level(1),wp(1),knows_power_strike_1, 0x000000000000710004820c24204c000200000000001d16100000000000000000, 0x000000003f00714049fefe393fffc7ff00000000001ef96f0000000000000000],
  ["tpe_appearance",        "TPE Appearance Settings",     "TPE Scaled Troops", 0,0,0, fac_kingdom_6,																																										[],str_15|agi_14|int_8|cha_16|level(1),wp(1),knows_power_strike_1, 0x000000000000710004820c24204c000200000000001d16100000000000000000, 0x000000003f00714049fefe393fffc7ff00000000001ef96f0000000000000000],
  ["tpe_weapons",           "TPE Weapon Definitions",      "TPE Scaled Troops", 0,0,0, fac_kingdom_6,																																										[],str_15|agi_14|int_8|cha_16|level(1),wp(1),knows_power_strike_1, 0x000000000000710004820c24204c000200000000001d16100000000000000000, 0x000000003f00714049fefe393fffc7ff00000000001ef96f0000000000000000],
  ["tpe_center_menus",      "TPE Appearance Menu Choices", "TPE Scaled Troops", 0,0,0, fac_kingdom_6,																																										[],str_15|agi_14|int_8|cha_16|level(1),wp(1),knows_power_strike_1, 0x000000000000710004820c24204c000200000000001d16100000000000000000, 0x000000003f00714049fefe393fffc7ff00000000001ef96f0000000000000000],
  ["tpe_options",           "TPE Player Settings",         "TPE Scaled Troops", 0,0,0, fac_kingdom_6,																																										[],str_15|agi_14|int_8|cha_16|level(1),wp(1),knows_power_strike_1, 0x000000000000710004820c24204c000200000000001d16100000000000000000, 0x000000003f00714049fefe393fffc7ff00000000001ef96f0000000000000000],
  
  # Level Scaled Troops
  ["tpe_generic_troop_1",          "TPE Scaled Troop 01","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x000000001d001141044c21928821245200000000001d22190000000000000000],
  ["tpe_generic_troop_2",          "TPE Scaled Troop 02","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x000000001d001141044c21928821245200000000001d22190000000000000000],
  ["tpe_generic_troop_3",          "TPE Scaled Troop 03","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x000000001d001141044c21928821245200000000001d22190000000000000000],
  ["tpe_generic_troop_4",          "TPE Scaled Troop 04","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000001d001141044c21928821245200000000001d22190000000000000000, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000],
  ["tpe_generic_troop_5",          "TPE Scaled Troop 05","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000001d001141044c21928821245200000000001d22190000000000000000, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000],
  ["tpe_generic_troop_6",          "TPE Scaled Troop 06","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000001d001141044c21928821245200000000001d22190000000000000000, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000],
  ["tpe_generic_troop_7",          "TPE Scaled Troop 07","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000],
  ["tpe_generic_troop_8",          "TPE Scaled Troop 08","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000],
  ["tpe_generic_troop_9",          "TPE Scaled Troop 09","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000],
  ["tpe_generic_troop_10",         "TPE Scaled Troop 10","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_11",         "TPE Scaled Troop 11","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_12",         "TPE Scaled Troop 12","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_13",         "TPE Scaled Troop 13","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_14",         "TPE Scaled Troop 14","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_15",         "TPE Scaled Troop 15","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000000002001355335371861249200000000001c96520000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_16",         "TPE Scaled Troop 16","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000000002001355335371861249200000000001c96520000000000000000],
  ["tpe_generic_troop_17",         "TPE Scaled Troop 17","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000000002001355335371861249200000000001c96520000000000000000],
  ["tpe_generic_troop_18",         "TPE Scaled Troop 18","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000000002001355335371861249200000000001c96520000000000000000],
  ["tpe_generic_troop_19",         "TPE Scaled Troop 19","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_20",         "TPE Scaled Troop 20","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_21",         "TPE Scaled Troop 21","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_22",         "TPE Scaled Troop 22","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_23",         "TPE Scaled Troop 23","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_24",         "TPE Scaled Troop 24","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x00000000190830ca209d69b4100906da00000000001e10e30000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_25",         "TPE Scaled Troop 25","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_26",         "TPE Scaled Troop 26","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_27",         "TPE Scaled Troop 27","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x0000000037002189497e97cb5fb27fff00000000001ff8370000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_28",         "TPE Scaled Troop 28","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000003f0052064deeffffffffffff00000000001efff90000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_29",         "TPE Scaled Troop 29","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000003f0052064deeffffffffffff00000000001efff90000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_30",         "TPE Scaled Troop 30","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000003f0052064deeffffffffffff00000000001efff90000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_31",         "TPE Scaled Troop 31","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000003f0052064deeffffffffffff00000000001efff90000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  ["tpe_generic_troop_32",         "TPE Scaled Troop 31","TPE Scaled Troops", 0,0,0, fac_commoners,																																												[],def_attrib|level(1),wp(1),knows_power_strike_1, 0x000000003f0052064deeffffffffffff00000000001efff90000000000000000, 0x0000000fc0000001124000000020000000000000001c00800000000000000000],
  
####################################################################################################################################
# TOURNAMENT PLAY ENHANCEMENTS (END)
####################################################################################################################################

####################################################################################################################################
# LAV MODIFICATIONS START (COMPANIONS OVERSEER MOD)
####################################################################################################################################
  ["companions_overview", "{!}Hidden", "{!}Hidden",tf_hero,0,0,0,[],def_attrib|level(1),wp(100),knows_inventory_management_10,0],
  ["companions_discard", "{!}Hidden", "{!}Hidden",tf_hero,0,0,0,[],def_attrib|level(1),wp(100),knows_inventory_management_10,0],
####################################################################################################################################
# LAV MODIFICATIONS END (COMPANIONS OVERSEER MOD)
####################################################################################################################################
]


#Troop upgrade declarations
upgrade(troops,"farmer", "watchman")
upgrade(troops,"townsman","watchman")
upgrade2(troops,"watchman","caravan_guard","mercenary_crossbowman")
upgrade2(troops,"caravan_guard","mercenary_swordsman","mercenary_horseman")
upgrade(troops,"mercenary_swordsman","hired_blade")
upgrade(troops,"mercenary_horseman","mercenary_cavalry")

upgrade(troops,"jerusalem_militia","jerusalem_footman")
upgrade2(troops,"jerusalem_footman","jerusalem_infantry","jerusalem_crossbowman")
upgrade(troops,"jerusalem_infantry","jerusalem_sergeant")
upgrade(troops,"jerusalem_crossbowman","jerusalem_veteran_crossbowman")

upgrade(troops,"jerusalem_squire","jerusalem_knight")

upgrade(troops,"antioch_militia","antioch_footman")
upgrade2(troops,"antioch_footman","antioch_infantry","antioch_crossbowman")
upgrade(troops,"antioch_infantry","antioch_sergeant")
upgrade(troops,"antioch_crossbowman","antioch_veteran_crossbowman")

upgrade(troops,"antioch_squire","antioch_knight")

upgrade(troops,"seljuk_militia","seljuk_footman")
upgrade2(troops,"seljuk_footman","seljuk_infantry","seljuk_archer")
upgrade(troops,"seljuk_infantry","seljuk_guard")
upgrade(troops,"seljuk_archer","seljuk_veteran_archer")

upgrade(troops,"seljuk_horseman","seljuk_mamluk")

upgrade(troops,"templar_militia","templar_footman")
upgrade2(troops,"templar_footman","templar_infantry","templar_crossbowman")
upgrade(troops,"templar_infantry","templar_sergeant")
upgrade(troops,"templar_crossbowman","templar_veteran_crossbowman")

upgrade(troops,"templar_squire","templar_knight")

upgrade(troops,"hospitaller_militia","hospitaller_footman")
upgrade2(troops,"hospitaller_footman","hospitaller_infantry","hospitaller_crossbowman")
upgrade(troops,"hospitaller_infantry","hospitaller_sergeant")
upgrade(troops,"hospitaller_crossbowman","hospitaller_veteran_crossbowman")

upgrade(troops,"hospitaller_squire","hospitaller_knight")

upgrade(troops,"ayyubid_militia","ayyubid_footman")
upgrade2(troops,"ayyubid_footman","ayyubid_infantry","ayyubid_archer")
upgrade(troops,"ayyubid_infantry","ayyubid_guard")
upgrade(troops,"ayyubid_archer","ayyubid_veteran_archer")

upgrade(troops,"ayyubid_horseman","ayyubid_mamluk")

#upgrade2(troops,"looter","mountain_bandit", "forest_bandit")

#upgrade2(troops,"bandit","brigand","mercenary_swordsman")

upgrade(troops,"manhunter","slave_driver")
upgrade(troops,"slave_driver","slave_hunter")
#upgrade(troops,"slave_hunter","slave_crusher")
#upgrade(troops,"slave_crusher","slaver_chief")

#upgrade(troops,"follower_woman","hunter_woman")
#upgrade(troops,"hunter_woman","fighter_woman")
#upgrade(troops,"fighter_woman","sword_sister")
#upgrade(troops,"refugee","follower_woman")
#upgrade(troops,"peasant_woman","follower_woman")

## CC
#upgrade2(troops,"dark_hunter","dark_knight","dark_sniper")
#upgrade2(troops,"black_khergit_horseman","black_khergit_lancer","black_khergit_guard")
## CC

# Custom Troops Begin
upgrade(troops,"custom_peasant","custom_army_recruit")
upgrade2(troops,"custom_army_recruit","custom_infantry", "custom_crossbow_militia")
upgrade(troops,"custom_infantry", "custom_warrior")
upgrade(troops,"custom_crossbow_militia","custom_crossbowman")

upgrade(troops,"custom_squire", "custom_knight")

upgrade(troops,"skill_priest_jer", "skill_bishop_jer")
upgrade(troops,"swadian_priest", "swadian_paladin")

upgrade(troops,"skill_priest_ant", "skill_bishop_ant")
upgrade(troops,"vaegir_knyaz", "vaegir_ivory_sentinel")

upgrade(troops,"skill_priest_tem", "skill_bishop_tem")
upgrade(troops,"nord_valkyrie", "nord_einherjar")

upgrade(troops,"skill_priest_hos", "skill_bishop_hos")
upgrade(troops,"rhodok_spear_knight", "rhodok_arbalest")

upgrade(troops,"skill_priest_teu", "skill_bishop_teu")

upgrade(troops,"skill_mufti_sel", "skill_grandmufti_sel")
upgrade(troops,"khergit_keshik", "khergit_guanren")

upgrade(troops,"skill_mufti_ayy", "skill_grandmufti_ayy")
upgrade(troops,"sarranid_spahbod_serden", "sarranid_zhayedan")

#upgrade2(troops,"custom_warrior", "custom_sergeant", "custom_heavy_sergeant")
#upgrade(troops,"custom_crossbow_militia","custom_crossbowman")
#upgrade2(troops,"custom_crossbowman","custom_pavise_crossbowman","custom_mounted_crossbowman")

# upgrade(troops,"ranger_acolyte","ranger_guide")
# upgrade(troops,"ranger_guide","ranger_woodswoman")
# upgrade(troops,"ranger_woodswoman","ranger_shieldmaiden")
# upgrade(troops,"ranger_shieldmaiden","ranger_huntress")
# Custom Troops End# modmerger_start version=201 type=2
try:
    component_name = "troops"
    var_set = { "troops" : troops }
    from modmerger import modmerge
    modmerge(var_set)
except:
    raise
# modmerger_end
